jQuery(document).ready(function(){
		
	jQuery("#slidingtabs_tinymce_dialog").dialog({
        autoOpen:false,
        buttons:{
            "Insert":function() {
                insertSlidingTabs();
            },
            "Cancel":function() {
                jQuery(this).dialog('close');
            }
        },
        open:function() {
			if (jQuery("#slidingtabs_tinymce_dialog tbody tr.selected").length==0) {
                jQuery("#slidingtabs_tinymce_dialog tbody tr:first").addClass("selected");
            }
        },
		width:500,
        height:"auto",
        draggable:false,
        resizable:false,
        title:"<strong>Embed Sliding Tabs</strong> &sdot; Select a entry and click <em>Insert</em> to add shortcode:",
		dialogClass:parseInt(jQuery().jquery.split(".")[1])===2 ? "ui-slidingtabs_dialog" : "ui-slidingtabs_dialog"}).find("tbody tr").click(function(event) {
			jQuery("#slidingtabs_tinymce_dialog tbody tr").removeClass("selected");
			jQuery(this).addClass("selected");
			return false;
		});
		
    function insertSlidingTabs() {
        var slidingtabs_id = jQuery("#slidingtabs_tinymce_dialog tbody tr.selected")[0].id.split("_")[2],
        	shortcode_str = " [slidingtabs id='" + slidingtabs_id + "'] ";
        
        if (typeof(tinyMCE)!="undefined" && (ed = tinyMCE.activeEditor) && !ed.isHidden()) {
            ed.focus();
            if (tinymce.isIE) {
                ed.selection.moveToBookmark(tinymce.EditorManager.activeEditor.windowManager.bookmark);
            }
            ed.execCommand("mceInsertContent", false, shortcode_str);
        } else {
            edInsertContent(edCanvas, shortcode_str);
        }
        
        jQuery("#slidingtabs_tinymce_dialog").dialog("close");
    }        
    
    // add the HTML editor button
	jQuery("#ed_toolbar").append('<input type="button" class="ed_button insertSlidingTabs" value="Sliding Tabs" />');
    jQuery("#ed_toolbar .insertSlidingTabs").click(function() {
        jQuery("#slidingtabs_tinymce_dialog").dialog("open");
    });
    
});