/***
 CUSTOM JAVASCRIPT FOR THE SLIDER TEMPLATE
***/
  
(function($) {
	function CustomMenu(container) {
		var $container = $(container),
			$tabsUl = $container.find("ul.st_tabs_ul"),
			$firstLi = $tabsUl.find("li").first(),
			$border,
			stObj = $container.slidingTabs(),
			pos = ($container.attr("class").indexOf("horizontal")!=-1) ? "left" : "top",
			liPos, offset;
				
		var menuBorder = {
			init: function() {
				$firstLi.append('<div class="st_border" />'); //Append the border element
				$border = $firstLi.find('.st_border'); //Get the appended border element
				
				this.setPosition($tabsUl.find('.st_tab_active'), false); //Position the border element
				
				stObj.setOptions({onTabClick:function() { 
					menuBorder.setPosition(this, true); 
				}});
			},
			
			setPosition: function($tab, animate) {
				//Return false if a content animation is running
				if ($('div#'+$container.attr('id')+' div.st_views :animated').length) { 
					return false; 
				}
				
				//Tabs offset fix
				liPos = $firstLi.position()[pos];
				liPos = (liPos>0) ? -liPos : Math.abs(liPos);
												
				//Calculate the offset
				offset = $tab.parent("li").position()[pos]+liPos;
				
				if (animate) {
					//Animate the border element
					if (pos=="left") { 
						$border.stop().animate({left:offset+"px", width:$tab.outerWidth(false)+"px"}, 200, "linear"); 
					} else { 
						$border.stop().animate({top:offset+"px", height:$tab.outerHeight(false)+"px"}, 200, "linear"); 
					}				
				} else {
					//Position the border element
					if (pos=="left") { 
						$border.css({left: offset+'px', width: $tab.outerWidth(false)+'px'}); 
					} else { 
						$border.css({top: offset+'px', height: $tab.outerHeight(false)+'px'}); 
					}
				}
			}
		},
		
		extButtons = {
			init: function() {
				$container.append('<a href="#" class="st_ext_btn st_ext_prev" />', '<a href="#" class="st_ext_btn st_ext_next" />');
				$container.children(".st_ext_prev").click(
					function() { 
						stObj.goToPrev(); return false; 
					}
				);
				$container.children(".st_ext_next").click(
					function() { 
						stObj.goToNext(); return false; 
					}
				);
			}
		};
		
		menuBorder.init();
		extButtons.init();
	};
	
	var tabsInstance;
	
	$(document).ready(function() {
		//Find each Sliding Tabs instance using this template
		for (var i=0, slidingtabs=$(".slider"); i<slidingtabs.length; i++) {
			tabsInstance = slidingtabs[i];
			
			//Assign the navigation function to each instance
			if (typeof(tabsInstance.stCustomMenu)=="undefined") {
				tabsInstance.stCustomMenu = CustomMenu(tabsInstance);
			}
		}
	});
})(jQuery);