<?php
class ControllerModuleSliderpro extends Controller {
	protected function index($setting) {
		static $module = 0;

		$this->language->load('module/sliderpro');

		$this->data['heading_title'] = $setting['name'];

		$this->data['button_cart'] = $this->language->get('button_cart');

		$this->data['text_wish'] = $this->language->get('text_wish');
		$this->data['text_compare'] = $this->language->get('text_compare');

		$this->load->model('module/sliderpro');
		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		$this->data['module'] = $module++;
		$this->data['image_width'] = $setting['image_width'];


		$this->data['products'] = array();
		$results = array();

		if ($setting['source'] == 'special') {
			$data = array(
				'sort'  => 'pd.name',
				'order' => 'ASC',
				'start' => 0,
				'limit' => $setting['limit']
			);
			$results = $this->model_catalog_product->getProductSpecials($data);
		} elseif ($setting['source'] == 'selected' || $setting['source'] == 'random') {
			if ($setting['products']) {
				$results = $this->model_module_sliderpro->getProducts($setting['products'], $setting['limit'], ($setting['source'] == 'random'));
			}
		} elseif ($setting['source'] == 'latest') {
			$data = array(
				'sort'  => 'p.date_added',
				'order' => 'DESC',
				'start' => 0,
				'limit' => $setting['limit']
			);

			$results = $this->model_catalog_product->getProducts($data);
		} elseif ($setting['source'] == 'bestsellers') {
			$results = $this->model_catalog_product->getBestSellerProducts($setting['limit']);

		} elseif ($setting['source'] == 'featured') {
			if ($this->config->get('featured_product')) {
				$results = $this->model_module_sliderpro->getProducts($this->config->get('featured_product'), $setting['limit']);
			}
		}

		foreach($results as $result) {
			if($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}

			if(($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}

			if((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}

			if($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}

			$images = array();
			$productImages = $this->model_catalog_product->getProductImages($result['product_id']);
			foreach($productImages as $productImage) {
				$images[] = $this->model_tool_image->resize($productImage['image'], $setting['image_width'], $setting['image_height']);
			}


			$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'thumb' => $image,
				'images' => $images,
				'name' => $result['name'],
				'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, 100) . '..',
				'price' => $price,
				'special' => $special,
				'rating' => $rating,
				'reviews' => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href' => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}

		$this->data['setting'] = $setting;

		$template_name = "block.tpl";

		if ($setting['display'] == 'slider') {
			$this->document->addScript('catalog/view/javascript/jquery/jquery.simplyscroll.min.js');
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/jquery.simplyscroll.css');
			$template_name = "slider.tpl";
		} elseif ($setting['display'] == 'carousel') {
			$this->document->addScript('catalog/view/javascript/jquery/jquery.jcarousel.min.js');
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/carousel.css');
			$template_name = "carousel.tpl";
		}

		if(file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/sliderpro/' . $template_name)) {
			$this->template = $this->config->get('config_template') . '/template/module/sliderpro/' . $template_name;
		} else {
			$this->template = 'default/template/module/sliderpro/' . $template_name;
		}
		if ($this->data['products']) {
			$this->render();
		}
	}
}

?>