<?php
class ControllerModuleSliderPro extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/sliderpro');

		$this->document->setTitle(strip_tags($this->language->get('heading_title')));

		$this->load->model('setting/setting');

		if(($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('sliderpro', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_content_top'] = $this->language->get('text_content_top');
		$this->data['text_content_bottom'] = $this->language->get('text_content_bottom');
		$this->data['text_column_left'] = $this->language->get('text_column_left');
		$this->data['text_column_right'] = $this->language->get('text_column_right');
		$this->data['text_scroller'] = $this->language->get('text_scroller');
		$this->data['text_random'] = $this->language->get('text_random');
		$this->data['text_special'] = $this->language->get('text_special');
		$this->data['entry_image'] = $this->language->get('entry_image');
		$this->data['entry_limit'] = $this->language->get('entry_limit');
		$this->data['entry_scroll'] = $this->language->get('entry_scroll');
		$this->data['entry_layout'] = $this->language->get('entry_layout');
		$this->data['entry_position'] = $this->language->get('entry_position');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_display'] = $this->language->get('entry_display');
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_description'] = $this->language->get('entry_description');
		$this->data['entry_source'] = $this->language->get('entry_source');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_module'] = $this->language->get('button_add_module');
		$this->data['button_remove'] = $this->language->get('button_remove');
		$this->data['button_product_list'] = $this->language->get('button_product_list');

		$this->data['action_edit'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&module=', 'SSL');


		if(isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if(isset($this->error['image'])) {
			$this->data['error_image'] = $this->error['image'];
		} else {
			$this->data['error_image'] = array();
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('module/sliderpro', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);

		$this->data['action'] = $this->url->link('module/sliderpro', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['modules'] = array();

		if(isset($this->request->post['sliderpro_module'])) {
			$this->data['modules'] = $this->request->post['sliderpro_module'];
		} elseif($this->config->get('sliderpro_module')) {
			$this->data['modules'] = $this->config->get('sliderpro_module');
		}

		$this->data['source_list'] = array();
		$this->data['source_list'][] = 'selected';
		$this->data['source_list'][] = 'random';
		$this->data['source_list'][] = 'special';
		$this->data['source_list'][] = 'latest';
		$this->data['source_list'][] = 'bestsellers';
		$this->data['source_list'][] = 'featured';

		foreach($this->data['source_list'] as $item){
			$this->data['text_' . $item] = $this->language->get('text_' . $item);
		}

		$this->data['display_list'] = array();
		//$this->data['display_list'][] = 'simple';
		$this->data['display_list'][] = 'block';
		$this->data['display_list'][] = 'slider';
		$this->data['display_list'][] = 'carousel';

		foreach($this->data['display_list'] as $item){
			$this->data['text_' . $item] = $this->language->get('text_' . $item);
		}

		$this->load->model('design/layout');

		$this->data['layouts'] = $this->model_design_layout->getLayouts();

		$this->template = 'module/sliderpro.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
	}

	private function editSetting($data) {

		$this->load->model('setting/setting');
		$modules = $this->config->get('sliderpro_module');
		$module = $modules[$this->request->get['module']];
		$products = isset($module['products'])? $module['products'] : array();
		if($products) {
			$products = explode(",", $products);
		}
		$selected = array();
		if(isset($data['selected'])) {
			$selected = $data['selected'];
		} elseif(isset($data['product_id'])) {
			$selected = array($data['product_id']);
		}

		if($this->request->get['action'] == 'add') {
			if($products) {
				$products = array_unique(array_merge($products, $selected), SORT_NUMERIC);
			} else {
				$products = $selected;
			}

			$this->session->data['success'] = $this->language->get('text_success_product_add');
		}

		if($this->request->get['action'] == 'delete') {
			$products = array_diff($products, $selected);
			$this->session->data['success'] = $this->language->get('text_success_product_delete');
		}
		$products = implode($products, ",");

		$modules[$this->request->get['module']]['products'] = $products;

		$this->model_setting_setting->editSetting('sliderpro', array('sliderpro_module' => $modules));

		return $products;
	}

	public function edit() {
		$this->data['module'] = $this->request->get['module'];

		$modules = $this->config->get('sliderpro_module');
		$module_data = $modules[$this->data['module']];

		$this->load->language('module/sliderpro');

		$this->document->setTitle(strip_tags($this->language->get('heading_title') . " :: " . $module_data['name']));
		$this->data['heading_title'] = $module_data['name'];

		$product_ids = isset($module_data['products']) ? $module_data['products']: array();


		if(isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = null;
		}

		if(isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = null;
		}

		if(isset($this->request->get['filter_price'])) {
			$filter_price = $this->request->get['filter_price'];
		} else {
			$filter_price = null;
		}

		if(isset($this->request->get['filter_quantity'])) {
			$filter_quantity = $this->request->get['filter_quantity'];
		} else {
			$filter_quantity = null;
		}

		if(isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}
		if(isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = null;
		}

		if(isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}

		if(isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if(isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if(isset($this->request->get['module'])) {
			$url .= '&module=' . $this->request->get['module'];
		}

		if(isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if(isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}

		if(isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if(isset($this->request->get['filter_price'])) {
			$url .= '&filter_price=' . $this->request->get['filter_price'];
		}

		if(isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if(isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if(isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}

		//		if(isset($this->request->get['sort'])) {
		//			$url .= '&sort=' . $this->request->get['sort'];
		//		}

		//		if(isset($this->request->get['order'])) {
		//			$url .= '&order=' . $this->request->get['order'];
		//		}

		if($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if(isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if($this->validate_permission() && isset($this->request->get['module']) && (isset($this->request->post['selected']) || isset($this->request->get['product_id']))) {

			if(isset($this->request->post['selected'])) {
				$this->editSetting($this->request->post);
			} elseif(isset($this->request->get['product_id'])) {
				$this->editSetting($this->request->get);
			}

			$this->redirect($this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('module/sliderpro', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);

		$this->data['breadcrumbs'][] = array(
			'text' => $module_data['name'],
			'href' => $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&module=' . $this->data['module'], 'SSL'),
			'separator' => ' :: '
		);


		$this->load->model('module/sliderpro');
		$this->load->model('tool/image');

		$results = array();
		if($product_ids) {
			$results = $this->model_module_sliderpro->getProducts($product_ids);
		}

		$this->data['module_products'] = array();
		foreach($results as $result) {
			if($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
			}

			$action = array();

			$action[] = array(
				'text' => $this->language->get('text_delete'),
				'href' => $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&action=delete&product_id=' . $result['product_id'] . $url, 'SSL')
			);

			$this->data['module_products'][] = array(
				'product_id' => $result['product_id'],
				'name' => $result['name'],
				'action' => $action,
				'model' => $result['model'],
				'price' => $result['price'],
				'image' => $image,
				'quantity' => $result['quantity'],
				'status' => ($result['status'] ? $this->language->get('text_enabled')
						: $this->language->get('text_disabled')),
				'selected' => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),

			);
		}

		$this->data['products'] = array();

		$data = array(
			'filter_name' => $filter_name,
			'filter_model' => $filter_model,
			'filter_price' => $filter_price,
			'filter_quantity' => $filter_quantity,
			'filter_status' => $filter_status,
			'filter_category_id' => $filter_category,
			'sort' => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);

		$this->load->model('tool/image');
		$this->load->model('catalog/product');

		$product_total = $this->model_catalog_product->getTotalProducts($data);

		$results = $this->model_catalog_product->getProducts($data);

		foreach($results as $result) {
			$action = array();

			$action[] = array(
				'text' => $this->language->get('text_add'),
				'href' => $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&action=add&product_id=' . $result['product_id'] . $url, 'SSL')
			);

			if($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
			}


			$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'name' => $result['name'],
				'model' => $result['model'],
				'price' => $result['price'],
				'image' => $image,
				'quantity' => $result['quantity'],
				'status' => ($result['status'] ? $this->language->get('text_enabled')
						: $this->language->get('text_disabled')),
				'selected' => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				'action' => $action
			);
		}

		$this->data['column_image'] = $this->language->get('column_image');
		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_model'] = $this->language->get('column_model');
		$this->data['column_price'] = $this->language->get('column_price');
		$this->data['column_quantity'] = $this->language->get('column_quantity');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['button_filter'] = $this->language->get('button_filter');
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_all_products'] = $this->language->get('text_all_products');
		$this->data['text_module_products'] = $this->language->get('text_module_products');

		$this->data['token'] = $this->session->data['token'];

		if(isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if(isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}


		//Get categories
		$this->load->model('catalog/category');
		$list_categories = array();
		$categories = $this->model_catalog_category->getCategories(0);
		foreach($categories as $category) {
			$list_categories[$category['category_id']] = $category['name'];
		}
		$this->data['categories'] = $list_categories;
		//		$url = '';
		//
		//		if(isset($this->request->get['filter_name'])) {
		//			$url .= '&filter_name=' . $this->request->get['filter_name'];
		//		}
		//
		//		if(isset($this->request->get['filter_category'])) {
		//			$url .= '&filter_category=' . $this->request->get['filter_category'];
		//		}
		//
		//		if(isset($this->request->get['filter_model'])) {
		//			$url .= '&filter_model=' . $this->request->get['filter_model'];
		//		}
		//
		//		if(isset($this->request->get['filter_price'])) {
		//			$url .= '&filter_price=' . $this->request->get['filter_price'];
		//		}
		//
		//		if(isset($this->request->get['filter_quantity'])) {
		//			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		//		}
		//
		//		if(isset($this->request->get['filter_status'])) {
		//			$url .= '&filter_status=' . $this->request->get['filter_status'];
		//		}
		//
		//
		//		if(isset($this->request->get['page'])) {
		//			$url .= '&page=' . $this->request->get['page'];
		//		}

		$this->data['sort_name'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&sort=pd.name' . $url, 'SSL');
		$this->data['sort_model'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&sort=p.model' . $url, 'SSL');
		$this->data['sort_price'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&sort=p.price' . $url, 'SSL');
		$this->data['sort_quantity'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&sort=p.quantity' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&sort=p.status' . $url, 'SSL');
		$this->data['sort_order'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&sort=p.sort_order' . $url, 'SSL');
		//
		//		$url = '';
		//
		//		if(isset($this->request->get['filter_name'])) {
		//			$url .= '&filter_name=' . $this->request->get['filter_name'];
		//		}
		//
		//		if(isset($this->request->get['filter_category'])) {
		//			$url .= '&filter_category=' . $this->request->get['filter_category'];
		//		}
		//
		//		if(isset($this->request->get['filter_model'])) {
		//			$url .= '&filter_model=' . $this->request->get['filter_model'];
		//		}
		//
		//		if(isset($this->request->get['filter_price'])) {
		//			$url .= '&filter_price=' . $this->request->get['filter_price'];
		//		}
		//
		//		if(isset($this->request->get['filter_quantity'])) {
		//			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		//		}
		//
		//		if(isset($this->request->get['filter_status'])) {
		//			$url .= '&filter_status=' . $this->request->get['filter_status'];
		//		}
		//
		//		if(isset($this->request->get['sort'])) {
		//			$url .= '&sort=' . $this->request->get['sort'];
		//		}
		//
		//		if(isset($this->request->get['order'])) {
		//			$url .= '&order=' . $this->request->get['order'];
		//		}

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();

		$this->data['filter_name'] = $filter_name;
		$this->data['filter_model'] = $filter_model;
		$this->data['filter_price'] = $filter_price;
		$this->data['filter_quantity'] = $filter_quantity;
		$this->data['filter_status'] = $filter_status;
		$this->data['filter_category'] = $filter_category;

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->data['add_link'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&action=add' . $url, 'SSL');
		$this->data['delete_link'] = $this->url->link('module/sliderpro/edit', 'token=' . $this->session->data['token'] . '&action=delete' . $url, 'SSL');

		$this->template = 'module/sliderpro_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());

	}

	private function validate_permission() {
		if(!$this->user->hasPermission('modify', 'module/sliderpro')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		if(!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validate() {
		$this->validate_permission();

		if(isset($this->request->post['sliderpro_module'])) {
			foreach($this->request->post['sliderpro_module'] as $key => $value) {
				if(!$value['image_width'] || !$value['image_height']) {
					$this->error['image'][$key] = $this->language->get('error_image');
				}
			}
		}

		if(!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}

?>