<?php
global $sitepress;

$sitepress_settings = $sitepress->get_settings();
if ( isset( $sitepress_settings[ 'icl_show_reminders' ] ) ) {
	$show = $sitepress_settings[ 'icl_show_reminders' ];
} else {
	$show = true;
}

// echo sprintf(__('%s Reminders', 'sitepress'), 'ICanLocalize'); is written as such in view of future additional services

?>
<div id="icl_reminder_message" class="updated message fade" style="clear:both;margin-top:5px;display:none; padding-bottom: 7px;margin-bottom:30px;">
	<table width="100%">
		<tr>
			<td><h4 style="margin-top:5px; padding: 0;"><?php echo sprintf(__('%s Reminders', 'sitepress'), 'ICanLocalize'); ?></h4></td>
			<td align="right">
				<a id="icl_reminder_close" class="icl_win_controls icl_close" href="#" title="<?php esc_attr_e( 'Hide reminders', 'sitepress' ) ?>">x</a>
				<span id="icl_reminder_close_prompt" style="display: none;"><?php _e( "Click OK to confirm.\nYou can enable them back from Translation Management / Multilingual Content setup.", 'sitepress' ) ?></span>
				<?php if ( !$show ): ?>
					<a id="icl_reminder_show" class="icl_win_controls icl_maximize" href="#" title="<?php esc_attr_e( 'Expand reminders', 'sitepress' ) ?>">+</a>
				<?php else: ?>
					<a id="icl_reminder_show" class="icl_win_controls icl_minimize" href="#" title="<?php esc_attr_e( 'Collapse reminders', 'sitepress' ) ?>">-</a>
				<?php endif; ?>
			</td>
		</tr>
	</table>
	<div id="icl_reminder_list"<?php if ( !$show ) {
		echo ' style="display:none"';
	} ?>></div>
</div>

