<?php
	require "i.header.php";
	
	$saved = false;
	$error = false;
	
	if($_POST['doFormPost']) {
		foreach($_POST as $i=>$v) {
			if($i != "doFormPost") {
				if(!$v) $v = "X";
				$db->write(str_replace('_', " ", $i), $v);
			}
		}
		$saved = true;
	}
?>
	
	<div class="page-header">
		<h3 style="line-height: 30px;">Manage Captcha</h3>
		<p>Change the Captcha settings for your website to prevent bots, scrapers, or other automated devices from misusing the website.</p>
	</div>
	
	<form action="" method="POST">
		<input type="hidden" name="doFormPost" value="true" />
		
		<?php if($saved) { ?><div class="alert alert-success">
			<strong>Awesome!</strong> Changes have been saved successfully.
		</div><?php } elseif($error !== false) { ?><div class="alert alert-error">
			<strong>Error!</strong> <?=$error;?>
		</div><?php } ?>
		
		
		
		<table class="table table-striped">
			<tbody>
				<tr>
					<td width='270'>
						<b>Enable Google Captcha</b>
					</td>
					<td>
						<div class="switch">
							<input type='hidden' value='Off' name='Captcha'>
							<input type="checkbox" value="On" name="Captcha" <?php if($db->read("Captcha") != 'Off') { ?>checked <?php } ?>/>
						</div>
					</td>
					<td>Enable Google Captcha?</td>
				</tr>
				<tr>
					<td>
						<b>Captcha Public Key</b>
					</td>
					<td>
						<input type="text" name="Captcha Public Key" value="<?=$db->read('Captcha Public Key');?>" />
					</td>
					<td>You can get a public key from the official <a href="https://www.google.com/recaptcha/admin/list">captcha site</a>.</td>
				</tr>
				<tr>
					<td>
						<b>Captcha Private Key</b>
					</td>
					<td>
						<input type="text" name="Captcha Private Key" value="<?=$db->read('Captcha Private Key');?>" />
					</td>
					<td>You can get a private key from the official <a href="https://www.google.com/recaptcha/admin/list">captcha site</a>.</td>
				</tr>
				<tr>
					<td>
						<b># Tools Before Captcha</b>
					</td>
					<td>
						<input type="text" name="Captcha Tools Before Activation" value="<?=str_replace('X', '0', $db->read('Captcha Tools Before Activation'));?>" style="width: 20px;" />
					</td>
					<td>
						How many tools can a user use before captcha activates? Set to '0' to require captcha <i>before</i> any tools can be used.
					</td>
				</tr>
				<tr>
					<td>
						<b># Tools After Captcha</b>
					</td>
					<td>
						<input type="text" name="Captcha Tools After Activation" value="<?=str_replace('X', '0', $db->read('Captcha Tools After Activation'));?>" style="width: 20px;" />
					</td>
					<td>
						After a user passes captcha the first time, how many tools can they use before they are required to pass captcha again? Set to '0' to disable.
					</td>
				</tr>
				<tr>
					<td></td>
					<Td><input type="submit" name="" value="Save Changes" class="btn btn-success" /></td>
					<td></td>
				</tr>
			</tbody>
		</table>
	</form>
	
	<style>
		input[type=text] {
			margin-bottom: 0;
		}
		select {
			margin-bottom: 0;
		}
		tr, td {
			vertical-align: middle !important;
		}
	</style>
	
<?php
	require "i.footer.php";
?>
