<?php
	$privatekey = $db->read("Captcha Private Key");
	$publickey = $db->read("Captcha Public Key");
	
	$numberToolsBeforeCaptcha = str_replace("X", "0", $db->read("Captcha Tools Before Activation")); // maximum # tools used before captcha kicks in. Set to 0 to require captcha BEFORE using tools.
	$numberToolsRequireNewCaptcha = str_replace("X", "0", $db->read("Captcha Tools After Activation")); // maximum # tools used [after original captcha] before captcha kicks in again, to prevent overuse. Set to 0 to disable.
	
	/////////////////////
	
	if($_SESSION['CaptchaPass'] === null || $_SESSION['CaptchaPass'] !== true) {
		$currentToolsUsed = $_SESSION['ToolsUsed'];
		
		if(strpos($_SERVER['PHP_SELF'], "/tools/") !== false && strpos($_SERVER['PHP_SELF'], "index.php") === false) {
			$currentToolsUsed++;
			$_SESSION['ToolsUsed'] = $currentToolsUsed;
		}
		
		if($currentToolsUsed >= $numberToolsBeforeCaptcha || $numberToolsBeforeCaptcha === 0) {
			if(strpos($_SERVER['PHP_SELF'], "/tools") !== false) {
				if(strpos($_SERVER['PHP_SELF'], "/lib/captcha-please.php") === false) {
					if($db->read("Captcha") !== 'Off') {
						header("Location: {$path}lib/captcha-please.php");
						exit("You're required to enter a Captcha Code before continuing. This website does not tolerate robots. You'll also be required to enter captcha if you continue using tools. Please <a href='{$path}lib/captcha-please.php'>click here</a> to enter the captcha now.");
					}
				}
			}
		}
	}
	else {
		$currentToolsUsed = $_SESSION['ToolsUsed'];
		
		if(strpos($_SERVER['PHP_SELF'], "/tools/") !== false && strpos($_SERVER['PHP_SELF'], "index.php") === false) {
			$currentToolsUsed++;
			$_SESSION['ToolsUsed'] = $currentToolsUsed;
		}
		
		if($currentToolsUsed >= $numberToolsRequireNewCaptcha && $numberToolsRequireNewCaptcha !== 0) {
			session_start();
			session_destroy();
			session_start();
			
			if(strpos($_SERVER['PHP_SELF'], "/lib/captcha-please.php") === false) {
				if($db->read("Captcha") !== 'Off') {
					header("Location: {$path}lib/captcha-please.php");
					exit("You're required to enter a Captcha Code before continuing. This website does not tolerate robots. You'll also be required to enter captcha if you continue using tools. Please <a href='{$path}lib/captcha-please.php'>click here</a> to enter the captcha now.");
				}
			}
		}
	}
	
	/////////////////////
	
	if($_GET['captcha'] === '1') {
		$resp = recaptcha_check_answer(
			$privatekey,
			$_SERVER["REMOTE_ADDR"],
			$_POST["recaptcha_challenge_field"],
			$_POST["recaptcha_response_field"]
		);
		if(!$resp->is_valid) {
			header("Location: {$path}lib/captcha-please.php?fail=1&e=".$resp->error);
			exit;
		}
		else {
			session_start();
			$_SESSION['CaptchaPass'] = true;
			$_SESSION['ToolsUsed'] = 0;
		}
	}
	
?>
