<?php
	function dnsbllookup($ip) {
		$list = array();
		
		$dnsbl_lookup = array(
			"dnsbl-1.uceprotect.net",
			"dnsbl-2.uceprotect.net",
			"dnsbl-3.uceprotect.net",
			"dnsbl.dronebl.org",
			"dnsbl.sorbs.net",
			"spam.dnsbl.sorbs.net",
			"zen.spamhaus.org",
			"bl.spamcop.net",
			"recent.dnsbl.sorbs.net",
			"dnsbl.justspam.org"
		);
		if($ip) {
			$reverse_ip = implode(".",array_reverse(explode(".",$ip)));
			foreach($dnsbl_lookup as $host) {
				if(checkdnsrr($reverse_ip.".".$host.".","A")) {
					$list[] = array(
						"DNSBL" => $host,
						"IP Address" => $reverse_ip,
						"Blacklisted" => true
					);
				}
				else {
					$list[] = array(
						"DNSBL" => $host,
						"IP Address" => $reverse_ip,
						"Blacklisted" => false
					);
				}
			}
		}
		if(isset($list) && $list !== array()) {
			return $list;
		} else {
			return false;
		}
	}
	
	function checkdnsbl($ip) {
		if(isset($ip) && $ip != null) {
			if(filter_var($ip, FILTER_VALIDATE_IP)) {
				return dnsbllookup($ip);
			} else {
				return false;
			}
		}
		else {
			return false;
		}
	}
?> 