<?php
	$title = "Blacklist Lookup";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	require "bl.lok.php";
	require "bl.toip.php";
	
	$domain = str_replace( array("http://","https://","www.") , "", $_POST['domain']);
	
	if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	$ip = getAddresses_www($domain);
	$ip = $ip[count($ip)-1];
	if(!$ip) exit("Error. Could not get IP of host.");
	
	$blacklisted = checkdnsbl($ip); // returns an array of all blacklists checked against, and their result.
	
	if($blacklisted === false) {
		header("Location: index.php?error=1&failed=$ip");
		exit;
	}
?>
<div class="arrow_box">
	<div class="container">
		<h3>Blacklist Results for <?=$ip;?></h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<?php foreach($blacklisted as $b) { ?>
			<div class="well well-small" style="margin-bottom: 10px; padding:15px;">
				<table width='100%'>
					<tr>
						<td width='350'><h4 style="margin: 0;"><?=$b["DNSBL"];?></h4></td>
						<td>
							Checking against <?=$domain;?>
						</td>
						<td width='150'>
							<?php if($b['Blacklisted'] == true) { ?><h4 style="margin: 0;"><font color='red'>LISTED</font></h4><?php } else { ?>
							<h4 style="margin: 0;"><font color='green'>UNLISTED</font></h4><?php } ?>
						</td>
					</tr>
				</table>
			</div>
			<?php } ?>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
