<?php
	$title = "PageRank Compare";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	require $path . "includes/pagerank.php";
	
	// Define required variables //
	
	$domain1 = str_replace( array("http://","https://") , "", $_POST['domain1']);
	$domain2 = str_replace( array("http://","https://") , "", $_POST['domain2']);
	$domain3 = str_replace( array("http://","https://") , "", $_POST['domain3']);
	$domains = array($domain1, $domain2, $domain3);
	$results = array();
	
	foreach($domains as $i => $domain) {
		if($domain != '') {
			if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
			else {
				header("Location: index.php?error=1");
				exit;
			}
			
			$pageRank = number_format(GooglePageRankChecker::getRank(@$domain));
			if($pageRank > 9) $pageRank = 9;
			
			$results[$i] = $pageRank;
		}
	}
	
?>
<div class="arrow_box">
	<div class="container">
		<h3>PageRank Comparison</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
				<div class="span4">
					<div class="cmpBox">
						<div class="cmpHead">
							<h2><?=$domain1;?></h2>
						</div>
						<div class="cmpBody">
							<script type='text/javascript' src='https://www.google.com/jsapi'></script>
							<script type='text/javascript'>
							  google.load('visualization', '1', {packages:['gauge']});
							  google.setOnLoadCallback(drawChart);
							  function drawChart() {
								  var data = google.visualization.arrayToDataTable([
									['Label', 'Value'],
									['Rank', <?=$results[0];?>]
								  ]);
								  var options = {
									width: 220, height: 220,
									redFrom: 0, redTo: 1,
									yellowFrom:1, yellowTo: 3,
									minorTicks: 9,
									max: 9
								  };

								  // Create and draw the visualization.
								  new google.visualization.Gauge(document.getElementById('visualization')).
									  draw(data, options);
								
							  }
							</script>
							<center><div id="visualization"></div></center>
						</div>
					</div>
				</div>
				<div class="span4">
					<div class="cmpBox">
						<div class="cmpHead">
							<h2><?=$domain2;?></h2>
						</div>
						<div class="cmpBody">
							<script type='text/javascript' src='https://www.google.com/jsapi'></script>
							<script type='text/javascript'>
							  google.load('visualization', '1', {packages:['gauge']});
							  google.setOnLoadCallback(drawChart);
							  function drawChart() {
								  var data = google.visualization.arrayToDataTable([
									['Label', 'Value'],
									['Rank', <?=$results[1];?>]
								  ]);
								  var options = {
									width: 220, height: 220,
									redFrom: 0, redTo: 1,
									yellowFrom:1, yellowTo: 3,
									minorTicks: 9,
									max: 9
								  };

								  // Create and draw the visualization.
								  new google.visualization.Gauge(document.getElementById('visualization1')).
									  draw(data, options);
								
							  }
							</script>
							<center><div id="visualization1"></div></center>
						</div>
					</div>
				</div>
				<div class="span4">
					<div class="cmpBox">
						<div class="cmpHead">
							<h2><?=$domain3;?></h2>
						</div>
						<div class="cmpBody">
							<script type='text/javascript' src='https://www.google.com/jsapi'></script>
							<script type='text/javascript'>
							  google.load('visualization', '1', {packages:['gauge']});
							  google.setOnLoadCallback(drawChart);
							  function drawChart() {
								  var data = google.visualization.arrayToDataTable([
									['Label', 'Value'],
									['Rank', <?=$results[2];?>]
								  ]);
								  var options = {
									width: 220, height: 220,
									redFrom: 0, redTo: 1,
									yellowFrom:1, yellowTo: 3,
									minorTicks: 9,
									max: 9
								  };

								  // Create and draw the visualization.
								  new google.visualization.Gauge(document.getElementById('visualization2')).
									  draw(data, options);
								
							  }
							</script>
							<center><div id="visualization2"></div></center>
						</div>
					</div>
				</div>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
