<?php
	$title = "Source Code Viewer";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$url = $_POST['url'];
	
	if(isValid($url)) { SaveResult('url', $url); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	$data = curl_exec($ch);
	curl_close($ch);
	
	// HTML Colorizer class. Thanks Daniel @ PHP.NET! //
	
	class HTMLcolorizer{
		private $pointer = 0; //Cursor position.
		private $content = null; //content of document.
		private $colorized = null;
		function __construct($content){
			$this->content = $content;
		}
		function colorComment($position){
			$buffer = "&lt;<span class='HTMLComment'>";
			for($position+=1;$position < strlen($this->content) && $this->content[$position] != ">" ;$position++){
				$buffer.= $this->content[$position];
			}
			$buffer .= "</span>&gt;";
			$this->colorized .= $buffer;
			return $position;
		}
		function colorTag($position){
			$buffer = "&lt;<span class='tagName'>";
			$coloredTagName = false;
			//As long as we're in the tag scope
			for($position+=1;$position < strlen($this->content) && $this->content[$position] != ">" ;$position++){
				if($this->content[$position] == " " && !$coloredTagName){
					$coloredTagName = true;
					$buffer.="</span>";
				}else if($this->content[$position] != " " && $coloredTagName){
					//Expect attribute
					$attribute = "";
					//While we're in the tag
					for(;$position < strlen($this->content) && $this->content[$position] != ">" ;$position++){
						if($this->content[$position] != "="){
							$attribute .= $this->content[$position];
						}else{
							$value="";
							$buffer .= "<span class='tagAttribute'>".$attribute."</span>=";
							$attribute = ""; //initialize it
							$inQuote = false;
							$QuoteType = null;
							for($position+=1;$position < strlen($this->content) && $this->content[$position] != ">" && $this->content[$position] != " "  ;$position++){
								if($this->content[$position] == '"' || $this->content[$position] == "'"){
									$inQuote = true;
									$QuoteType = $this->content[$position];
									$value.=$QuoteType;
									//Read Until next quotation mark.
									for($position+=1;$position < strlen($this->content) && $this->content[$position] != ">" && $this->content[$position] != $QuoteType  ;$position++){
										$value .= $this->content[$position];
									}    
									$value.=$QuoteType;
								}else{//No Quotation marks.
									$value .= $this->content[$position];
								}                            
							}
							$buffer .= "<span class='tagValue'>".$value."</span>";
							break;            
						}
						
					}
					if($attribute != ""){$buffer.="<span class='tagAttribute'>".$attribute."</span>";}
				}
				if($this->content[$position] == ">" ){break;}else{$buffer.= $this->content[$position];}
				
			}
			//In case there were no attributes.
			if($this->content[$position] == ">" && !$coloredTagName){
				$buffer.="</span>&gt;";
				$position++;
			}
			$this->colorized .= $buffer;
			return --$position;
		}
		function colorize(){
			$this->colorized="";
			$inTag = false;
			for($pointer = 0;$pointer<strlen($this->content);$pointer++){
				$thisChar = $this->content[$pointer];
				$nextChar = $this->content[$pointer+1];
				if($thisChar == "<"){
					if($nextChar == "!"){
						$pointer = $this->colorComment($pointer);
					}else if($nextChar == "?"){
						//colorPHP();
					}else{
						$pointer = $this->colorTag($pointer);
					}
				}else{
					$this->colorized .= $this->content[$pointer];
				}
			}
			return $this->colorized;
		}
	}
	
	// End Colorizer Class //
	
	$contents = $data;
	
	$HTMLinspector = new HTMLcolorizer($contents);
	$contents = $HTMLinspector->colorize();
?>


<style type="text/css">
	.tagName{color:purple;}
	.tagAttribute{color:red;}
	.tagValue{color:blue;}
	.HTMLComment{font-style:italic;color:green;}
</style>

<div class="arrow_box">
	<div class="container">
		<h3>Source Code Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div style="overflow-y:auto; height:500px;">
				<pre style="font-size: 11px;"><?=$contents;?></pre>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
