<?php
	$title = "Webpage Length Check";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$url = $_POST['url'];
	
	if(isValid($url)) { SaveResult('url', $url); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	
	function bytesToSize($bytes, $precision = 2) {  
		$kilobyte = 1024;
		$megabyte = $kilobyte * 1024;
		$gigabyte = $megabyte * 1024;
		$terabyte = $gigabyte * 1024;
	   
		if (($bytes >= 0) && ($bytes < $kilobyte)) {
			return $bytes . ' B';
	 
		} elseif (($bytes >= $kilobyte) && ($bytes < $megabyte)) {
			return round($bytes / $kilobyte, $precision) . ' KB';
	 
		} elseif (($bytes >= $megabyte) && ($bytes < $gigabyte)) {
			return round($bytes / $megabyte, $precision) . ' MB';
	 
		} elseif (($bytes >= $gigabyte) && ($bytes < $terabyte)) {
			return round($bytes / $gigabyte, $precision) . ' GB';
	 
		} elseif ($bytes >= $terabyte) {
			return round($bytes / $terabyte, $precision) . ' TB';
		} else {
			return $bytes . ' B';
		}
	}
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	$data = curl_exec($ch);
	curl_close($ch);
	
	$bytes = strlen($data);
	$size = bytesToSize($bytes);
	
	if(function_exists("mb_strlen")) {
		$len = number_format(mb_strlen($data));
	}
	else {
		$len = "Error. Mbstring extension is not installed.";
	}
?>

<div class="arrow_box">
	<div class="container">
		<h3>Webpage Size Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<table class="table">
				<thead>
					<tr>
						<td>Reading</td>
						<td>Value</td>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><b>Webpage Length</b></td>
						<td><?=$len;?></td>
					</tr>
					<tr>
						<td><b>Webpage Size</b></td>
						<td><?=$size;?></td>
					</tr>
				</tbody>
			</table>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
