<?php
	$title = "Website Speed Test";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$url = $_POST['url'];
	
	if(isValid($url)) { SaveResult('url', $url); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	
	function SendPing($url) {
		$time = microtime();
		$time = explode(' ', $time);
		$time = $time[1] + $time[0];
		$start = $time;
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.6 (KHTML, like Gecko) Chrome/16.0.897.0 Safari/535.6'); 
		curl_setopt($ch, CURLOPT_HEADER, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_REFERER, "http://www.bluefiremedia.net/?#seo-tools/ping");
		$html = curl_exec($ch);
		curl_close($ch);
		
		$time = microtime();
		$time = explode(' ', $time);
		$time = $time[1] + $time[0];
		$finish = $time;
		$total_time = round(($finish - $start), 4);
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/ping?url=" . $url);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.6 (KHTML, like Gecko) Chrome/16.0.897.0 Safari/535.6'); 
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_REFERER, "#KzlPOelAkBMmO==_B65");
		$html = curl_exec($ch);
		curl_close($ch);
		
		$result = json_decode($html, true);
		$remote = $result['Result']['Ping'];
		
		sleep(1); // Allow time before the next ping, so we can get a more accurate result from the remote server.
		return array($total_time, $remote);
	}
	
	$ping_1 = SendPing($url);
	$ping_2 = SendPing($url);
	$ping_3 = SendPing($url);
	$ping_4 = SendPing($url);
	$ping_5 = SendPing($url);
	
	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$start = $time;
	
	$a = file_get_html($url);
	
	$time = microtime();
	$time = explode(' ', $time);
	$time = $time[1] + $time[0];
	$finish = $time;
	$total_time = round(($finish - $start), 4);
	
	$processTime1 = $total_time;
	
	$result = "Attempting a full download of " . $url . " from local server..." . PHP_EOL . PHP_EOL;
	$result .= "[1] Downloaded webpage in " . $ping_1[0] ." seconds." . PHP_EOL;
	$result .= "[2] Downloaded webpage in " . $ping_2[0] ." seconds." . PHP_EOL;
	$result .= "[3] Downloaded webpage in " . $ping_3[0] ." seconds." . PHP_EOL;
	$result .= "[4] Downloaded webpage in " . $ping_4[0] ." seconds." . PHP_EOL;
	$result .= "[5] Downloaded webpage in " . $ping_5[0] ." seconds." . PHP_EOL . PHP_EOL;
	$result .= "* Took $processTime1 seconds to process the webpage locally." . PHP_EOL . PHP_EOL;
	
	$result .= "Attempting a full download of " . $url . " from remote server..." . PHP_EOL . PHP_EOL;
	$result .= "[1] Downloaded webpage in " . $ping_1[1] ." seconds." . PHP_EOL;
	$result .= "[2] Downloaded webpage in " . $ping_2[1] ." seconds." . PHP_EOL;
	$result .= "[3] Downloaded webpage in " . $ping_3[1] ." seconds." . PHP_EOL;
	$result .= "[4] Downloaded webpage in " . $ping_4[1] ." seconds." . PHP_EOL;
	$result .= "[5] Downloaded webpage in " . $ping_5[1] ." seconds." . PHP_EOL . PHP_EOL;
	
	$result .= "Download completed.";
	
	$result = "<pre>" . $result . "</pre>";
?>

<div class="arrow_box">
	<div class="container">
		<h3>Website Speed Test Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div style="overflow-y:auto; height:500px;">
				<?=$result;?>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
