<?php
	require "i.header.php";
	
	$saved = false;
	$error = false;
	
	if($_POST['doFormPost']) {
		$newjs = array();
		
		foreach($_POST as $i=>$v) {
			if($i != "doFormPost") {
				$newjs[str_replace("_", " ", str_replace('\"', '"', $i))] = str_replace('\"', '"', $v);
			}
		}
		
		$newjsText = json_encode($newjs);
		
		if(file_put_contents("../data/lang.db", $newjsText)) {
			$saved = true;
		}
		else {
			$error = "Failed to write to ../data/lang.db.";
		}
	}
?>
	
	<div class="page-header">
		<h3 style="line-height: 30px;">Edit Language</h3>
		<p>Below is a list of phrases and words used in the interface. Change them to the language of your choice and they will appear live, instantly.</p>
	</div>
	
	<form action="" method="POST">
		<input type="hidden" name="doFormPost" value="true" />
		
		<?php if($saved) { ?><div class="alert alert-success">
			<strong>Awesome!</strong> Changes have been saved successfully.
		</div><?php } elseif($error !== false) { ?><div class="alert alert-error">
			<strong>Error!</strong> <?=$error;?>
		</div><?php } ?>
		
		
		
		<table class="table table-striped">
			<tbody>
				<?php
					$f = file_get_contents("../data/lang.db");
					$js = json_decode($f, true);
					
					foreach($js as $phrase=>$newphrase) { 
						$newPhraseForValue = str_replace('"', '\"', $newphrase);
						$phraseForName = str_replace('"', '\"', str_replace(' ', '_', $phrase));
				?>
				<tr>
					<td>
						<b>"<?=$phrase;?>"</b>
					</td>
					<td>
						<input type="text" name="<?=$phraseForName;?>" value="<?=$newPhraseForValue;?>" style="width: 400px;" />
					</td>
				</tr>
				<?php
					}
				?>
				<tr>
					<td></td>
					<Td><input type="submit" name="" value="Save Changes" class="btn btn-success" /></td>
					<td></td>
				</tr>
			</tbody>
		</table>
	</form>
	
	<style>
		input[type=text] {
			margin-bottom: 0;
		}
		select {
			margin-bottom: 0;
		}
		tr, td {
			vertical-align: middle !important;
		}
	</style>
	
<?php
	require "i.footer.php";
?>
