<?php
	ob_start();
	session_start();
	
	if(!$_SESSION['isLoggedIn']) {
		header("Location: login.php");
		exit("Redirecting to <a href='login.php'>login.php</a>.");
	}
	
	require "../lib/dbman.php";
	
	// set up a db connection //
	
	$db = new DatabaseManager("../data/main.db");
	if(!$db->open()) {
		exit("<h3>Database Error</h3> Failed to open the database. This is probably because you have not installed, or the database does not have valid CHMOD permissions set.");
	}
	
	// get new alerts or find existing ones 
	
	$alertsDbFile = "../gate/communications/alerts.db";
	if(file_exists($alertsDbFile)) {
		$alertsInfo = file_get_contents($alertsDbFile);
		$alertsInfo = json_decode($alertsInfo, true);
		if($alertsInfo === null || $alertsInfo === false) {
			exit("<h3>Communications Link Error</h3> Something went wrong with the communications\alert database file. Perhaps you did not install correctly, or have yet to install.");
		}
		
		if($alertsInfo['Last Check'] < (time() - (60 * 5))) {
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=" . urlencode($db->read("Website URL")) . "&version=" . urlencode($db->read("Version")) ."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($db->read("Application Id")) . "&emailNotifications=" . urlencode($db->read("Email Update Notifications")) . "&adminEmail=" . urlencode($db->read("Admin Email")));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
			$data = curl_exec($ch);
			
			if(curl_errno($ch) === 0) {
				if(strpos($data, "COMMUNICATIONS#1.1") !== false) {
					$text = substr($data, 28);
					
					if($text === false) $alertText = "";
					else $alertText = $text;
					file_put_contents($alertsDbFile, json_encode(
						array(
							"Last Check" => time(),
							"Text" => $alertText
						)
					));
				}
			}
		}
		else {
			$alertText = $alertsInfo['Text'];
		}
	}
	else {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=" . urlencode($db->read("Website URL")) . "&version=" . urlencode($db->read("Version")) ."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($db->read("Application Id")) . "&emailNotifications=" . urlencode($db->read("Email Update Notifications")) . "&adminEmail=" . urlencode($db->read("Admin Email")));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
		$data = curl_exec($ch);
	}
	
	if($_GET['closeRate']) {
		$db->write("Rate Popup", "Closed");
		$db->save();
	}
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<title>Admin - SEO Studio 2</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="">
		<meta name="author" content="">
		
		<link href="../css/bootstrap.css" rel="stylesheet">
		<link href="../css/bootstrap-toggle.css" rel="stylesheet">
		<style type="text/css">
			body {
				padding-top: 60px;
				padding-bottom: 40px;
			}
			.sidebar-nav {
				padding: 9px 0;
			}
			@media (max-width: 980px) {
				.navbar-text.pull-right {
					float: none;
					padding-left: 5px;
					padding-right: 5px;
				}
			}
		</style>
		
		<link href="../css/bootstrap-responsive.css" rel="stylesheet">
		<!--[if lt IE 9]>
			<script src="../js/html5shiv.js"></script>
		<![endif]-->
	</head>
	<body>
		<div class="navbar navbar-inverse navbar-fixed-top">
			<div class="navbar-inner">
				<div class="container-fluid">
					<button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<a class="brand" href="index.php">SEO Studio 2</a>
					
					<div class="nav-collapse collapse">
						<p class="navbar-text pull-right">
							<a href="logout.php">Logout</a>
						</p>
						<ul class="nav">
							<li class="active"><a href="index.php">Main</a></li>
							<li><a href="https://www.bherbert.org/">Developer Site</a></li>
							<li><a href="https://www.bherbert.org/contact">Support</a></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
		
		<?php
			if(isset($alertText) && ($alertText !== "") && ($db->read("Enable Communications") !== 'Off')) {
		?>
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="alert alert-block">
					<h4>System Alert</h4>
					<?=$alertText;?>
				</div>
			</div>
		</div>
		<?php
			}
			if($db->read("Rate Popup") !== "Closed") {
		?>
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="alert alert-block alert-success">
					<button onclick="window.location='?closeRate=1';" type="button" class="close" data-dismiss="alert">&times;</button>
					<h4>Please Don't Forget!</h4>
					I worked hard to make this giant script for you. And if you need help, I am always here. <b>But please</b>, when you are satisfied, rate the item on CodeCanyon! Great ratings are the cause of more great applications!
					I feed on them, so don't let me go hungry! :(
					Press the X button to the right to close this alert.
				</div>
			</div>
		</div>
		<?php
			}
		?>
		
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="span3">
					<div class="well sidebar-nav">
						<ul class="nav nav-list">
							<li><a href="../"><i class="icon-home"></i> Back to Website</a></li>
							<li><a href="account.php"><i class="icon-user"></i> Edit My Account</a></li>
							
							<li class="nav-header">Configuration</li>
							<li><a href="settings.php"><i class="icon-cog"></i> Manage Settings</a></li>
							<li><a href="theme.php"><i class="icon-adjust"></i> Manage Theme</a></li>
							<li><a href="captcha.php"><i class="icon-lock"></i> Captcha Settings</a></li>
							
							<li class="nav-header">Content</li>
							<li><a href="cnt-hf.php"><i class="icon-align-justify"></i> Edit Header / Footer</a></li>
							<li><a href="cnt-home.php"><i class="icon-pencil"></i> Edit Home Page</a></li>
							<li><a href="cnt-meta.php"><i class="icon-file"></i> Edit Meta Tags</a></li>
							<li><a href="cnt-ads.php"><i class="icon-eye-open"></i> Edit Ad Banners</a></li>
							<li><a href="cnt-lang.php"><i class="icon-globe"></i> Edit Language</a></li>
							
							<li class="nav-header">System</li>
							<li><a href="updates.php"><i class="icon-refresh"></i> Check For Updates</a></li>
							<li><a href="maintenance.php"><i class="icon-wrench"></i> Check For Problems</a></li>
							<li><a href="sysinfo.php"><i class="icon-question-sign"></i> System Information</a></li>
						</ul>
					</div>
				</div>
				<div class="span9">
