<?php
	require "i.header.php";
?>
	
	<div class="page-header">
		<h3 style="line-height: 30px;">Communications Link</h3>
		<p>Establish a two-way connection to our servers to diagnos problems between the two ends.</p>
	</div>
	
	<div style="margin: 5px 0 35px;">
		<a class="btn btn-success" href="maintenance.php">Back to Maintenance</a>
	</div>
	
	<table class="table table-striped">
		<tbody>
			<tr>
				<td width='180'>
					<b>Hello World</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/hello-world?time=" . time());
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
						curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
						$data = curl_exec($ch);
						
						if(strpos($data, "I come in peace.") !== false) $ok = true;
						
						if($ok) echo '<span class="label label-success">Successful</span>';
						else echo '<span class="label label-important">Failed</span> <span class="label label-warning">The server may be offline. Please try again soon.</span>';
					?>
				</td>
				<td>
					Checks if a connection can be established.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Data Submission</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=" . urlencode($db->read("Website URL")) . "&version=" . urlencode($db->read("Version")) ."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($db->read("Application Id")));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
						curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
						$data = curl_exec($ch);
						
						if(strpos($data, "COMMUNICATIONS#1.1") !== false) $ok = true;
						
						if($ok) echo '<span class="label label-success">Successful</span>';
						else echo '<span class="label label-important">Failed</span>';
					?>
				</td>
				<td>
					Checks if we can successfully send data to the server.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Data Retrieval</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/updates?for=seo-studio-2&current={$currentVersion}&preference={$preference}");
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
						curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
						$data = curl_exec($ch);
						
						if(curl_errno($ch) === 0) {
							$parsed = json_decode($data, true);
							if($parsed !== false && $parsed !== null) {
								$parsedVersion = $parsed["Latest Version"];
								$type = "success";
								
								$ok = true;
							}
							else {
								
							}
						}
						
						if($ok) echo '<span class="label label-success">Successful</span>';
						else echo '<span class="label label-important">Failed</span>';
					?>
				</td>
				<td>
					Checks if we can successfully receive data from the server.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>New Communications</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.2/updates?for=seo-studio-2&current={$currentVersion}&preference={$preference}");
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
						curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
						$data = curl_exec($ch);
						
						if(curl_errno($ch) === 0) {
							$parsed = json_decode($data, true);
							if($parsed !== false && $parsed !== null) {
								$parsedVersion = $parsed["Latest Version"];
								$type = "success";
								
								$ok = true;
							}
							else {
								
							}
						}
						
						if($ok) echo '<span class="label label-important">Failed</span> <span class="label label-warning">This is not normal. You should probably update SEO Studio.</span>';
						else echo '<span class="label label-success">Successful</span>';
					?>
				</td>
				<td>
					Checks if there is a new API version, which there should not be.<Br />
					New API versions can lead to future communications link failure.<br />
					The result of this should be Successful.
				</td>
			</tr>
		</tbody>
	</table>
	
	
<?php
	require "i.footer.php";
?>
