<?php
	require "i.header.php";
?>
	
	<div class="page-header">
		<h3 style="line-height: 30px;">Filesystem Scan</h3>
		<p>Checks that the application can write to the filesystem in needed areas.</p>
	</div>
	
	<div style="margin: 5px 0 35px;">
		<a class="btn btn-success" href="maintenance.php">Back to Maintenance</a>
	</div>
	
	<table class="table table-striped">
		<tbody>
			<tr>
				<td width='180'>
					<b>Write to Data</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$a = file_put_contents("../data/test-write.db", "{\"Status\":\"OK\"}");
						if($a !== false) { $ok = true; unlink("../data/test-write.db"); }
						
						if($ok) echo '<span class="label label-success">Successful</span>';
						else echo '<span class="label label-important">Failed</span>';
					?>
				</td>
				<td>
					Checks if the data folder can be written to.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Write to Logs</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$a = file_put_contents("../data/logs/test-log-write.db", "{\"Status\":\"OK\"}");
						if($a !== false) { $ok = true; unlink("../data/logs/test-log-write.db"); }
						
						if($ok) echo '<span class="label label-success">Successful</span>';
						else echo '<span class="label label-important">Failed</span>';
					?>
				</td>
				<td>
					Checks if the logs folder can be written to.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Write to cGate</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						$a = file_put_contents("../gate/communications/test-write.db", "{\"Status\":\"OK\"}");
						if($a !== false) { $ok = true; unlink("../gate/communications/test-write.db"); }
						
						if($ok) echo '<span class="label label-success">Successful</span>';
						else echo '<span class="label label-important">Failed</span>';
					?>
				</td>
				<td>
					Checks if the communications gateway folder can be written to.
				</td>
			</tr>
		</tbody>
	</table>
	
	
<?php
	require "i.footer.php";
?>
