<?php
	if(file_exists("installer.log")) exit;
	
	ob_start();
	sleep(5);
	
	////////////////////////////////////
	
	$version = "2.5.0";
	
	$currentUrl = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$currentMainDb = file_get_contents("../data/main.db");
	
	$errors = array();
	$log = "";
	
	date_default_timezone_set("America/Phoenix"); // Do not edit. This is only for the log file, and that will come in handy if you have issues and need to contact support - whereas support is in America/Phoenix.
	
	////////////////////////////////////
	
	function tolog($t) {
		global $log;
		$log .= "[".date("G:i:s")."]  " . $t . PHP_EOL;
	}
	
	////////////////////////////////////
	
	sleep(2);
	
	tolog("Checking PHP variables...");
	if(ini_get('safe_mode')) $errors[] = "Safe mode is enabled on this server. Can not proceed.";
	if(!function_exists('curl_version')) $errors[] = "CURL is not enabled on this server. Can not proceed.";
	if(version_compare(PHP_VERSION, '5.2.17') < 0) $errors[] = "You are running a PHP version under 5.2.17, the recommended version. You can continue but be warned of possible errors and bugs. We may not support you when using a version like this.";
	if(file_exists("installer.log")) $errors[] = "This website has already been installed. Can not proceed.";
	tolog("Completed.");
	
	////////////////////////////////////
	
	sleep(2);
	tolog("Checking to see if I can write to ../data/main.db...");
	$a = file_put_contents("../data/main.db", "- testing -");
	$x = "Yes!";
	if($a === false || $a === null) { $x = "Nope!"; $errors[] = "Failed to write to the main.db file. Can not proceed."; }
	tolog("Complete. Could I write?... $x");
	
	////////////////////////////////////
	
	if(count($errors) == 0) {
		tolog("0 errors found. Proceeding...");
		$applicationId = rand(11111, 999999999999);
		tolog("Assigned application ID '$applicationId'");
		tolog("Testing connection to the API version 1.1 @ api.bherbert.org. Test name 'hello world'.");
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/hello-world?time=" . time() . "&installer=1");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
		$data = curl_exec($ch);
		
		if(strpos($data, "I come in peace.") === false) $errors[] = "Failed to connect to the Installation API. It may be down temporarily. Try again soon. Can not proceed.";
		
		tolog("Sending initial data to the server via /alerts API. ");
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=".urlencode("N/A")."&version=".urlencode($version)."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($applicationId) . "&installer=1");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
		$data = curl_exec($ch);
		
		if(strpos($data, "COMMUNICATIONS#1.1") === false) $errors[] = "Failed to send data to the Installation API. It may be down temporarily. Try again soon. Can not proceed.";
		tolog("Completed both API operations. Success is not known.");
	}
	
	////////////////////////////////////
	
	if(count($errors) == 0) {
		tolog("0 errors found. Proceeding...");
		// Looks like we've got a nice, successful installation! //
		// Let's build the main.db file now. //
		
		sleep(4);
		
		tolog("Generating main.db initial array / dataset...");
		$mainDb = array(
			"Admin Email" => "admin",
			"Admin Password" => '$1$t8s.Uf.u$YZBsSfs9Lra/WDQsmhzpq0',
			"Application Id" => $applicationId,
			"Captcha" => "Off",
			"Captcha Tools After Activation" => "X",
			"Captcha Tools Before Activation" => "X",
			"Column Image 140x140 1" => "http://placehold.it/140x140",
			"Column Image 140x140 2" => "http://placehold.it/140x140",
			"Column Image 140x140 3" => "http://placehold.it/140x140",
			"Column Text 1" => "The new studio is attacking a different approach. It aims towards a more user friendly environment, further customization, and a better design.",
			"Column Text 2" => "Our new, redesigned tools are now more advanced than the average industry tools, giving you another reason to use our studio for your sites.",
			"Column Text 3" => "The entire studio is customizable, meaning you have full control over the design, features, and content of your professional studio.",
			"Column Title 1" => "Brand New Approach",
			"Column Title 2" => "A Benefit Redesigned",
			"Column Title 3" => "Completely Customizable",
			"Copyright" => "&copy; 2013 Bailey Herbert & bherbert.org",
			"Home Banner 500x300" => "http://placehold.it/500x300",
			"Home Page Body" => "Welcome to the new studio. We have revamped the entire project to bring you one of the most powerful search optimization apps you will find on the web today.",
			"Home Page Button Text" => "See Tools",
			"Home Page Head" => "Best Solution for Search Optimization",
			"Home Page Title" => "SEO Studio - Professional Solution to Search Engine Optimization",
			"Theme Color" => "orange",
			"Version" => "$version",
			"Update Versions" => "All",
			"Website Name" => "SEO Studio",
			"Website URL" => str_replace("/install/check.php", "/", "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]")
		);
		tolog("Array written successfully. Converting to json format...");
		$mainDbJson = json_encode($mainDb);
		tolog("Done. Outputting array now...".PHP_EOL.PHP_EOL);
		
		foreach($mainDb as $i=>$v) {
			tolog(" [$i] => $v ");
		}
		
		tolog(PHP_EOL.PHP_EOL."Output successful. Uploading contents to ../data/main.db...");
		$initWrite = file_put_contents("../data/main.db", $mainDbJson);
		
		if($initWrite === false || $initWrite === null) { $errors[] = "Failed to upload data to the main.db file. Can not proceed."; tolog("Upload failed. Writing log..."); file_put_contents("installer.failed.log", $log); }
		else { tolog("Upload successful. Writing log file now. Goodbye!"); file_put_contents("installer.log", $log); }
	}
	
	$canProceed = true;
	foreach($errors as $e) {
		if(strpos($e, "Can not proceed") !== null) {
			$canProceed = false;
		}
	}
	
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
		<title>Installer - SEO Studio</title>
		
		<link href="//fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,400,600" rel="stylesheet">
		
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="keywords" content="">
		<meta name="description" content="">
		
		<link href="../css/bootstrap.css" rel="stylesheet">
		<link href="../css/bootstrap-responsive.css" rel="stylesheet">
		<link href="../css/custom.css" rel="stylesheet">
		<link href="../css/togglers.css" rel="stylesheet">
		<script src="../js/jquery.js"></script>
		
		<link href="../css/color-orange.css" rel="stylesheet">
		
		<!--[if lt IE 9]>
			<script src="../js/html5shiv.js"></script>
		<![endif]-->
	</head>
	<body>
		<div class="navbar navbar-fixed-top">
			<div class="navbar-inner">
				<div class="container">
					<a class="brand" href="./">SEO Studio</a>
				</div>
			</div>
		</div>
		<div class="arrow_box">
			<div class="container">
				<h3><?php if($canProceed == true) { ?>Installation Successful<?php } ?></h3>
			</div>
		</div>

		<div class="body">
			<div class="container">
				<div class="row">
					<div class="span8">
						<p>
							<?php if($canProceed == true) { ?>
							Your installation was <b>a success</b>! All data has been inserted and set correctly, and a link between our server and yours has been established to protect you from security threats,
							keep you up-to-date, and to make customer support easier.
							<Br /><Br />
							
							Why not start? Your website is now public, but you may want to configure it. <a href="../admin/index.php">Click here to log into the admin panel.</a> By default, the <b>email and password</b> are both <i>admin</i>.
							<Br /><br />
							
							Please do not delete the install directory. It will become useful for future updates. We have disabled the installation script to prevent reinstalls. If you wish, you can also take a look at the installer log file, found at /install/installer.log.
							
							<?php } else { ?>
							Sadly, there were errors when attempting to install!<Br /><Br />
							
							<?php foreach($errors as $e) { 
								if(strpos($e, "Can not proceed") !== null) $class = "Fatal";
								else $class = "Warning";
							?>
							<div class="alert alert-error">
								<strong><?=$class;?>:</strong> <?=$e;?>
							</div>
							<?php } ?>
							
							<Br /><Br />
							
							Please fix these errors and then continue. If you need more detail, look in the installer.log file, found in this directory.
							<?php } ?>
						</p>
					</div>
				</div>
			</div>
		</div>

		<div class="footer-holder">
			
			<div class="footer-main">
				<div class="container">
					<div class="row">
						<div class="span4">
							&copy; 2013 Bailey Herbert
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<script src="../js/togglers.js"></script>
		<script src="../js/bootstrap-transition.js"></script>
		<script src="../js/bootstrap-alert.js"></script>
		<script src="../js/bootstrap-modal.js"></script>
		<script src="../js/bootstrap-dropdown.js"></script>
		<script src="../js/bootstrap-scrollspy.js"></script>
		<script src="../js/bootstrap-tab.js"></script>
		<script src="../js/bootstrap-tooltip.js"></script>
		<script src="../js/bootstrap-popover.js"></script>
		<script src="../js/bootstrap-button.js"></script>
		<script src="../js/bootstrap-collapse.js"></script>
		<script src="../js/bootstrap-carousel.js"></script>
		<script src="../js/bootstrap-bgscroll.js"></script>
		<script src="../js/bootstrap-typeahead.js"></script>
		
		<script>
			$('.clouds').bgscroll({
				scrollSpeed: 120, 
				direction: 'h' 
			});
			
		</script>
		
		<style>
			tr, td {
				vertical-align: middle;
			}
		</style>
		
	</body>
</html>
