<?php
	if(file_exists("installer.log")) {
		$f = file_get_contents("installer.log");
		if($f != "") {
			exit("This application has already been installed.");
		}
	}
	
	$log = "";
	function writeln($str) {
		global $log;
		$log .= $str . PHP_EOL;
	}
	
	
	$version = "2.5.1";
	$initialTime = time();
	$currentUrl = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	
	//////////////////////////////////////////////
	/// Check submitted data from configure.php
	//////////////////////////////////////////////
	
	writeln("Checking submitted configuration..." . PHP_EOL);
	
	$adminEmail = $_POST['email'];
	$adminPass = $_POST['pass'];
	
	if(strlen($adminEmail) < 3) {
		header("Location: configure.php?error=invalid-email");
		exit;
	}
	writeln("Email accepted: $adminEmail");
	
	if(strlen($adminPass) < 3) {
		header("Location: configure.php?error=invalid-password");
		exit;
	}
	writeln("Password accepted: " . crypt($adminPass) . PHP_EOL);
	
	//////////////////////////////////////////////
	/// Check for required files
	//////////////////////////////////////////////
	
	writeln("Checking for required files...");
	
	$files = array(
		"../index.php",
		"../gate/",
		"../gate/communications/",
		"../gate/communications/alerts.db",
		"../data/", "../data/main.db", "../data/lang.db",
		"../includes/", "../includes/fault.php", "../includes/form.history.php", "../includes/pagerank.php",
		"../includes/recaptchalib.php", "../includes/simple_html_dom.php", "../includes/valid_domain.php",
		"../lib/adsense.php", "../lib/captcha-please.php", "../lib/captcha.control.php", "../lib/dbman.php",
		"../lib/multilang.php", 
		"../admin/", "../admin/i.header.php", "../admin/i.footer.php", "../admin/index.php", "../admin/login.php",
		"../admin/settings.php"
	);
	$missing = array();
	
	foreach($files as $file) {
		if(!file_exists($file)) {
			$missing[] = str_replace("../", "/", $file);
		}
	}
	
	if(count($missing) > 0) {
		echo "<h3>Files are Missing</h3>
		<p>Cannot install because the following files are missing from the installation.</p>";
		
		echo "<ul>";
		foreach($missing as $x) {
			echo "<li>$x</li>";
		}
		echo "</ul>";
		exit;
	}
	
	writeln("Check complete." . PHP_EOL);
	
	//////////////////////////////////////////////
	/// Can I write to the Main Database?
	//////////////////////////////////////////////
	
	writeln("Attempting to write to Main Database...");
	
	$a = file_put_contents("../data/main.db", "- testing -");
	if($a === false || $a === null) { exit("<h3>Uh oh!</h3> Please make sure ../data/main.db has write permissions (try CHMOD 0755) and refresh this page."); }
	
	writeln("Write successful." . PHP_EOL);
	
	//////////////////////////////////////////////
	/// Assign Application ID
	//////////////////////////////////////////////
	
	$applicationId = rand(100, 99999999999);
	writeln("Assigned Application ID: $applicationId" . PHP_EOL . PHP_EOL);
	
	//////////////////////////////////////////////
	/// Connect to APIs
	//////////////////////////////////////////////
	
	writeln("Testing connection to API...");
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/hello-world?time=" . time() . "&installer=1");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	$data = curl_exec($ch);
	
	if(strpos($data, "I come in peace.") === false) { exit("<h3>Uh oh!</h3> It seems the API server is down right now. The installer requires it. Please wait 5 minutes and try again."); }
	
	writeln("... Connection established." . PHP_EOL);
	writeln("Sending initial information to API server...");
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=".urlencode("N/A")."&version=".urlencode($version)."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($applicationId) . "&installer=1");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	$data = curl_exec($ch);
	
	if(strpos($data, "COMMUNICATIONS#1.1") === false) { exit("<h3>Uh oh!</h3> It seems the API server is down right now. The installer requires it. Please wait 5 minutes and try again."); }
	
	writeln("... Information sent." . PHP_EOL);
	
	//////////////////////////////////////////////
	/// Create Main Database
	//////////////////////////////////////////////
	
	writeln("Creating Main Database (main.db)...");
	
	$db = array(
		"Admin Button" => "On",
		"Admin Email" => $adminEmail,
		"Admin Password" => crypt($adminPass),
		"Adsense 160x600" => "",
		"Adsense 300x250" => "",
		"Adsense 728x90" => "",
		"Application Id" => $applicationId,
		"Browse Addons" => "On",
		"Captcha" => "Off",
		"Captcha Private Key" => "",
		"Captcha Public Key" => "",
		"Captcha Tools After Activation" => "X",
		"Captcha Tools Before Activation" => "X",
		"Category Box" => "On",
		"Category Box Fixed" => "On",
		"Column Image 140x140 1" => "http://placehold.it/140x140",
		"Column Image 140x140 2" => "http://placehold.it/140x140",
		"Column Image 140x140 3" => "http://placehold.it/140x140",
		"Column Text 1" => "The new studio is attacking a different approach. It aims towards a more user friendly environment, further customization, and a better design.",
		"Column Text 2" => "Our new, redesigned tools are now more advanced than the average industry tools, giving you another reason to use our studio for your sites.",
		"Column Text 3" => "The entire studio is customizable, meaning you have full control over the design, features, and content of your professional studio.",
		"Column Title 1" => "Brand New Approach",
		"Column Title 2" => "A Benefit Redesigned",
		"Column Title 3" => "Completely Customizable",
		"Copyright" => "&copy; 2013 Webfector",
		"Email Update Notifications" => "On",
		"Enable Communications" => "On",
		"Home Banner 500x300" => "http://placehold.it/500x300",
		"Home Page Body" => "Welcome to the new studio. We have revamped the entire project to bring you one of the most powerful search optimization apps you will find on the web today.",
		"Home Page Button Text" => "See Tools",
		"Home Page Head" => "Best Solution for Search Optimization",
		"Home Page Title" => "SEO Studio - Professional Solution to Search Engine Optimization",
		"Meta Description" => "",
		"Meta Keywords" => "",
		"Remember Inputs" => "On",
		"Show Icons" => "On",
		"Theme Color" => "orange",
		"Update Versions" => "All",
		"Version" => "$version",
		"Website Name" => "SEO Studio",
		"Website URL" => str_replace("/install/install.php", "/", "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]")
	);
	
	$mainDbJson = json_encode($db);
	$initWrite = file_put_contents("../data/main.db", $mainDbJson);
	
	if($initWrite === false || $initWrite === null) { writeln("ERROR! Failed to write data to ../data/main.db."); file_put_contents("installer.failed.log", $log); exit("<h3>Uh oh!</h3> I couldn't set up the application due to a file error. Please see the <a href='installer.failed.log'><b>installer.failed.log</b></a> file."); }
	
	writeln("... Main Database created. Checking...");
	if($mainDbJson === false) { writeln("ERROR! ARRAY -> JSON failed. Please contact support@webfector.com."); file_put_contents("installer.failed.log", $log); exit("<h3>Uh oh!</h3> I couldn't set up the application due to a file error. Please see the <a href='installer.failed.log'><b>installer.failed.log</b></a> file."); }
	writeln("... Main Database was a success." . PHP_EOL);
	 
	//////////////////////////////////////////////
	/// All done!
	//////////////////////////////////////////////
	
	$timeTaken = time() - $initialTime;
	writeln("Installation completed in {$timeTaken} seconds.");
	
	file_put_contents("installer.log", $log);
	
	// I'm putting a lot of random md5s in here just to hide the admin pass/email at the end of the URL. xD
	header("Location: done.php?tok=" . md5(rand(111,999999)) . md5(rand(111,999999)) . md5(rand(111,999999)) . md5(rand(111,999999)) . "&ae=" . urlencode($adminEmail) . "&ap=" . urlencode($adminPass));
?>