<?php
	$title = "Backlink Compare";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	// Define required variables //
	
	$domain1 = str_replace( array("http://","https://") , "", $_POST['domain1']);
	$domain2 = str_replace( array("http://","https://") , "", $_POST['domain2']);
	$domain3 = str_replace( array("http://","https://") , "", $_POST['domain3']);
	$domains = array($domain1, $domain2, $domain3);
	$results = array();
	
	if(!$domain1) doFault();
	if(!$domain2) doFault();
	
	// Begin the checks and results //
	
	$topDomain = 0;
	$topLinks = 0;
	
	foreach($domains as $i => $domain) {
		if($domain != '') {
			if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
			else {
				header("Location: index.php?error=1");
				exit;
			}
			
			$wwwLink = parse_url("http://".$domain);
			$wwwLink = str_replace("www.", "", $wwwLink['host']);
			
			$googleResult1 = file_get_html("https://www.google.com/search?q=" . urlencode('"'.$wwwLink.'"'));
			$googleResult2 = file_get_html("https://www.google.com/search?q=" . urlencode('"www.'.$wwwLink.'"'));
			
			$googleResults1 = $googleResult1->find('div[id=resultStats]', 0)->innertext;
			$googleResults1 = str_replace(array("About ", " results", ","), "", $googleResults1);
			
			$googleResults2 = $googleResult2->find('div[id=resultStats]', 0)->innertext;
			$googleResults2 = str_replace(array("About ", " results", ","), "", $googleResults2);
			
			$backlinks = $googleResults1 + $googleResults2;
			$results[$i] = $backlinks;
			
			if($backlinks > $topLinks) {
				$topLinks = $backlinks;
				$topDomain = $i;
			}
		}
	}
	
	// Done with the backlink checking. Now calculate percentages in comparison to the top domain. //
	
	$percentiles = array();
	
	foreach($results as $i => $v) {
		if($i == $topDomain) {
			$percentiles[$i] = 100;
		}
		else {
			$percentiles[$i] = ceil(100 * ( $v / $results[$topDomain] ));
		}
	}
?>
<div class="arrow_box">
	<div class="container">
		<h3>Backlink Comparison</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
				<div class="span4">
					<div class="well">
						<h4><?=strtoupper($domain1);?></h4>
						
						The website <?=$domain1;?> has <?=number_format($results[0]);?> backlinks. 
						<?php if($topDomain == 0) { ?>That makes it the best domain in your comparison.<?php } else { ?>
						That makes it <?=$percentiles[0];?>% compared to the top domain in your comparison.
						<?php } ?>
						
						<div style="margin-top: 18px;">
							<div class="progress progress-striped active">
								<div class="bar bar-danger" style="width: <?=$percentiles[0];?>%;"></div>
							</div>
						</div>
					</div>
				</div>
				<div class="span4">
					<div class="well">
						<h4><?=strtoupper($domain2);?></h4>
						
						The website <?=$domain2;?> has <?=number_format($results[1]);?> backlinks. 
						<?php if($topDomain == 1) { ?>That makes it the best domain in your comparison.<?php } else { ?>
						That makes it <?=$percentiles[1];?>% compared to the top domain in your comparison.
						<?php } ?>
						
						<div style="margin-top: 18px;">
							<div class="progress progress-striped active">
								<div class="bar bar-success" style="width: <?=$percentiles[1];?>%;"></div>
							</div>
						</div>
					</div>
				</div><?php if($domain3 != '') { ?>
				<div class="span4">
					<div class="well">
						<h4><?=strtoupper($domain3);?></h4>
						
						The website <?=$domain3;?> has <?=number_format($results[2]);?> backlinks. 
						<?php if($topDomain == 2) { ?>That makes it the best domain in your comparison.<?php } else { ?>
						That makes it <?=$percentiles[2];?>% compared to the top domain in your comparison.
						<?php } ?>
						
						<div style="margin-top: 18px;">
							<div class="progress progress-striped active">
								<div class="bar" style="width: <?=$percentiles[2];?>%;"></div>
							</div>
						</div>
					</div>
				</div><?php } ?>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
