<?php
	$title = "Backlink Prediction";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	// Get Started //
	
	date_default_timezone_set("America/Phoenix"); // Don't change this.
	
	$domain = str_replace( array("http://","https://") , "", $_POST['domain']);
	
	if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
	else { header("Location: index.php?error=1"); exit; }
	
	// Get Google Results //
	
	$wwwLink = parse_url("http://".$domain);
	$wwwLink = str_replace("www.", "", $wwwLink['host']);
	$googleResult1 = file_get_html("https://www.google.com/search?q=" . urlencode('"'.$wwwLink.'"'));
	$googleResult2 = file_get_html("https://www.google.com/search?q=" . urlencode('"www.'.$wwwLink.'"'));
	$googleResults1 = $googleResult1->find('div[id=resultStats]', 0)->innertext;
	$googleResults1 = str_replace(array("About ", " results", ","), "", $googleResults1);
	$googleResults2 = $googleResult2->find('div[id=resultStats]', 0)->innertext;
	$googleResults2 = str_replace(array("About ", " results", ","), "", $googleResults2);
	$backlinks = $googleResults1 + $googleResults2;
	
	// Variables //
	
	$registeredYear = 1337;
	$totalBacklinks = $backlinks;
	$backlinksPerYear = 0;
	
	// Rough estimation //
	
	$whoisResult = file_get_html("http://www.whois.com/whois/$wwwLink");
	$whois = $whoisResult->find('div[id=registryData]', 0)->innertext;
	$whois = str_replace("&nbsp;", " ", $whois);
	$whois = explode("<br>", $whois);
	
	foreach($whois as $row) {
		$on = false;
		
		if(strpos($row, "Created on..............:") !== false) { $on = true; }
		elseif(strpos($row, "Domain Registration Date:") !== false) { $on = true; } 
		elseif(strpos($row, "Creation Date:") !== false) { $on = true; }
		
		if($on) {
			$row = str_replace(" ", "", $row);
			$args = explode(":", $row);
			$date = $args[1];
			$date = explode("-", $date);
			$registeredYear = $date[2];
		}
	}
	
	// Checks and Balances //
	
	if($registeredYear == 1337) {
		exit('<div class="arrow_box"><div class="container"><h3>Lookup Error</h3></div></div><div class="body"><div class="container"><p>We ran into an issue. Sadly, we were not able to get the domain creation date from WHOIS records, thus we cannot estimate backlinks.</p></div></div>');
	}
	
	// Final Estimation //
	
	$maxYears = date("Y") - 1984;
	$numberYears = date("Y") - $registeredYear;
	$backlinksPerYear = ($totalBacklinks / $numberYears);
	$backlinksNextYear = $totalBacklinks + $backlinksPerYear + ($backlinksPerYear * (10 / ($maxYears - $numberYears)));
?>
<div class="arrow_box">
	<div class="container">
		<h3>Backlink Prediction Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
				<div class="span4 well">
					<h4>RIGHT NOW (<?=date("Y");?>)</h4>
					
					The website <?=$domain;?> has <?=number_format($totalBacklinks);?> backlinks.
				</div>
				<div class="span4 well">
					<h4>IN 1 YEAR...</h4>
					
					The website <?=$domain;?> will have <?=number_format($backlinksNextYear);?> backlinks.
				</div>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
