<?php
	$title = "Keyword Cleaner";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$done = false;
	
	if($_POST['list']) {
		$list = $_POST['list'];
		
		// First, let's format the list into a code-readable solution.
		
		$list = str_replace("\r\n", "\n", $list);
		$list = str_replace(",", "\n", $list);
		
		// Alright. Now we'll turn the list into an array, and format the words as we do it.
		
		$orig_arr = explode("\n", $list);
		$new_arr = array();
		
		foreach($orig_arr as $key) {
			$str = strtolower(trim($key));
			$str = ucwords($str);
			
			$new_arr[] = $str;
		}
		
		// Yes! We're done, now we need to just make the array into a string. 
		
		$result1 = implode(', ', $new_arr); // All in one line
		$result2 = implode(PHP_EOL, $new_arr); // All on separate lines
		
		$done = true;
	}
?>

<div class="arrow_box">
	<div class="container">
		<h3><?=$title;?></h3>
	</div>
</div>

<div class="body">
	<div class="container">

		<?php if(!$done) { ?>

				<form action="" method="POST">
					
					<div class="row">
						<div class="span7">
							<p><?=$lang->translate("Enter all of your keywords below. You can put them each on their own line, separate them by commas, or do both.");?></p>
							
							<textarea name="list" class="input-block-level" rows="20" style="margin-top: 23px;"></textarea>
						</div>
						<div class="span5">
							<div class="well">
								<input type="submit" class="btn btn-large btn-block btn-success" value="<?=$lang->translate("Clean / Format List");?>" onclick="document.getElementById('pb').style.display = 'block';">
							</div>
							<div class="well" id="pb" style="display: none;">
								<div class="progress progress-striped active" style="margin-top: 0px; margin-bottom: 0px;">
									<div class="bar" style="width: 100%;"></div>
								</div>
							</div>
						</div>
					</div>
				</form>
			
		<?php } else { ?>
			
			<div class="alert alert-success">
				<strong>Alright!</strong> I just finished tuning up that keyword list of yours. Hope you like it.
			</div>
			
			<div class="row">
				<div class="span6">
					<textarea class="input-block-level" rows="20" style="margin-top: 23px;"><?=$result1;?></textarea>
				</div>
				<div class="span6">
					<textarea class="input-block-level" rows="20" style="margin-top: 23px;"><?=$result2;?></textarea>
				</div>
			</div>
			
		<?php } ?>

	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
