<?php
	$title = "Link Analysis";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$url = "http://www." . str_replace(array("https://","http://","www."), "", $_POST['url']);
	
	if(isValid($url)) { SaveResult('url', $url); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	
	$websiteResult = file_get_html( $url );
	
	// extract all anchors //
	
	$links = array();
	$linkhrefs = array();
	
	$linkQuery = $websiteResult->find("a");
	foreach($linkQuery as $x) {
		if(!in_array($x->href, $linkhrefs)) {
			if(substr($x->href, 0, 1) !== "#") {
				$linkhrefs[] = $x->href;
				$links[] = array(
					'href' => $x->href,
					'rel' => $x->rel,
					'text' => $x->innertext
				);
			}
		}
	}
	
	// process the links //
	
	foreach($links as $i=>$link) {
		$linkUrl = parse_url($link['href']);
		$linkRel = $link['rel'];
		
		if($linkUrl === false || $linkUrl['host'] == $wwwShortName) {
			$links[$i]['href_type'] = "inbound";
		}
		elseif((substr($link['href'], 0, 2) != "//") && (substr($link['href'], 0, 1) == "/")) {
			$links[$i]['href_type'] = "inbound";
		}
		if($linkUrl !== false && $linkUrl['host'] != $wwwShortName) {
			$links[$i]['href_type'] = "outbound";
		}
		elseif((substr($link['href'], 0, 2) == "//") && (substr($link['href'], 0, 1) != "/")) {
			$links[$i]['href_type'] = "outbound";
		}
		
		if($linkRel == 'dofollow' || !$linkRel) $links[$i]['follow_type'] = "dofollow";
		if($linkRel == 'nofollow') $links[$i]['follow_type'] = "nofollow";
	}
	
	sort($links);
?>

<div class="arrow_box">
	<div class="container">
		<h3>Link Analysis Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<table class="table">
				<thead>
					<tr>
						<td>Anchor Link</td>
						<td>Link Type</td>
						<td>Link Following</td>
					</tr>
				</thead>
				<tbody>
					<?php foreach($links as $link) { ?>
					<tr>
						<td><?=$link['href'];?></td>
						<td><?=ucfirst($link['href_type']);?></td>
						<td><?=ucfirst($link['follow_type']);?></td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
