<?php
	$title = "PageRank Check";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	require $path . "includes/pagerank.php";
	
	// Get Started //
	
	$domain = str_replace( array("http://","https://") , "", $_POST['domain']);
	
	if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
	else { header("Location: index.php?error=1"); exit; }
	
	// Get Google Results //
	
	$pageRank = number_format(GooglePageRankChecker::getRank(@$domain));
	if($pageRank > 9) $pageRank = 9;
?>
<div class="arrow_box">
	<div class="container">
		<h3>Google PageRank Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
				<div class="span3">
					<script type='text/javascript' src='https://www.google.com/jsapi'></script>
					<script type='text/javascript'>
					  google.load('visualization', '1', {packages:['gauge']});
					  google.setOnLoadCallback(drawChart);
					  function drawChart() {
						  var data = google.visualization.arrayToDataTable([
							['Label', 'Value'],
							['PageRank', <?=$pageRank;?>]
						  ]);
						  var options = {
							width: 270, height: 270,
							redFrom: 0, redTo: 1,
							yellowFrom:1, yellowTo: 3,
							minorTicks: 9,
							max: 9
						  };

						  // Create and draw the visualization.
						  new google.visualization.Gauge(document.getElementById('visualization')).
							  draw(data, options);
						
					  }
					</script>
					<div id="visualization"></div>
				</div>
				<div class="span7">
					<h4>PageRank Results</h4>
					<p>The website <?=$domain;?> has a current estimated Google Page Rank value of <b><?=$pageRank;?></b>.</p>
					<p>If you wish to see how this may change in the future, visit the PageRank Prediction Tool.</p>
				</div>
				<div class="span2">
					
				</div>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
