<?php
	require "i.header.php";
?>
	
	<div class="page-header">
		<h3 style="line-height: 30px;">Maintenance</h3>
		<p>Find issues with this installation, and run scans to determine issues.</p>
	</div>
	
	<div style="margin: 5px 0 35px;">
		<a class="btn btn-success" href="maintenance-check-communications.php">Check Communications Link</a>
		<a class="btn btn-danger" href="maintenance-filesystem-scan.php">Check Filesystem Setup</a>
		<a class="btn btn-inverse" href="mailto:help@bherbert.org">Contact Support</a>
	</div>
	
	<table class="table table-striped">
		<tbody>
			<tr>
				<td width='180'>
					<b>Data Protection</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../data/")) {
							if(file_exists("../data/.htaccess")) {
								$ok = true;
							}
						}
						
						if($ok) echo '<span class="label label-success">Enabled</span>';
						else echo '<span class="label label-warning">Disabled</span>';
					?>
				</td>
				<td>
					Protects your databases and logs from being viewed by unauthorized users.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Main Database Exists</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../data/")) {
							if(file_exists("../data/main.db")) {
								$ok = true;
							}
						}
						
						if($ok) echo '<span class="label label-success">Found</span>';
						else echo '<span class="label label-important">Not Found</span>';
					?>
				</td>
				<td>
					Stores all the information about the website.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Main Database Read</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../data/")) {
							if(file_exists("../data/main.db")) {
								$a = file_get_contents("../data/main.db");
								$b = json_decode($a, true);
								if($b !== null && $b !== false) $ok = true;
							}
						}
						
						if($ok) echo '<span class="label label-success">Functional</span>';
						else echo '<span class="label label-important">Data Corrupt</span>';
					?>
				</td>
				<td>
					Is the file working? Can we read it properly?
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Lang Database Exists</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../data/")) {
							if(file_exists("../data/lang.db")) {
								$ok = true;
							}
						}
						
						if($ok) echo '<span class="label label-success">Found</span>';
						else echo '<span class="label label-important">Not Found</span>';
					?>
				</td>
				<td>
					Stores all the information about translations.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Lang Database Read</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../data/")) {
							if(file_exists("../data/lang.db")) {
								$a = file_get_contents("../data/lang.db");
								$b = json_decode($a, true);
								if($b !== null && $b !== false) $ok = true;
							}
						}
						
						if($ok) echo '<span class="label label-success">Functional</span>';
						else echo '<span class="label label-important">Data Corrupt</span>';
					?>
				</td>
				<td>
					Is the file working? Can we read it properly?
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Logs Directory</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../data/logs")) $ok = true;
						
						if($ok) echo '<span class="label label-success">Found</span>';
						else echo '<span class="label label-important">Not Found</span>';
					?>
				</td>
				<td>
					The logs folder is used to debug errors and operations.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Transactional Gateway</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../gate/")) $ok = true;
						
						if($ok) echo '<span class="label label-success">Found</span>';
						else echo '<span class="label label-important">Not Found</span>';
					?>
				</td>
				<td>
					The gateway hosts the communications service.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Communications Gateway</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if(file_exists("../gate/communications")) $ok = true;
						
						if($ok) echo '<span class="label label-success">Found</span>';
						else echo '<span class="label label-important">Not Found</span>';
					?>
				</td>
				<td>
					This service is used to communicate between our servers and yours.
				</td>
			</tr>
			<tr>
				<td width='180'>
					<b>Communications Status</b>
				</td>
				<td>
					<?php
						$ok = false;
						
						if($db->read("Enable Communications")) $ok = true;
						
						if($ok) echo '<span class="label label-success">Enabled & Running</span>';
						else echo '<span class="label label-important">Not Enabled</span>';
					?>
				</td>
				<td>
					The status of the communications service. Turning this off can lead to some serious security issues.
				</td>
			</tr>
		</tbody>
	</table>
	
	
<?php
	require "i.footer.php";
?>
