<?php
	require "i.header.php";
	
	/// Using the bherbert.org API, find the latest version of SEO Studio based on the settings in this panel ///
	
	$preference = strtolower($db->read("Update Versions"));
	$currentVersion = $db->read("Version");
	
	if($db->read("Enable Communications") !== 'Off') {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/updates?for=seo-studio-2&current={$currentVersion}&preference={$preference}");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
		$data = curl_exec($ch);
		
		$latestVersion = "";
		$parsed = null;
		
		if(curl_errno($ch) !== 0) {
			$latestVersion = "<span class=\"label label-important\">Could Not Check</span>";
		}
		else {
			$parsed = json_decode($data, true);
			if($parsed !== false && $parsed !== null) {
				$parsedVersion = $parsed["Latest Version"];
				$type = "success";
				
				if($parsedVersion !== $currentVersion) $type = "warning";
				$latestVersion = "<span class=\"label label-$type\">$parsedVersion</span>";
			}
			else {
				$parsed = null;
				$latestVersion = "<span class=\"label label-important\">Could Not Check</span>";
			}
		}
	}
	else {
		$latestVersion = "<span class=\"label label-warning\">Communications Is Disabled - Can Not Check</span>";
	}
	
	/// End ///
?>
	
	<div class="page-header">
		<h3 style="line-height: 30px;">Check For Updates</h3>
		<p>See the previous versions of SEO Studio 2.0, and find newer versions based on your settings.</p>
	</div>
	
	
	<table class="table table-striped">
		<tbody>
			<tr>
				<td width='120'>
					<b>Current Version</b>
				</td>
				<td>
					<?=$db->read("Version");?>
				</td>
			</tr>
			<tr>
				<td width='120'>
					<b>Your Versions</b>
				</td>
				<td>
					<?=$db->read("Update Versions");?> &nbsp; &nbsp; (change this <a href="settings.php">here</a>)
				</td>
			</tr>
			<tr>
				<td width='120'>
					<b>Latest Version</b>
				</td>
				<td>
					<?=$latestVersion;?>
				</td>
			</tr>
		</tbody>
	</table>
	
	<?php if($parsed !== null) { ?>
	<br />
	
	<table class="table table-striped">
		<tbody>
			<tr>
				<td colspan='2'>
					<b>Latest Version Information</b>
				</td>
			</tr>
			<tr>
				<td width='120'>
					Description
				</td>
				<td>
					<?=$parsed['Version Description'];?>
				</td>
			</tr>
			<tr>
				<td width='120'>
					Update Time
				</td>
				<td>
					<?=$parsed['Version Time'];?>
				</td>
			</tr>
		</tbody>
	</table>
	
	<?php } ?>
	
<?php
	require "i.footer.php";
?>
