<?php
	class DatabaseManager {
		private $dbPath;
		private $dbJson;
		private $isOpen;
		
		function __construct($pathToDb) {
			$this->dbPath = $pathToDb;
			$this->isOpen = false;
		}
		
		function open() {
			if(file_exists($this->dbPath)) {
				$json = json_decode(file_get_contents($this->dbPath), true);
				$this->dbJson = $json;
				
				if($json) {
					$this->isOpen = true;
				}
				
				return $this->isOpen;
			}
			else {
				$this->isOpen = false;
				return false;
			}
		}
		
		function canRead() {
			$json = json_decode(file_get_contents($this->dbPath), true);
			if($json === false || $json === null) return false;
			return true;
		}
		
		function write($variable, $value) {
			$this->dbJson[$variable] = stripslashes($value);
			ksort($this->dbJson);
			
			return file_put_contents($this->dbPath, json_encode($this->dbJson));
		}
		
		function save() {
			ksort($this->dbJson);
			return file_put_contents($this->dbPath, json_encode($this->dbJson));
		}
		
		function read($variable, $writeIfNotExist = true) {
			if($this->dbJson[$variable]) {
				return $this->dbJson[$variable];
			}
			else {
				if($writeIfNotExist) {
					$this->dbJson[$variable] = '';
					$this->save();
					
					return false;
				}
				else {
					return false;
				}
			}
		}
	}
?>
