<?php
	class Language {
		private $dbPath;
		private $dbJson; 
		private $dbIsOpen;
		
		function __construct($pathToDb) {
			$this->dbPath = $pathToDb;
			
			return $dbIsOpen;
		}
		
		function open() {
			$this->dbIsOpen = false;
			if(!file_exists($this->dbPath)) return false;
			$this->dbJson = json_decode(file_get_contents($this->dbPath), true);
			if($this->dbJson === false) return false;
			$this->dbIsOpen = true;
			return true;
		}
		
		function save() {
			ksort($this->dbJson);
			$jd = json_encode($this->dbJson);
			return file_put_contents($this->dbPath, $jd);
		}
		
		function translate($phrase) {
			if($this->dbJson[$phrase]) {
				return $this->dbJson[$phrase];
			}
			else {
				// make the phrase //
				
				$this->dbJson[$phrase] = $phrase;
				$this->save();
				
				return $phrase;
			}
		}
	}
?>
