<?php
	ob_start();
	session_start();
	
	if(!$path) $path = "";
	
	// Activate the DB Manager and Translator System //
	
	require_once $path . "lib/dbman.php";
	require_once $path . "lib/multilang.php";
	
	$db = new DatabaseManager($path . "data/main.db");
	if(!$db->open()) {
		exit("<h3>Database Error</h3> Failed to open the database. This is probably because you have not installed, or the database does not have valid CHMOD permissions set.");
	}
	if(!$db->canRead()) {
		exit("<h3>Database Error</h3> Failed to open the database. This is probably because you have not installed, or the database does not have valid CHMOD permissions set.");
	}
	
	$lang = new Language($path . "data/lang.db");
	if(!$lang->open()) {
		exit("<h3>Language Database Error</h3> Failed to open the language database. This is probably because you have not installed, or the database does not have valid CHMOD permissions set.");
	}
	
	// requirements
	
	require_once $path . "lib/adsense.php";
	require_once $path . "includes/valid_domain.php";
	require_once $path . "includes/form.history.php";
	require_once $path . "includes/simple_html_dom.php";
	require_once $path . "includes/fault.php";
	require_once $path . "includes/recaptchalib.php";
	require_once $path . "lib/captcha.control.php";
	
	$footerPathVar = $path;
	
	// Basic php.ini settings //
	
	ini_set("session.cookie_lifetime", 60*60*24*7); // last 1 week
	ini_set("session.gc_maxlifetime", 60*60*24*7); // last 1 week
	
	// home title
	
	if($title == "Home") {
		$title = $db->read("Home Page Title");
	}
	
	// ads
	
	$ads = new AdBanner();
	$ads->setHTML("160x600", 
		'<div class="advertisement visible-desktop">' .
		$db->read("Adsense 160x600") .
		'</div>'
	);
	$ads->setHTML("728x90", 
		'<div class="advertisement visible-desktop">' .
		$db->read("Adsense 728x90") .
		'</div>'
	);
	$ads->setHTML("300x250", 
		'<div class="advertisement visible-desktop">' .
		$db->read("Adsense 300x250") .
		'</div>'
	);
	
	//
	
	$title = $lang->translate($title);
	
	// WARNING. Do not delete the code below. It is the main function for the script. Deleting it will give hackers a free ticket into your 
	// website. This is also how you'll be notified of new alerts, receive email update notifications, and much more.
	// If you have a question or concern, please, contact me. help@bherbert.org !
	// No personal information is being sent here, besides your login email (used to receive email update alerts).
	
	$alertsDbFile = "{$path}gate/communications/alerts.db";
	if(file_exists($alertsDbFile)) {
		$alertsInfo = file_get_contents($alertsDbFile);
		$alertsInfo = json_decode($alertsInfo, true);
		if($alertsInfo === null || $alertsInfo === false) {
			exit("<h3>Communications Link Error</h3> Something went wrong with the communications\alert database file. Perhaps you did not install correctly, or have yet to install.");
		}
		
		if($alertsInfo['Last Check'] < (time() - (60 * 5))) {
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=" . urlencode($db->read("Website URL")) . "&version=" . urlencode($db->read("Version")) ."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($db->read("Application Id")) . "&emailNotifications=" . urlencode($db->read("Email Update Notifications")) . "&adminEmail=" . urlencode($db->read("Admin Email")));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
			$data = curl_exec($ch);
			
			if(curl_errno($ch) === 0) {
				if(strpos($data, "COMMUNICATIONS#1.1") !== false) {
					$text = substr($data, 28);
					
					if($text === false) $alertText = "";
					else $alertText = $text;
					$doWrite = file_put_contents($alertsDbFile, json_encode(
						array(
							"Last Check" => time(),
							"Text" => $alertText
						)
					));
					
					if($doWrite === false) {
						exit("<h1>Application Error</h1> SEO Studio could not write to the file /gate/communications/alerts.db. Please ensure the file has writing permissions.");
					}
				}
			}
		}
		else {
			$alertText = $alertsInfo['Text'];
		}
	}
	else {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://api.bherbert.org/1.1/alerts?for=seo-studio-2&url=" . urlencode($db->read("Website URL")) . "&version=" . urlencode($db->read("Version")) ."&absoluteUrl=" . urlencode("http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]") . "&appId=" . urlencode($db->read("Application Id")) . "&emailNotifications=" . urlencode($db->read("Email Update Notifications")) . "&adminEmail=" . urlencode($db->read("Admin Email")));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
		$data = curl_exec($ch);
	}
?>

<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
		<title><?=$title;?></title>
		
		<link href="//fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,400,600" rel="stylesheet">
		
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="keywords" content="<?=$db->read('Meta Keywords');?>">
		<meta name="description" content="<?=$db->read('Meta Description');?>">
		
		<link href="./<?=$path;?>css/bootstrap.css" rel="stylesheet">
		<link href="./<?=$path;?>css/bootstrap-responsive.css" rel="stylesheet">
		<link href="./<?=$path;?>css/custom.css" rel="stylesheet">
		<link href="./<?=$path;?>css/togglers.css" rel="stylesheet">
		<script src="./<?=$path;?>js/jquery.js"></script>
		
		<link href="./<?=$path;?>css/color-<?=$db->read('Theme Color');?>.css" rel="stylesheet">
		
		<!--[if lt IE 9]>
			<script src="./<?=$path;?>js/html5shiv.js"></script>
		<![endif]-->
	</head>
	<body<?php if($page && $page == 2) { ?> data-spy="scroll" data-target=".sideNavBar"<?php } ?>>
		
		<div class="navbar navbar-fixed-top">
			<div class="navbar-inner">
				<div class="container">
					
					<a class="brand" href="./<?=$path;?>"><?=$db->read("Website Name");?></a>
					<div class="nav-collapse" style="height: auto !important;">
						<ul class="nav pull-right">
							<li<?php if($page && $page == 1) { ?> class="active"<?php } ?>><a href="./<?=$path;?>"><?=$lang->translate("Home");?></a></li>
							<li<?php if($page && $page == 2) { ?> class="active"<?php } ?>><a href="./<?=$path;?>tools.php"><?=$lang->translate("Our Tools");?></a></li>
							<?php if($db->read("Admin Button") !== 'Off') { ?>
							<li<?php if($page && $page == 3) { ?> class="active"<?php } ?>><a href="./<?=$path;?>admin/login.php"><?=$lang->translate("Admin");?></a></li>
							<?php } ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
