<?php
	$title = "Competition Checker";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";

	// Get Started //
	
	date_default_timezone_set("America/Phoenix"); // Don't change this.
	
	$tags = $_POST['tags'];
	SaveResult('tags', $tags);
	
	// Perform Check //
	
	$googleResult = file_get_html("http://www.google.com/search?q=" . urlencode($_POST['tags']));
	$amountResults = $googleResult->find("div[id=resultStats]", 0);
	
	$amountResults = str_replace("About ", "", $amountResults->innertext);
	$amountResults = str_replace(" results ", "", $amountResults);
	$amountResults = str_replace(",", "", $amountResults);
	
	$wentOver = false;
	$competitionPercentile = round(($amountResults / 15000000) * 100);
	
	if($competitionPercentile > 100) { $competitionPercentile = 100; $wentOver = true; }
?>


<div class="arrow_box">
	<div class="container">
		<h3>Competition Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<div class="row">
			<div class="span9">
				<div class="well">
					<h4>Your Competition</h4>
					<p>We found an estimated <?=number_format($amountResults);?> websites around the globe that are in your competition.</p>
				</div>
				<div class="well">
					<p style="margin-bottom: 0px;">Want to test some different tags? <a href="index.php">Click here to go back.</a>
				</div>
			</div>
			<div class="span3">
				<script type='text/javascript' src='https://www.google.com/jsapi'></script>
				<script type='text/javascript'>
				  google.load('visualization', '1', {packages:['gauge']});
				  google.setOnLoadCallback(drawChart);
				  function drawChart() {
					var data = google.visualization.arrayToDataTable([
					  ['Label', 'Value'],
					  ['Competition', <?=$competitionPercentile;?>]
					]);

					var options = {
					  width: 200, height: 200,
					  redFrom: 90, redTo: 100,
					  yellowFrom:75, yellowTo: 90,
					  minorTicks: 5
					};

					var chart = new google.visualization.Gauge(document.getElementById('chart_div'));
					chart.draw(data, options);
				  }
				</script>
				<div style="padding-left: 20px;"><div id='chart_div'></div></div>
			</div>
		</div>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>