<?php
	$title = ".GOV Backlink Search";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$domain = str_replace( array("http://","https://") , "", $_POST['domain']);
	
	if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	
	// Get Google Results //
	
	$wwwLink = parse_url("http://".$domain);
	$wwwLink = str_replace("www.", "", $wwwLink['host']);
	
	$googleResult1 = file_get_html("https://www.google.com/search?q=" . urlencode('"'.$wwwLink.'"') . "+" . urlencode("site:.gov"));
	$googleResult2 = file_get_html("https://www.google.com/search?q=" . urlencode('"www.'.$wwwLink.'"') . "+" . urlencode("site:.gov"));
	
	$googleResults1 = $googleResult1->find('div[id=resultStats]', 0)->innertext;
	$googleResults1 = str_replace(array("About ", " results", ","), "", $googleResults1);
	
	$googleResults2 = $googleResult2->find('div[id=resultStats]', 0)->innertext;
	$googleResults2 = str_replace(array("About ", " results", ","), "", $googleResults2);
	
	$backlinks = $googleResults1 + $googleResults2;
?>
<div class="arrow_box">
	<div class="container">
		<h3>.GOV Backlink Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
			<div class="span4 well">
				<h4>According to Google...</h4>
				
				The website <?=$domain;?> has <?=number_format($backlinks);?> GOV backlinks.
			</div></div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
