<?php
	$title = "Meta Tag Extractor";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	
	$url = $_POST['url'];
	
	if(isValid($url)) { SaveResult('url', $url); }
	else {
		header("Location: index.php?error=1");
		exit;
	}
	
	$document = file_get_html($url);
	if(!$document) {
		header("Location: index.php?error=1");
		exit;
	}
	
	$description = $document->find( "meta[name=description]" );
	$description = $description[0]->content;
	
	$keywords = $document->find( "meta[name=keywords]" );
	$keywords = $keywords[0]->content;
	
	$ptitle = $document->find('title', 0);
	$ptitle = $ptitle->plaintext;
	
	//
	
	if(!$description) $description = "No description provided.";
	if(!$keywords) $keywords = "No keywords provided.";
	if(!$ptitle) $ptitle = "No title provided.";
?>
<div class="arrow_box">
	<div class="container">
		<h3><?=$title;?></h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
				<div class="span4">
					<div class="cmpBox">
						<div class="cmpHead">
							<h2>Title</h2>
						</div>
						<div class="cmpBody">
							<center><?=$ptitle;?></center>
						</div>
					</div>
				</div>
				<div class="span4">
					<div class="cmpBox">
						<div class="cmpHead">
							<h2>Description</h2>
						</div>
						<div class="cmpBody">
							<center><?=$description;?></center>
						</div>
					</div>
				</div>
				<div class="span4">
					<div class="cmpBox">
						<div class="cmpHead">
							<h2>Keywords</h2>
						</div>
						<div class="cmpBody">
							<center><?=$keywords;?></center>
						</div>
					</div>
				</div>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
