<?php
	$title = "PageRank Prediction";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
	require $path . "includes/pagerank.php";
	
	// Get Started //
	
	date_default_timezone_set("America/Phoenix"); // Don't change this.
	
	$domain = str_replace( array("http://","https://","www.") , "", $_POST['domain']);
	
	if(isValid("http://" . $domain)) { SaveResult('domain', $domain); }
	else { header("Location: index.php?error=1"); exit; }
	
	// Get Google Results //
	
	$pageRank = number_format(GooglePageRankChecker::getRank(@$domain));
	
	// Variables //
	
	$registeredYear = 1337;
	$prPerYear = 0;
	
	// Rough estimation //
	
	$whoisResult = file_get_html("http://www.whois.com/whois/$domain");
	$whois = $whoisResult->find('div[id=registryData]', 0)->innertext;
	$whois = str_replace("&nbsp;", " ", $whois);
	$whois = explode("<br>", $whois);
	
	foreach($whois as $row) {
		$on = false;
		
		if(strpos($row, "Created on..............:") !== false) { $on = true; }
		elseif(strpos($row, "Domain Registration Date:") !== false) { $on = true; } 
		elseif(strpos($row, "Creation Date:") !== false) { $on = true; }
		
		if($on) {
			$row = str_replace(" ", "", $row);
			$args = explode(":", $row);
			$date = $args[1];
			$date = explode("-", $date);
			$registeredYear = $date[2];
		}
	}
	
	// Checks and Balances //
	
	if($registeredYear == 1337) {
		exit('<div class="arrow_box"><div class="container"><h3>Lookup Error</h3></div></div><div class="body"><div class="container"><p>We ran into an issue. Sadly, we were not able to get the domain creation date from WHOIS records, thus we cannot estimate PageRank.</p></div></div>');
	}
	
	// Final Estimation //
	
	$maxYears = date("Y") - 1984;
	$numberYears = date("Y") - $registeredYear;
	$prPerYear = ($pageRank / $numberYears);
	$prNextYear = floor($pageRank + $prPerYear);
	
	if($prNextYear > 9) $prNextYear = 9;
?>
<div class="arrow_box">
	<div class="container">
		<h3>PageRank Prediction Results</h3>
	</div>
</div>

<div class="body">
	<div class="container">
		<p>
			<div class="alert alert-success">
				<button type="button" class="close" data-dismiss="alert">&times;</button>
				
				<strong>Success!</strong> Your results have been collected successfully.
			</div>
		</p>
		
		<p class="iForm">
			<div class="row">
				<div class="span5 well">
					<h4>RIGHT NOW (<?=date("Y");?>)</h4>
					
					The website <?=$domain;?> has a PageRank of <b><?=number_format(GooglePageRankChecker::getRank(@$domain));?></b>.
				</div>
				<div class="span5 well">
					<h4>IN 1 YEAR...</h4>
					
					The website <?=$domain;?> will have a PageRank of <b><?=number_format($prNextYear);?></b>.
				</div>
			</div>
		</p>
	</div>
</div>

<?php
	require $path . "structures/footer.php";
?>
