<?php
	$title = "Sitemap Generator";
	$page = 2;
	$path = "../../";
	
	require $path . "structures/header.php";
?>

<div class="arrow_box">
	<div class="container">
		<h3><?=$title;?></h3>
	</div>
</div>

<div class="body">
	<div class="container">
		
		<form action="generate.php" method="POST">
			<div class="row">
				<div class="span9">
					<div class="tabbable">
						<ul class="nav nav-tabs">
							<li class="active"><a href="#basic" data-toggle="tab"><?=$lang->translate("Basic");?></a></li>
							<li><a href="#advanced" data-toggle="tab"><?=$lang->translate("Advanced");?></a></li>
						</ul>
						<div class="tab-content">
							<div class="tab-pane active" id="basic">
								<table class="table table-striped">
									<tbody>
										<tr>
											<td class="valign-middle"><?=$lang->translate("Website URL");?></td>
											<td>
												<input type="text" name="url" placeholder="http://www.example.com/" >
											</td>
										</tr>
										<tr>
											<td class="valign-middle"><?=$lang->translate("Update Frequency");?></td>
											<td>
												<select name="frequency" class="">
													<option value="daily"><?=$lang->translate("Daily");?></option>
													<option value="weekly"><?=$lang->translate("Weekly");?></option>
													<option value="monthly"><?=$lang->translate("Monthly");?></option>
													<option value="yearly"><?=$lang->translate("Yearly");?></option>
												</select>
											</td>
										</tr>
										<tr>
											<td class="valign-middle"><?=$lang->translate("Website Priority");?></td>
											<td>
												<select name="priority" class="">
													<option value="1">100%</option>
													<option value="0.75">75%</option>
													<option value="0.5">50%</option>
													<option value="0.25">25%</option>
												</select>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
							<div class="tab-pane" id="advanced">
								<table class="table table-striped">
									<tbody>
										<tr>
											<td class="valign-middle"><?=$lang->translate("Crawl Speed");?></td>
											<td>
												<select name="speed" class="">
													<option value="0"><?=$lang->translate("Fast");?></option>
													<option value="1"><?=$lang->translate("Medium");?></option>
													<option value="2"><?=$lang->translate("Slow");?></option>
												</select>
											</td>
										</tr>
										<tr>
											<td class="valign-middle"><?=$lang->translate("File Name");?></td>
											<td>
												<input type="text" name="fname" value="sitemap.xml" class="">
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="form-actions">
						<div class="span2">
							<button type="submit" class="btn btn-primary" onclick="document.getElementById('pb').style.display='block';">Generate & Download</button>
						</div>
						<div class="span3">
							<div id="pb" style="display: none; margin-top: 4px;">
								<div class="progress progress-striped active" style="margin-top: 0px; margin-bottom: 0px;">
									<div class="bar" style="width: 100%;"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</form>
	</div>
</div>
		
<?php
	require $path . "structures/footer.php";
?>
