<?

include_once('engine/api/api.class.php');

new Install_Board();

class Install_Board {

  var $db  = null;
  var $dle = null;
  var $con = array();

  function __construct(){

    global $db, $config, $dle_api;

    $this->db  = $db;
    $this->dle = $dle_api;
    $this->con = $config;

    $this->install();

  }

  function install(){

    if($this->con['version_id'] < "8.2"){

      echo "<font color='red'>       </font> (     8.2  )";

      exit();

    }

    elseif(!$this->check_chmod()){

      echo "<font color='red'>      </font><br />uploads/board/<br />uploads/board/icons/<br />uploads/board/images/<br />uploads/board/thumbs/";

      exit();

    }

    elseif(!$this->install_admin()){

      echo "<font color='red'>   ,   .</font>";

      exit();

    }

    elseif(!$this->insert_dump()){

      echo "<font color='red'>   ,   .</font>";

      exit();

    }

    elseif(!$this->add_config()){

      echo "<font color='red'>   config,   .</font>";

      exit();

    }

    else echo "<b><font color='green'>  </font></b>";

  }

  function add_config(){

    if($file_config = fopen(ENGINE_DIR."/data/board_config.php", 'w+')){

      fwrite($file_config, "<? \n\n");
      fwrite($file_config, "\$board_config = array(\n\n");
      fwrite($file_config, "'version' => \"1.0\",\n\n");
      fwrite($file_config, "'key' => \"\",\n\n");
      fwrite($file_config, "'title' => \" \",\n\n");
      fwrite($file_config, "'rows_cat' => \"3\",\n\n");
      fwrite($file_config, "'thumb' => \"100\",\n\n");
      fwrite($file_config, "'rows_thumb' => \"4\",\n\n");
      fwrite($file_config, "'bul_page' => \"10\",\n\n");
      fwrite($file_config, "'show_top' => \"yes\",\n\n");
      fwrite($file_config, "'num_top' => \"10\"\n\n");
      fwrite($file_config, "); \n\n");
      fwrite($file_config, "?>");
      fclose($file_config);

      return true;

    }

    else return false;

  }

  function check_chmod(){

    if(!is_writable(ROOT_DIR."/uploads/board/")) return false;

    elseif(!is_writable(ROOT_DIR."/uploads/board/icons/")) return false;

    elseif(!is_writable(ROOT_DIR."/uploads/board/images/")) return false;

    elseif(!is_writable(ROOT_DIR."/uploads/board/thumbs/")) return false;

    else return true;

  }

  function install_admin(){

    $name  = "board";
    $title = " ";
    $descr = "   ";
    $icon  = "general.png";

    return $this->dle->install_admin_module($name, $title, $descr, $icon);

  }

  function insert_dump(){

    $tables = explode(";", $this->dump());

    foreach($tables as $table){

      if(!preg_match("#[0-9A-z]+#", $table)) continue;

      $this->db->query("".$table."");

    }

    return true;

  }

  function dump(){

    return "

      DROP TABLE IF EXISTS `".PREFIX."_board_bulletins`;
      CREATE TABLE `".PREFIX."_board_bulletins` (
       `bul_id` int(11) NOT NULL auto_increment,
       `bul_name` char(50) NOT NULL,
       `bul_email` char(50) NOT NULL,
       `bul_type` tinyint(1) NOT NULL,
       `bul_cat` int(11) NOT NULL,
       `bul_theme` varchar(250) NOT NULL,
       `bul_text` text NOT NULL,
       `bul_city` varchar(250) NOT NULL,
       `bul_phone` char(50) NOT NULL,
       `bul_start` int(11) NOT NULL,
       `bul_stop` int(11) NOT NULL,
       `bul_images` varchar(250) NOT NULL,
       PRIMARY KEY  (`bul_id`)
      ) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=".COLLATE." AUTO_INCREMENT=34 ;

      DROP TABLE IF EXISTS `".PREFIX."_board_category`;
      CREATE TABLE `".PREFIX."_board_category` (
       `cat_id` int(11) NOT NULL auto_increment,
       `cat_name` char(50) NOT NULL,
       `cat_sec` int(11) NOT NULL,
       `cat_count` int(11) NOT NULL,
       `cat_posi` int(11) NOT NULL,
       PRIMARY KEY  (`cat_id`)
      ) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=".COLLATE." AUTO_INCREMENT=72 ;

      DROP TABLE IF EXISTS `".PREFIX."_board_sections`;
      CREATE TABLE `".PREFIX."_board_sections` (
       `sec_id` int(11) NOT NULL auto_increment,
       `sec_name` char(50) NOT NULL,
       `sec_icon` varchar(250) NOT NULL,
       `sec_posi` int(11) NOT NULL,
       PRIMARY KEY  (`sec_id`)
      ) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=".COLLATE." AUTO_INCREMENT=12 ;

      INSERT INTO `".PREFIX."_board_category` VALUES (5, ' ', 2, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (6, ' ', 2, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (7, '', 1, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (8, '', 2, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (68, ' ', 1, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (10, ' ', 1, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (11, ' ', 1, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (12, ' ', 1, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (13, '-', 1, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (14, ', ', 1, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (15, '', 1, 0, 8);
      INSERT INTO `".PREFIX."_board_category` VALUES (70, ', ', 11, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (69, ' ', 11, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (18, ' ', 10, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (19, '', 8, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (20, '  ', 8, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (21, '', 8, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (22, ', ', 8, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (23, ' ', 8, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (24, '', 8, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (25, '', 8, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (26, '', 7, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (27, '', 7, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (28, '', 7, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (29, ', ', 7, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (30, '', 7, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (31, ', ', 7, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (32, ' ', 7, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (33, ' ', 6, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (34, ' ', 6, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (35, '  ', 6, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (36, '  ', 6, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (37, '', 6, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (38, '  ', 6, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (39, '', 6, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (40, '', 5, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (41, '', 5, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (42, ', , DVD', 5, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (43, '  ', 5, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (44, ' ', 5, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (45, ' ', 5, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (46, '. ', 5, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (47, '', 5, 0, 8);
      INSERT INTO `".PREFIX."_board_category` VALUES (48, ' ', 4, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (49, '  ', 4, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (50, '', 4, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (51, 'GPS ', 4, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (52, 'SAT', 4, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (53, '', 4, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (54, '', 4, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (55, '', 4, 0, 8);
      INSERT INTO `".PREFIX."_board_category` VALUES (56, '', 3, 0, 1);
      INSERT INTO `".PREFIX."_board_category` VALUES (57, ', ', 3, 0, 2);
      INSERT INTO `".PREFIX."_board_category` VALUES (58, ', ', 3, 0, 3);
      INSERT INTO `".PREFIX."_board_category` VALUES (59, '', 3, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (60, '  ', 3, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (61, '', 3, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (62, ' ', 3, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (63, '', 3, 0, 8);
      INSERT INTO `".PREFIX."_board_category` VALUES (64, '', 2, 0, 4);
      INSERT INTO `".PREFIX."_board_category` VALUES (65, ' ', 2, 0, 5);
      INSERT INTO `".PREFIX."_board_category` VALUES (66, '  ', 2, 0, 6);
      INSERT INTO `".PREFIX."_board_category` VALUES (67, '', 2, 0, 7);
      INSERT INTO `".PREFIX."_board_category` VALUES (71, ' ', 11, 0, 3);
      INSERT INTO `".PREFIX."_board_sections` VALUES (1, '  ', '/uploads/board/icons/1.gif', 1);
      INSERT INTO `".PREFIX."_board_sections` VALUES (2, '', '/uploads/board/icons/2.gif', 2);
      INSERT INTO `".PREFIX."_board_sections` VALUES (3, '', '/uploads/board/icons/3.gif', 3);
      INSERT INTO `".PREFIX."_board_sections` VALUES (4, ' ', '/uploads/board/icons/4.gif', 4);
      INSERT INTO `".PREFIX."_board_sections` VALUES (5, '', '/uploads/board/icons/5.gif', 5);
      INSERT INTO `".PREFIX."_board_sections` VALUES (6, '', '/uploads/board/icons/6.gif', 6);
      INSERT INTO `".PREFIX."_board_sections` VALUES (7, '', '/uploads/board/icons/7.gif', 7);
      INSERT INTO `".PREFIX."_board_sections` VALUES (8, ' ', '/uploads/board/icons/8.gif', 8);
      INSERT INTO `".PREFIX."_board_sections` VALUES (11, '', '/uploads/board/icons/9.gif', 9);

    ";

  }

}

?>