/* APP */

// Application
;(function(b,a){b.Application=a.extend({model:{},view:{},service:{},template:{}},Backbone.Events)})(window,_);
// Sound player
;(function(d,c,b){var a=d.SoundPlayer=function(){this.play=function(g){};var e=[];this.addSounds=function(g){e.push(g)};var f=this;c.setup({url:b.rootPath+"swf/",onready:function(){f.play=function(h){c.play(h)};f.addSounds=function(h){for(var i in h){c.createSound({id:i,url:b.rootPath+h[i],autoLoad:true,autoPlay:false,volume:100})}};f.addSounds({message:b.ui.messageSound});if(e.length>0){for(var g=0;g<e.length;g++){f.addSounds(e[g])}}}})}})(window.Application,soundManager,chatConfig);
// UI settings model
;(function(d,c,b,a){d.UISettingsModel=Backbone.Model.extend({initialize:function(){this.fetch()},fetch:function(){var e=this;c.get(b.getSettingsPath,function(f){if(f.success){e.set(f.settings)}})},save:function(){if(arguments.length>0){this.set.apply(this,arguments)}this.trigger("request");var e=this;c.post(b.updateSettingsPath,this.attributes,function(){e.trigger("sync")})},reset:function(){var e=this;c.post(b.resetSettingsPath,function(f){if(f.success){e.set(f.settings,{silent:true});e.trigger("change")}})}})})(window.Application,jQuery,window.chatConfig,_);
// Admin settings model
;(function(b,a){b.AdminSettingsModel=Backbone.Model.extend({defaults:{sound:true,scroll:true,emots:true},initialize:function(){this.fetch();this.on("change",this.save,this)},save:function(){a.cookie("customer-chat-admin-settings",JSON.stringify(this.attributes))},fetch:function(){if(a.cookie("customer-chat-admin-settings")){this.set(JSON.parse(a.cookie("customer-chat-admin-settings")))}}})})(window.Application,jQuery);
// Message model
;(function(a){a.MessageModel=Backbone.Model.extend({defaults:{author:"",body:"",toAuthor:"all",toAuthorMail:""},initialize:function(c,f){if(c){if(c.datetime){this.set("time",new Date(c.datetime.replace(/-/g,"/")))}if(typeof c.from_user_info==="string"&&c.from_user_info!=="all"){try{c.from_user_info=JSON.parse(c.from_user_info)}catch(g){}}if(typeof c.from_user_info==="object"){var d=c.from_user_info;this.fromUser=d;if(this.get("author").length===0){this.set("author",d.name)}if(!this.has("authorMail")){this.set("authorMail",d.mail)}}if(typeof c.to_user_info==="string"&&c.to_user_info!=="all"){try{c.to_user_info=JSON.parse(c.to_user_info)}catch(g){}}if(typeof c.to_user_info==="object"){var b=c.to_user_info;this.toUser=b;this.set("toAuthor",b.name);this.set("toAuthorMail",b.mail)}}},getAge:function(){var b=Math.floor(new Date().getTime()/1000);var c=Math.floor(this.get("time").getTime()/1000);return Math.ceil(b-c)},getReadableName:function(){var b=this.get("author");return b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b},getToUserReadableName:function(){var b=this.get("toAuthor");return b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b},getTalkName:function(){var b=this.get("toAuthor");return this.getReadableName()+(b?"/"+(b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b):"")}})})(window.Application);
// User model
;(function(a){a.UserModel=Backbone.Model.extend({initialize:function(b){if(typeof b.info==="string"){try{b.info=JSON.parse(b.info)}catch(c){}}},getAge:function(){this.chat=a.model.chat;var b=new Date().getTime()/1000;var c=this.get("time").getTime()/1000;return Math.ceil(b-c)},getReadableName:function(){var b=this.get("name");return b.lastIndexOf("-")!==-1?b.slice(0,b.lastIndexOf("-")):b},hasRole:function(b){return this.get("roles").indexOf(b)!==-1}})})(window.Application);
// Chat view model
;(function(d,c,b,a){d.ChatViewModel=Backbone.Model.extend({defaults:{name:"anonymous",mail:""}})})(window.Application,jQuery,window.chatConfig,_);
// Admin chat model
;(function(e,c,b,a){var d=e.AdminChatModel=Backbone.Model.extend({defaults:{name:"anonymous",mail:""},usersCache:{},guestsCache:{},lastMessages:[],readMessages:{},operatorsReady:false,lastTypingUpdate:0,talkingUsersIds:[],initialize:function(){this.user=e.model.user;this.once("change:operators",function(){this.operatorsReady=true},this);this.on("user:store",this.handleTypingUser,this);this.manageConnection()},checkUsers:function(){var f=this;c.get(b.getOnlineUsersPath,function(g){if(g.success){f.trigger("users:online",g.users)}})},keepAlive:function(){c.get(b.keepAlivePath)},handleTypingUser:function(f){if(this.talkingUsersIds.indexOf(f.id)===-1){this.talkingUsersIds.push(f.id)}},updateTypingStatus:function(f){var g=(new Date()).getTime();if(this.lastTypingUpdate+d.POLLING_INTERVAL<g){this.lastTypingUpdate=g;c.post(b.updateTypingStatusPath,{secondUserId:f,status:true})}},getTypingStatus:function(){if(this.talkingUsersIds.length>0){var f=this;c.post(b.getTypingStatusPath,{ids:this.talkingUsersIds},function(h){if(h.success){var g=f.filterTyping(h.results);if(g.length>0){f.trigger("users:typing",g)}}})}},filterTyping:function(g){var f=[];for(var h in g){if(g[h]){f.push(h)}}return f},getMessages:function(){var f=this;c.get(b.newMessagesPath,function(g){g=g.messages;if(g.length>0){g=f.filterNewMessages(g);f.loadUsersData(g,function(){f.trigger("messages:new",g)})}})},getLastMessages:function(g,h,f){c.post(b.lastMessagesPath,{lastMsgId:h,guestId:g}).success(function(i){f(i.messages)}).fail(function(){f([])})},storeUser:function(f){this.usersCache[f.id]=f;this.trigger("user:store",f)},storeGuest:function(f){this.guestsCache[f.id]=f},clearOperator:function(f){delete this.usersCache[f.id]},clearGuest:function(f){delete this.guestsCache[f.id]},loadOperators:function(){var f=this;c.get(b.listOperatorsPath,function(g){a.each(g.users,function(h){f.storeUser(h)});f.trigger("change:operators")})},getOperators:function(){var f=[];for(var g in this.usersCache){f.push(this.usersCache[g])}return f},getOperator:function(f){return this.usersCache[f]},getGuest:function(f){return this.guestsCache[f]},saveOperator:function(f){var g=a.clone(f);g.roles=g.roles.join(",");var h=this;c.post(b.saveOperatorPath,g,function(i){if(i.success){if(i.id){f.id=i.id}h.storeUser(f);h.trigger("change:operators operator:saved",f)}else{h.trigger("operator:saveError",i.errors)}})},deleteOperator:function(f){this.clearOperator(f);var g=this;c.post(b.deleteOperatorPath,f,function(h){if(h.success){g.trigger("change:operators operator:deleted")}else{g.trigger("operator:deleteError")}})},loadUsersData:function(j,l){var k=this;var h=0;for(var f=0;f<j.length;f++){var g=j[f];if(!this.usersCache[g.from_id]){h++;c.post(b.getUserPath,{id:g.from_id}).success(function(i){if(i.success){k.storeUser(i.user)}}).always(function(){h--;if(h<=0){l()}})}}if(h<=0){l()}},getOperatorName:function(f){return this.usersCache[f]&&this.usersCache[f].name},queryHistory:function(g,h,f){c.post(b.queryHistoryPath,{query:JSON.stringify(g)},function(i){h(i)}).fail(f)},sendMessage:function(g){var f={to:g.get("to"),body:g.get("body")};var h=this;c.post(b.sendMessagePath,f,function(i){if(i.success){h.trigger("messages:sent",i.to,i.message)}else{h.trigger("messages:sendError")}})},manageConnection:function(){var g=this;function f(){if(g.user.hasRole("OPERATOR")){g.getMessages();g.keepAlive();g.getTypingStatus()}g.checkUsers()}setInterval(f,d.POLLING_INTERVAL);f()},filterNewMessages:function(g){var f=[];a.each(g,function(i){var h=this.readMessages[i.talk_id];if(!h||i.id>h){f.push(i);this.readMessages[i.talk_id]=i.id}},this);return f}},{POLLING_INTERVAL:5000})})(window.Application,jQuery,window.chatConfig,_);
// Message view
;(function(e,a,d){var c=/(\w+:\/\/)?([\da-z\.\-@]+)\.([a-z\.]{2,6})([?&=%#;\/\w \.-]*)*\/?/g;var b=e.MessageView=Backbone.View.extend({initialize:function(){this.settings=e.model.settings;this.listenTo(this.model,"change",this.render);this.render();this.$el.hide();this.$el.fadeIn("fast")},render:function(){this.$el.html(d(e.template.message));this.$time=this.$(".customer-chat-content-message-time");var f=this.model.get("body").split("<").join("&lt;").split(">").join("&gt;");f=this.prepareMessage(f);this.$(".customer-chat-content-message-author").html(this.model.getReadableName()||this.model.get("author"));this.$(".customer-chat-content-message-body").html(f);this.updateTime(true);if(this.model.get("authorType")=="operator"){this.$(".customer-chat-content-message").removeClass("customer-chat-content-message").addClass("customer-chat-content-message-operator");this.$(".customer-chat-content-message-avatar").removeClass("customer-chat-content-message-avatar").addClass("customer-chat-content-message-avatar-operator")}if(this.model.fromUser&&this.model.fromUser.image){this.$(".avatar").css("background-image",'url("'+this.model.fromUser.image+'")')}if(e.UserInfoPopoverView){new e.UserInfoPopoverView({model:this.model,button:this.$(".customer-chat-content-message-author")[0]})}},prepareMessage:function(f){f=f.replace(c,function(h,i){if(h.indexOf("@")!==-1){return h}if(h.indexOf("..")!==-1){return h}return b.createLinkElement(h,(i?"":"http://")+h)});if(this.settings.get("emots")){for(var g in b.EMOTICONS){f=f.split(g).join(b.createEmotElement(b.EMOTICONS[g]))}}return f},updateTime:function(g){var o=this.model.getAge();var j=Math.floor(o/60);var n=Math.floor(j/60);var q=Math.floor(n/24);var f=Math.floor(q/7);var i=this.model.get("time");var l=(i.getDate()<10?"0":"")+i.getDate()+"."+((i.getMonth()+1)<10?"0":"")+(i.getMonth()+1)+"."+i.getFullYear();var k=(i.getHours()<10?"0":"")+i.getHours()+":"+(i.getMinutes()<10?"0":"")+i.getMinutes()+":"+(i.getSeconds()<10?"0":"")+i.getSeconds();var m=l+" "+k;if(this.options.fullDate){this.$time.html(m);return}var p=f>0?m:q>0?q+" "+a.ui.timeDaysAgo:n>0?n+" "+a.ui.timeHoursAgo:j>0?j+" "+a.ui.timeMinutesAgo:Math.max((o-o%5),1)+" "+a.ui.timeSecondsAgo;this.$time.html(p);if(g){var h=q>0?-1:n>0?(60-j%60)*60*60:j>5?(5-j%5)*60:j>0?60:10-o%10;if(h==-1){return}var r=this;this.timerId=setTimeout(function(){r.updateTime(true)},h*1000)}},clean:function(){if(this.timerId){clearTimeout(this.timerId)}return this}},{EMOTICONS:{"&gt;:|":a.rootPath+"img/emots/emot-9.png","&gt;:D":a.rootPath+"img/emots/emot-10.png",o_O:a.rootPath+"img/emots/emot-11.png",":-D":a.rootPath+"img/emots/emot-18.png",";-D":a.rootPath+"img/emots/emot-19.png","*-D":a.rootPath+"img/emots/emot-20.png",":)":a.rootPath+"img/emots/emot-1.png",";)":a.rootPath+"img/emots/emot-2.png",":(":a.rootPath+"img/emots/emot-3.png",":D":a.rootPath+"img/emots/emot-4.png",":P":a.rootPath+"img/emots/emot-5.png","=)":a.rootPath+"img/emots/emot-6.png",":|":a.rootPath+"img/emots/emot-7.png","=|":a.rootPath+"img/emots/emot-8.png","=O":a.rootPath+"img/emots/emot-12.png","&lt;3":a.rootPath+"img/emots/emot-13.png",":S":a.rootPath+"img/emots/emot-14.png",":*":a.rootPath+"img/emots/emot-15.png",":$":a.rootPath+"img/emots/emot-16.png","=B":a.rootPath+"img/emots/emot-17.png"},createEmotElement:function(f){return'<img src="'+f+'" />'},createLinkElement:function(g,f){if(g.length>40){}return'<a href="'+f+'" target="_blank">'+g+"</a>"}})})(window.Application,window.chatConfig,jQuery);
// Chatbox view
;(function(c,b){var a=c.ChatBoxView=Backbone.View.extend({initialize:function(){this.settings=c.model.settings;this.$wrapper=this.$(".customer-chat-content-messages-wrapper");this.$el.mCustomScrollbar();this.messageViews=[]},addMessage:function(g,e,f){var d=new c.MessageView({model:g,fullDate:this.options.fullDate});this.messageViews.push(d);this.$wrapper.append(d.el);var h=this;setTimeout(function(){h.$el.mCustomScrollbar("update");if(f){if(e){h.$el.mCustomScrollbar("scrollTo","bottom")}}else{if(h.settings.get("scroll")||e){h.$el.mCustomScrollbar("scrollTo","bottom")}}},200)},clear:function(){for(var d=0;d<this.messageViews.length;d++){this.messageViews[d].remove().clean()}this.$wrapper.html("");this.messageViews=[]}})})(window.Application,jQuery);
// Tabs view
;(function(d,c,b,a){d.TabsView=Backbone.View.extend({events:{"mousedown .customer-chat-tab":"switchTab","click .customer-chat-tab-prev":"prevButtons","click .customer-chat-tab-next":"nextButtons"},currentTab:0,initialize:function(){this.$tabContentContainer=this.$el;this.$container=this.$(".customer-chat-tabs");this.$buttonsContainer=this.$(".customer-chat-tabs-wrapper");this.$buttons=this.$(".customer-chat-tab-button");this.$tabs=this.$el.children(".customer-chat-tab-content");this.$prev=this.$(".customer-chat-tab-prev");this.$next=this.$(".customer-chat-tab-next");if(this.$el.is(":visible")){this.render()}else{this.$el.show();this.render();this.$el.hide()}},addTab:function(f){var g=c(f.button);this.$buttonsContainer.append(g);this.$buttons=this.$buttons.add(g);var e=c(f.content);this.$tabs=this.$tabs.add(e);this.$tabContentContainer.append(e);this.render();return e},removeTab:function(f){var g=this.$buttons.eq(f);g.remove();this.$buttons=this.$buttons.not(g);var e=this.$tabs.eq(f);e.remove();this.$tabs=this.$tabs.not(e);this.render()},showTab:function(e){if(e>=this.$tabs.length||e<0){return}this.currentTab=e;this.$tabs.hide().eq(e).show();this.$buttons.removeClass("customer-chat-active").eq(e).addClass("customer-chat-active");this.includeButtonInView(e);this.trigger("tab.show",e)},getButtonIndex:function(e){return this.$buttons.index(e)},getButton:function(e){return this.$buttons.eq(e)},includeButtonInView:function(j){this.$prev.hide();this.$next.hide();var f=a.reduce(this.$buttons,function(m,n){return m+c(n).outerWidth(true)},0);var i=this.$container.width();if(f>i){var h=this.$buttons.eq(j);var g=this.$buttonsContainer.position().left;var e=h.position().left;var l=h.outerWidth();var k=g;if(g+e<this.$prev.outerWidth()){k=-e;if(k<0){k+=this.$prev.outerWidth()-1}}else{if(g+e+l>i-this.$next.outerWidth()){k=i-(e+l);if(k+f>i){k-=this.$next.outerWidth()-1}}}if(k!==0){this.$prev.show()}if(k+f>i){this.$next.show()}this.$buttonsContainer.css("left",k)}else{this.$buttonsContainer.css("left",0)}},switchTab:function(f){var e=this.$buttons.index(f.currentTarget);this.showTab(e)},showTabForButton:function(e){this.switchTab({currentTarget:e})},prevButtons:function(){var e=this.$buttonsContainer.position().left;var f;for(f=0;f<this.$buttons.length;f++){var h=this.$buttons.eq(f);var g=h.position();g.left+=e;if(g.left<0&&0<g.left+h.outerWidth()){break}}this.includeButtonInView(f)},nextButtons:function(){var e=this.$buttonsContainer.position().left;var j=this.$container.width();var f;for(f=this.$buttons.length-1;f>=0;f--){var h=this.$buttons.eq(f);var g=h.position();g.left+=e;if(g.left<j&&j<g.left+h.outerWidth()){break}}this.includeButtonInView(f)},render:function(){var e=Math.max(Math.min(this.currentTab,this.$tabs.length-1),0);this.showTab(e)}})})(window.Application,jQuery,window.chatConfig,_);
// Menu view
;(function(c,b,a){c.MenuView=Backbone.View.extend({events:{"mousedown #customer-chat-side-button-chat":"showChat","mousedown #customer-chat-side-button-settings":"showSettings","mousedown #customer-chat-header-menu-widget-snippet":"showWidgetSnippet","mousedown #customer-chat-side-button-widget-snippet":"showWidgetSnippet","click #customer-chat-header-menu-edit":"editProfile"},msgBlinking:false,initialize:function(d){this.settings=c.model.settings;this.user=c.model.user;this.chat=c.model.chat;this.operatorsView=d.windowView.operatorsView;this.tabsView=d.windowView.tabsView;this.$window=b(window);this.$menu=this.$(".customer-chat-header-menu");this.$button=this.$("#customer-chat-button-menu");this.$avatar=this.$(".customer-chat-content-message-avatar-operator");this.$editProfile=this.$("#customer-chat-header-menu-edit");this.$install=this.$("#customer-chat-header-menu-install");this.$uninstall=this.$("#customer-chat-header-menu-uninstall");this.$widgetSnippet1=this.$("#customer-chat-header-menu-widget-snippet");this.$widgetSnippet2=this.$("#customer-chat-side-button-widget-snippet");if(this.user.hasRole("ADMIN")){if(a.ui.installed){this.$install.hide()}else{this.$uninstall.hide()}this.$editProfile.hide()}else{this.$install.hide();this.$uninstall.hide();this.$widgetSnippet1.hide();this.$widgetSnippet2.hide()}this.$sideMarker=this.$(".customer-chat-side-menu-triangle");this.$msgIcon=this.$("#customer-chat-side-button-chat i");this.$chat=this.$("#customer-chat-admin-chat");this.$settings=this.$("#customer-chat-admin-settings");this.hide();if(this.user.hasRole("OPERATOR")){this.listenTo(d.windowView.chatTabView,"talks.read",this.stopAnimateMsgIcon);this.listenTo(d.windowView.chatTabView,"talks.unread",this.animateMsgIcon)}this.listenTo(this.user,"change",this.updateUser);this.updateUser()},updateUser:function(){this.$button.find(".customer-chat-header-button-text").html("Welcome, "+this.user.getReadableName());if(this.user.get("image")){this.$avatar.css("background-image",'url("'+this.user.get("image")+'")')}},blinkMsgIcon:function(){if(!this.msgBlinking){return}var d=this;this.$msgIcon.fadeOut("slow",function(){d.$msgIcon.fadeIn("slow",function(){d.blinkMsgIcon()})})},animateMsgIcon:function(){this.msgBlinking=true;this.blinkMsgIcon()},stopAnimateMsgIcon:function(){this.msgBlinking=false},show:function(d){this.$menu.fadeIn("fast");d.stopImmediatePropagation();b("html, body").one("mousedown",b.proxy(this.hide,this))},hide:function(){this.$menu.fadeOut("fast");this.$button.one("mousedown",b.proxy(this.show,this))},showChat:function(d){var e=18+d.currentTarget.offsetTop;this.$sideMarker.animate({top:e},"fast");this.$settings.hide();this.$chat.show();b(window).resize();c.trigger("menu:show:chat")},showSettings:function(d){var e=18+(d?d.currentTarget:this.$("#customer-chat-side-button-settings")[0]).offsetTop;this.$sideMarker.animate({top:e},"fast");this.$settings.show();this.$chat.hide();this.tabsView.render();this.$("#customer-chat-admin-settings .customer-chat-content-messages").mCustomScrollbar("update");c.trigger("menu:show:settings")},editProfile:function(){var d=this.$("#customer-chat-side-button-settings")[0];this.showSettings({currentTarget:d});if(this.chat.operatorsReady){this._editProfile()}else{this.listenToOnce(this.chat,"change:operators",function(){this._editProfile()})}},_editProfile:function(){this.operatorsView.showEdit(null,this.user.get("id"));this.tabsView.showTab(this.user.hasRole("OPERATOR")?0:1)},showWidgetSnippet:function(){var d='<code>&lt;script type="text/javascript" src="'+a.widgetInitPath+'"&gt;&lt;/script&gt;</code>';c.view.dialogs.message("Widget embedding code",d)}})})(window.Application,jQuery,window.chatConfig);
// Chat tab view
;(function(c,b,a){c.ChatTabView=Backbone.View.extend({events:{"click .customer-chat-tab-button .close":"closeTalk","click .customer-chat-history-item":"showTalk"},talks:{},unreadTalks:0,initialize:function(){this.settings=c.model.settings;this.chat=c.model.chat;this.user=c.model.user;this.tabsView=new c.TabsView({el:this.$(".chat-wrapper")});this.chatBox=new c.ChatBoxView({el:this.$(".customer-chat-content-messages")});this.$emoticons=this.$(".customer-chat-emots-menu");this.$input=this.$(".customer-chat-content-message-input-field");this.$onlineList=this.$("#customer-chat-users-online .customer-chat-content-messages-wrapper.users");this.$onlineListOperator=this.$("#customer-chat-users-online .customer-chat-content-messages-wrapper.operators");if(this.user.hasRole("ADMIN")){this.tabsView.remove();this.$("#customer-chat-users-online").css("width",855)}this.listenTo(this.chat,"users:online",this.renderOnlineUsers);this.listenTo(this.chat,"messages:new",this.handleNewMessages);this.listenTo(this.tabsView,"tab.show",function(){b(window).resize()});this.listenTo(this.tabsView,"tab.show",this.handleTalkShown);this.listenTo(c,"menu:show:chat",this.handleChatShown)},renderOnlineUsers:function(j){this.$onlineList.html("");this.$onlineListOperator.html("");for(var f=0;f<j.length;f++){var e=j[f];var g=new c.UserModel(e);var d=b(c.template.historyListItem);d.data("info",g);d.find(".customer-chat-history-item-username").html(g.getReadableName());if(e.roles.indexOf("OPERATOR")!==-1){this.$onlineListOperator.append(d)}else{this.$onlineList.append(d)}new c.UserInfoPopoverView({model:g,button:d[0]});var h=this.getTalkWith(g);if(h){h.chatView.model.set(g.attributes)}}b(window).trigger("resize")},addTalk:function(g){var h=b(c.template.tabButtonChat);h.find("span").html(g.user.getReadableName());h.data("user",g.user);var e=h.find(".new-msg");e.hide();(function d(){e.animate({opacity:0.01},{duration:"slow",complete:function(){e.animate({opacity:1},{duration:"slow",complete:d})}})})();var f=b(c.template.tabContentChat);var i=new c.ChatView({el:f,model:g.user});this.tabsView.addTab({button:h,content:f});var j={chatView:i,$button:h};this.talks[g.user.get("id")]=j;this.listenTo(i,"message.sent",this.handleMessageSent);return j},removeTalkWith:function(d){var e=this.talks[d.get("id")];this.tabsView.removeTab(this.tabsView.getButtonIndex(e.$button[0]));e.chatView.remove();delete this.talks[d.get("id")]},hasTalkWith:function(d){return !!this.talks[d.get("id")]},getTalkWith:function(d){return this.talks[d.get("id")]},showTalk:function(f){var d=b(f.currentTarget).data("info");if(this.user.hasRole("ADMIN")){c.trigger("history.search",{name:d.get("name"),mail:d.get("mail"),fromDate:"",toDate:""});return}var g=this.getTalkWith(d);if(!g){g=this.addTalk({user:d});this.chat.getLastMessages(d.get("id"),null,function(e){if(e.length>0){g.chatView.handleNewMessages(e,true)}})}this.tabsView.showTabForButton(g.$button[0])},closeTalk:function(f){var d=b(f.currentTarget).parent(".customer-chat-tab-button").data("user");this.removeTalkWith(d);f.stopImmediatePropagation()},handleNewMessages:function(e){var d=_.groupBy(e,"from_id");_.each(d,function(h){var g=new c.UserModel(h[0].from_user_info);var j=this.getTalkWith(g);if(!j){j=this.addTalk({user:g});var f=h[0];var i=this;this.chat.getLastMessages(g.get("id"),f.id,function(k){if(k.length>0){j.chatView.handleNewMessages(k,true)}i.initTalk(j,h)})}else{this.initTalk(j,h)}},this)},initTalk:function(f,e){f.chatView.handleNewMessages(e);var d=f.$button.find(".new-msg");if(d.is(":hidden")){d.show();this.updateUnreadCounter(1)}},handleMessageSent:function(e){var f=this.getTalkWith(new c.UserModel({id:e.get("to")}));var d=f.$button.find(".new-msg");if(d.is(":visible")){d.hide();this.updateUnreadCounter(-1)}},handleTalkShown:function(d){var e=this.tabsView.getButton(d).find(".new-msg");if(e.is(":visible")){e.hide();this.updateUnreadCounter(-1)}},handleChatShown:function(){this.tabsView.render()},updateUnreadCounter:function(d){var e=this.unreadTalks;this.unreadTalks=Math.max(0,this.unreadTalks+d);if(e===1&&this.unreadTalks===0){this.trigger("talks.read")}else{this.trigger("talks.unread")}}})})(window.Application,jQuery,window.chatConfig);
// Chat view
;(function(e,c,b,a){var d=e.ChatView=Backbone.View.extend({events:{"click .customer-chat-content-message-emots-button":"toggleEmoticons","click .customer-chat-emoticon":"addEmoticon","keydown .customer-chat-content-message-input-field":"sendMessage"},guestUrl:"",typingInfoBlinking:false,initialize:function(){this.settings=e.model.settings;this.chat=e.model.chat;this.user=e.model.user;this.chatBox=new e.ChatBoxView({el:this.$(".customer-chat-content-messages")});this.$currentUrl=this.$(".current-url");this.$emoticons=this.$(".customer-chat-emots-menu");this.$typingInfo=this.$(".typing-indicator");this.$input=this.$(".customer-chat-content-message-input-field");if(this.model.hasRole("OPERATOR")){this.$el.addClass("operator")}this.listenTo(this.chat,"messages:sent",this.handleMessageSent);this.listenTo(this.model,"change",this.handleModelUpdate);this.handleModelUpdate();this.listenTo(this.chat,"users:typing",this.handleRemoteTyping)},toggleEmoticons:function(){this.$emoticons.toggle("fade","fast")},addEmoticon:function(g){var f=c(g.currentTarget);this.$input.val(this.$input.val()+" "+f.data("emot")+" ");this.$input.focus();this.$emoticons.fadeOut("fast")},sendMessage:function(g){this.handleTyping();if(g.keyCode!==13||g.shiftKey){return}var f=this.$input.val();if(f.length==0){return}var h=new e.MessageModel({author:this.user.get("name"),mail:this.user.get("mail"),authorType:"operator",body:f,time:new Date(),to:this.model.get("id")});h.fromUser=this.user.attributes;this.chat.sendMessage(h);this.chatBox.addMessage(h,true);this.$input.val("");this.trigger("message.sent",h)},handleMessageSent:function(h,f){if(h===this.model.get("id")&&f.to_id===-2){f.from_user_info.image="no_image.jpg";var g=new e.MessageModel({author:"[system message]",body:"Another operator is already helping this guest, your messages will not be delivered.",datetime:new Date(),image:"#",from_user_info:f.from_user_info});this.chatBox.addMessage(g,true)}},handleNewMessages:function(g,f){a.each(g,this.handleMessage,this);if(!f&&g.length>0&&this.settings.get("sound")){e.service.soundPlayer.play("message")}},handleMessage:function(f){f.info=this.model.get("info");var g=new e.MessageModel(f);this.chatBox.addMessage(g)},handleTyping:function(){this.chat.updateTypingStatus(this.model.get("id"))},handleRemoteTyping:function(f){if(f.indexOf(this.model.get("id"))===-1){return}this.startTypingInfoBlink();if(this.stopTypingBlinkTimer){clearTimeout(this.stopTypingBlinkTimer)}this.stopTypingBlinkTimer=setTimeout(c.proxy(this.stopTypingInfoBlink,this),d.TYPING_STATUS_TIME)},handleModelUpdate:function(){var f=this.model.get("info");if(f){if(this.guestUrl!==f.referer){this.guestUrl=f.referer;var g=this;this.$currentUrl.parent().animate({opacity:0},{duration:"slow",complete:function(){g.$currentUrl.html(f.referer).attr("href",f.referer);c(this).animate({opacity:1},{duration:"slow"})}})}}},startTypingInfoBlink:function(){if(!this.typingInfoBlinking){this.typingInfoBlinking=true;this.blinkTypingInfo()}},blinkTypingInfo:function(){if(!this.typingInfoBlinking){return}var f=this;this.$typingInfo.fadeIn("slow",function(){f.$typingInfo.fadeOut("slow",function(){f.blinkTypingInfo()})})},stopTypingInfoBlink:function(){this.typingInfoBlinking=false}},{TYPING_STATUS_TIME:2000})})(window.Application,jQuery,window.chatConfig,_);
// Settings view
;(function(b,a){b.SettingsView=Backbone.View.extend({mailExp:new RegExp("^[-+\\.0-9=a-z_]+@([-0-9a-z]+\\.)+([0-9a-z]){2,4}$","i"),colorExp:new RegExp("^#(([0-9a-fA-F]{3})|([0-9a-fA-F]{6}))$"),events:{"click #customer-chat-ui-save":"save","click #customer-chat-ui-reset":"reset","change #inputMsgSound":"playSound"},errors:false,inputs:null,syncing:false,initialize:function(){this.model=b.model.uiSettings;this.$inputs=this.$("*[name]");this.$msgSound=this.$("#inputMsgSound");this.$save=this.$("#customer-chat-ui-save");this.$loading=this.$(".customer-chat-content-loading-icon").hide();this.$inputs.blur(a.proxy(this.validate,this));this.initColorPickers();this.soundPlayer=b.service.soundPlayer;var c=this;this.$msgSound.find("option").each(function(){var d={};d[this.value]=this.value;c.soundPlayer.addSounds(d)});this.model.on("change",this.render,this);this.model.on("request",this.disable,this);this.model.on("sync",this.enable,this);this.render()},validate:function(c,d){this.errors=false;var e=this;this.$inputs.each(function(){var f=a(this);f.removeClass("customer-chat-input-error");switch(f.data("validator")){case"color":if(f.val().length==0||!e.colorExp.test(f.val())){f.addClass("customer-chat-input-error");e.errors=true}break;case"mail":if(f.val().length==0||!e.mailExp.test(f.val())){f.addClass("customer-chat-input-error");e.errors=true}break;case"number":if(!(/^[\d]+$/.test(f.val())&&parseInt(f.val())>=0)){f.addClass("customer-chat-input-error");e.errors=true}break}});if(d&&this.errors){b.view.dialogs.message("Form error","Some settings are invalid")}},isValid:function(){this.validate(null,true);return !this.errors},save:function(){if(this.isValid()){var c={};this.$inputs.each(function(){var d=a(this);if(d.attr("type")=="checkbox"){c[d.attr("name")]=d.is(":checked")?"true":"false"}else{c[d.attr("name")]=d.val()}});if(!this.syncing){this.model.save(c)}}},reset:function(){var c=this;b.view.dialogs.confirm("Reset settings","Are you sure you want to reset all the settings?",{Reset:function(){c._reset();a(this).dialog("close")}})},_reset:function(){this.model.reset()},render:function(){var c=this;this.$inputs.each(function(){var d=a(this);if(d.attr("type")=="checkbox"){d.attr("checked",c.model.get(d.attr("name"))=="true")}else{d.val(c.model.get(d.attr("name")))}});this.validate()},disable:function(){this.syncing=true;this.$save.addClass("button-disabled");this.$loading.fadeIn()},enable:function(){var c=this;setTimeout(function(){c.$save.removeClass("button-disabled");c.$loading.fadeOut();c.syncing=false},500)},initColorPickers:function(){a(".color-input").each(function(){var c=a(this);c.ColorPicker({onSubmit:function(d,f,e){c.val("#"+f);c.ColorPickerHide()},onChange:function(d,f,e){c.val("#"+f);c.blur()},onBeforeShow:function(){c.ColorPickerSetColor(this.value)}}).bind("keyup",function(){c.ColorPickerSetColor(this.value)})})},playSound:function(){this.soundPlayer.play(this.$msgSound.val())}})})(window.Application,jQuery);
// Operators view
;(function(d,c,b,a){d.OperatorsView=Backbone.View.extend({mailExp:new RegExp("^[-+\\.0-9=a-z_]+@([-0-9a-z]+\\.)+([0-9a-z]){2,4}$","i"),events:{"click #customer-chat-operators-back":"showList","click #customer-chat-operators-add":"showAdd","click #customer-chat-operators-change-password":"showChangePassword","click #customer-chat-operators-cancel":"showEdit","click .customer-chat-operators-edit":"showEdit","click .customer-chat-operators-remove":"deleteOperator","click #avatar-from-collection":"selectAvatar","click #customer-chat-operators-save":"save"},initialize:function(){this.model=d.model.chat;this.user=d.model.user;this.$list=this.$("#customer-chat-operators-list");this.$operators=this.$list.find(".customer-chat-content-messages-wrapper");this.$edit=this.$("#customer-chat-operators-edit");this.$save=this.$("#customer-chat-operators-save");this.$back=this.$("#customer-chat-operators-back");this.$editInputs=this.$edit.find("input");this.$avatarInput=this.$edit.find("#avatarUploadField");this.$loading=this.$(".customer-chat-content-loading-icon").hide();if(this.user.hasRole("OPERATOR")){this.$back.remove();this.listenToOnce(this.model,"change:operators",function(){this.showEdit(null,this.user.get("id"))})}this.$editInputs.blur(c.proxy(this.validateEdit,this));this.model.on("change:operators",this.render,this);this.showList();this.render();this.model.loadOperators()},render:function(){this.$operators.html("");var e=this;b.each(this.model.getOperators(),function(g){var f=c(d.template.operatorItem);if(g.image){e.setEditAvatarIcon(f,g.image)}f.find(".customer-chat-operator-name").html(g.name);f.find(".customer-chat-operator-mail").html(g.mail);f.find(".customer-chat-operators-edit").data("id",g.id);f.find(".customer-chat-operators-remove").data("id",g.id);e.$operators.append(f)})},setEditAvatarIcon:function(e,f){e.find(".avatar").css("background-image",'url("'+f+'")')},showList:function(){this.state="list";this.$edit.hide();this.$list.show();this.enable()},showEdit:function(e,l){var k=this;var j=this.state;this.state="edit";this.$edit.find(".add-only, .pass-only").hide();this.$edit.find(".edit-only").show();this.$edit.find(".customer-chat-input-error").removeClass("customer-chat-input-error");var g=e?c(e.currentTarget):null;var h,f;if(j!=="pass"){h=g?g.data("id"):l;f=d.model.selectedOperator=d.model.chat.getOperator(h)}else{f=d.model.selectedOperator;h=f.id}this.$edit.find(".customer-chat-tabs-header").html(this.user.get("id")===l?"Edit profile":"Edit operator");if(f){this.$edit.find("#usernameField").val(f.name);this.$edit.find("#mailField").val(f.mail);if(f.image){k.setEditAvatarIcon(this.$edit,f.image)}}var i=d.view.dialogs;this.$avatarInput.ajaxfileupload({action:a.uploadAvatarPath,params:{userId:h},onStart:function(){i.message("Uploading","Uploading image, please wait...")},onComplete:function(m){i.message("Avatar uploaded","Uploaded successfully");f.image=m.image;k.model.saveOperator(f);k.setEditAvatarIcon(k.$edit,f.image)}});this.$list.hide();this.$edit.show()},deleteOperator:function(e){var g=c(e.currentTarget);var f=d.model.chat.getOperator(g.data("id"));var i=this;var h={};h['Remove "%user%"'.replace("%user%",f.name)]=function(){i.model.deleteOperator(f);c(this).dialog("close");c(window).trigger("resize")};d.view.dialogs.confirm('Remove "%user%"?'.replace("%user%",f.name),"Are you sure you want to permanently delete this user?",h)},showAdd:function(){this.state="add";this.$edit.find(".customer-chat-tabs-header").html("Add new operator");this.$edit.find(".edit-only, .pass-only").hide();this.$edit.find(".add-only").show();this.$edit.find(".customer-chat-input-error").removeClass("customer-chat-input-error");d.model.selectedOperator={roles:["OPERATOR"]};this.$edit.find("#usernameField").val("");this.$edit.find("#mailField").val("");this.$edit.find("#passField").val("");this.$edit.find("#rePassField").val("");this.$list.hide();this.$edit.show()},showChangePassword:function(){this.state="pass";this.$edit.find(".customer-chat-tabs-header").html("Change password");this.$edit.find(".edit-only, .add-only").hide();this.$edit.find(".pass-only").show();if(this.user.hasRole("ADMIN")){this.$edit.find(".current-pass").hide()}this.$edit.find(".customer-chat-input-error").removeClass("customer-chat-input-error");this.$edit.find("#changePassCurrentField").val("");this.$edit.find("#changePassField").val("");this.$edit.find("#changePassRetypeField").val("");this.$list.hide();this.$edit.show()},selectAvatar:function(){var f=this;var e=new d.SelectAvatarView({model:a.defaultAvatars});d.view.dialogs.confirm("Select avatar",e,{OK:function(){var i=c(this);var h=e.selected;i.dialog("close");if(h){var g=d.model.selectedOperator;g.image=h;f.model.saveOperator(g);f.setEditAvatarIcon(f.$edit,g.image)}}})},save:function(){if(!this.isEditValid()){return}if(this.syncing){return}this.disable();var e=d.model.selectedOperator;if(e){if(this.state=="edit"||this.state=="add"){e.name=this.$edit.find("#usernameField").val();e.mail=this.$edit.find("#mailField").val();e.password=this.$edit.find("#passField").val()}else{if(this.state=="pass"){e.currPassword=this.$edit.find("#changePassCurrentField").val();e.password=this.$edit.find("#changePassField").val()}}var f=this;d.model.chat.once("operator:saved",function(g){f.enable();if(f.user.hasRole("ADMIN")){f.showList()}else{f.showEdit()}});d.model.chat.once("operator:saveError",function(g){f.enable();d.view.dialogs.formError("Form error",b.values(g))});d.model.chat.saveOperator(e)}else{this.enable()}},disable:function(){this.syncing=true;this.$save.addClass("button-disabled");this.$loading.fadeIn()},enable:function(){var e=this;setTimeout(function(){e.$save.removeClass("button-disabled");e.$loading.fadeOut();e.syncing=false;if(e.state=="add"){e.showList()}},500)},validateEdit:function(f,i){this.errors=false;var j=this;var h=i?this.$editInputs:c(f.target);if(!i){var e=c(f.target).data("validator-match");if(e){h=h.add(j.$el.find("#"+e))}}j.errors=[];function g(l,m){l.addClass("customer-chat-input-error");if(l.data("validator-msg")!==false){var k=l.data("validator-label");if(k){m=k+": "+m}j.errors.push(m)}else{j.errors.push(false)}}h.each(function(){var m=c(this);var o=m.data("validator-state");var n=m.data("validator-state-ex");if(o&&o!==j.state){return}if(n&&n===j.state){return}m.removeClass("customer-chat-input-error");switch(m.data("validator")){case"mail":if(m.val().length==0||!j.mailExp.test(m.val())){g(m,"Enter valid e-mail address")}break;case"notEmpty":if(m.val().length==0){g(m,"Value cannot be empty")}break;case"password":if(m.val().length<6){g(m,"Password has to be at least 6 characters long")}break}var k=m.data("validator-match");if(k){var l=j.$el.find("#"+k);if(m.val()!==l.val()){g(m,"Passwords have to match")}}});if(i&&this.errors.length>0){d.view.dialogs.formError("Form error",this.errors)}},isEditValid:function(){this.validateEdit(null,true);return this.errors.length===0}})})(window.Application,jQuery,_,window.chatConfig);
// Select avatar view
;(function(c,a,b){c.SelectAvatarView=Backbone.View.extend({events:{"mousedown .customer-chat-content-message-avatar":"selectAvatar"},render:function(){this.$el.html(c.template.selectAvatarContent);this.$avatars=this.$(".avatars");for(var d=0;d<this.model.length;d++){var e=b('<i class="customer-chat-content-message-avatar"></i>');e.css("background-image",'url("'+this.model[d]+'")').data("image",this.model[d]);this.$avatars.append(e)}this.$el.find(".avatars-wrapper").mCustomScrollbar();b(window).resize();return this},selectAvatar:function(g){var d=b(g.currentTarget);var f=d.data("image");this.$avatars.children().removeClass("selected");d.addClass("selected");this.selected=f}})})(window.Application,chatConfig,jQuery);
// History view
;(function(d,c,a){var b=d.HistoryView=Backbone.View.extend({events:{"click #customer-chat-history-search":"search","keydown input":"searchOnEnter","click .customer-chat-history-item":"showConversation","click #history-list-display-more":"displayMoreResults"},searching:false,lastSearch:{items:[],displayed:0},initialize:function(){this.model=d.model.chat;this.$results=this.$("#customer-chat-history-search-results");this.$inputs=this.$("*[name]");this.$search=this.$("#customer-chat-history-search");this.$loading=this.$(".customer-chat-content-loading-icon").hide();this.$resultItems=this.$("#customer-chat-history-search-results .customer-chat-content-messages-wrapper");this.$displayMore=c(d.template.historyListDisplayMore);this.$chatHeader=this.$("#customer-chat-talk-header");this.$headerUser1=this.$("#history-chat-user-1");this.$headerId1=this.$("#history-chat-id-1");this.$headerMail1=this.$("#history-chat-mail-1");this.$headerUser2=this.$("#history-chat-user-2");this.$headerId2=this.$("#history-chat-id-2");this.$headerMail2=this.$("#history-chat-mail-2");this.$headerAvatar1=this.$("#history-chat-avatar-1");this.$headerAvatar2=this.$("#history-chat-avatar-2");this.$headerDate=this.$chatHeader.find(".date-info");this.$(".date-input").datepicker();this.$results.mCustomScrollbar();this.chatBoxView=new d.ChatBoxView({el:this.$("#history-results-chat"),model:new d.ChatViewModel(),fullDate:true});this.model.on("change",this.render,this);this.model.on("request",this.disable,this);this.model.on("sync",this.enable,this);this.listenTo(d,"history.search",this.autoSearch);this.render()},search:function(){if(!this.searching){this.searching=true;this.clearSearchResults();var e={};this.$inputs.each(function(){var f=c(this);if(f.val()){if(f.attr("type")=="checkbox"){e[f.attr("name")]=f.is(":checked")?"true":"false"}else{e[f.attr("name")]=f.val()}}});this.model.queryHistory(e,c.proxy(this.onQueryResults,this),c.proxy(this.onQueryError,this))}},searchOnEnter:function(f){if(f.which===13){this.search()}},autoSearch:function(e){this.$inputs.each(function(){var g=c(this);var f=g.attr("name");if(typeof e[f]!==undefined){g.val(e[f])}});this.search()},onQueryError:function(){this.searching=false},onQueryResults:function(e){this.searching=false;this.prepareResults(e);this.lastSearch.items=e;this.lastSearch.displayed=0;this.clearSearchResults();this.displayMoreResults()},displayMoreResults:function(){var e=this.lastSearch.items;var f=this.lastSearch.displayed;if(f<e.length){var g=Math.max(0,Math.min(e.length,f+b.RESULTS_DISPLAY_COUNT));this.addSearchResults(e.slice(f,g));f=g}if(e.length>f){this.$resultItems.append(this.$displayMore.show())}else{this.$displayMore.remove()}this.$results.mCustomScrollbar("update");this.lastSearch.displayed=f},render:function(){},setSearchResults:function(e){this.clearSearchResults();this.addSearchResults(e)},addSearchResults:function(e){for(var f=0;f<e.length;f++){this.addSearchResult(e[f])}},clearSearchResults:function(){this.$resultItems.html("");this.$results.mCustomScrollbar("update")},addSearchResult:function(h){var i=h[0];var k=c(d.template.historyListItem);var g=new Date(i.datetime);var e=g.getDate()<10?"0"+g.getDate():g.getDate();var m=(g.getMonth()+1<10)?"0"+(g.getMonth()+1):(g.getMonth()+1);var j=isNaN(g.getDay())?"":e+"."+m+"."+g.getFullYear();var l=new d.MessageModel(i);k.find(".customer-chat-history-item-username").html(l.getTalkName());k.find(".customer-chat-history-item-time").html(j);var f=a.clone(l.attributes);f.author=f.author+" ("+f.authorMail+")";k.data("info",h);this.$resultItems.append(k);this.$results.mCustomScrollbar("update")},showConversation:function(f){this.chatBoxView.clear();var g=c(f.currentTarget);var e=g.data("info");var l=new d.MessageModel(e[0]);var k=new d.MessageModel(e[e.length-1]);if(l.fromUser.image){this.$headerAvatar1.css("background-image",'url("'+l.fromUser.image+'")')}if(l.toUser&&l.toUser.image){this.$headerAvatar2.css("background-image",'url("'+l.toUser.image+'")')}this.$headerUser1.html(l.getReadableName());this.$headerId1.html(l.get("author"));this.$headerMail1.html(l.get("authorMail"));this.$headerUser2.html(l.getToUserReadableName());this.$headerId2.html(l.get("toAuthor"));this.$headerMail2.html(l.get("toAuthorMail"));this.$headerDate.html(l.get("datetime")+" — "+k.get("datetime"));this.$chatHeader.show();e.sort(function(m,i){return m.datetime>i.datetime?1:-1});for(var h=0;h<e.length;h++){var j=e[h];j.info=j.from_user_info.info;this.chatBoxView.addMessage(new d.MessageModel(j),false,true)}},prepareResults:function(f){for(var e=0;e<f.length;e++){var g=f[e];if(g.roles&&g.roles.toLowerCase().indexOf("guest")!==-1){g.name=g.name.lastIndexOf("-")!==-1?g.name.slice(0,g.name.lastIndexOf("-")):g.name}}}},{RESULTS_DISPLAY_COUNT:20})})(window.Application,jQuery,_);
// Window view
;(function(c,b,a){c.WindowView=Backbone.View.extend({initialize:function(){this.settings=c.model.settings;var d=this.user=c.model.user;if(d.hasRole("ADMIN")){this.settingsView=new c.SettingsView({el:this.$(".customer-chat-tab-content-settings-ui")})}this.chatTabView=new c.ChatTabView({el:this.$("#customer-chat-admin-chat")});this.operatorsView=new c.OperatorsView({el:this.$("#customer-chat-operators-tab")});this.historyView=new c.HistoryView({el:this.$("#customer-chat-history")});this.tabsView=new c.TabsView({el:this.$("#customer-chat-admin-settings")});this.menuView=new c.MenuView({el:this.el,windowView:this});if(!d.hasRole("ADMIN")){this.tabsView.removeTab(0);this.$(".customer-chat-tab-button.operators").html("Edit profile")}this.$("#customer-chat-admin-settings .customer-chat-content-messages").bind("show",function(){b(window).trigger("resize")}).not("#customer-chat-history .customer-chat-content-messages").mCustomScrollbar();window.alert=function(e){c.view.dialogs.message("Alert",e)};this.$el.animate({opacity:1},{duration:"slow"});this.listenTo(c,"history.search",this.showHistory)},showHistory:function(){this.menuView.showSettings();this.tabsView.showTab(this.user.hasRole("OPERATOR")?1:2)}})})(window.Application,jQuery,window.chatConfig);
// Dialogs view
;(function(b,a){b.DialogsView=Backbone.View.extend({initialize:function(){this.$confirm=a(b.template.confirmDialog);this.$formError=a(b.template.formErrorDialog)},confirm:function(e,d,c){if(d){if(d instanceof Backbone.View){this.$confirm.html("").append(d.render().el)}else{this.$confirm.html(d)}}if(!c.Cancel){c.Cancel=function(){a(this).dialog("close")}}this.$confirm.dialog({title:e,resizable:false,modal:true,width:400,height:"auto",buttons:c,show:"fade",position:{of:b.view.window.$el}})},formError:function(g,f){this.$formError.html("");for(var d=0;d<f.length;d++){var c=a("<p>");var e=f[d];if(e&&e.length>0){c.html(f[d])}this.$formError.append(c)}this.$formError.dialog({title:g,resizable:false,modal:true,width:400,height:"auto",buttons:{Close:function(){a(this).dialog("close")}},show:"fade",position:{of:b.view.window.$el}})},message:function(d,c){this.$formError.html("<p>"+c+"</p>");this.$formError.dialog({title:d,resizable:false,modal:true,width:400,height:"auto",buttons:{Close:function(){a(this).dialog("close")}},show:"fade",position:{of:b.view.window.$el}})}})})(window.Application,jQuery);
// User info popover view
;(function(c,a,b){c.UserInfoPopoverView=Backbone.View.extend({initialize:function(d){var e=b(d.button);e.popover({placement:"top",trigger:"manual",container:"body",title:"User info",html:true,content:this.render().$el}).mouseenter(function(){var g=b(this);b("body > .popover").remove();g.popover("show");var f=b("body > .popover");g.add(f).bind("mouseleave",function(){setTimeout(function(){if(!f.underMouse()){f.remove()}},250)})})},render:function(){this.$el.html(c.template.userInfoPopoverContent);this.$("#user-popover-name").html(this.model.getReadableName());this.$("#user-popover-id").html(this.model.get("author")||this.model.get("name"));this.$("#user-popover-mail").html(this.model.get("authorMail")||this.model.get("mail"));this.$("#user-popover-ip").html(this.model.has("info")?this.model.get("info").ip:"PRIVATE");if(this.model.fromUser&&this.model.fromUser.image){this.$(".avatar").css("background-image",'url("'+this.model.fromUser.image+'")')}else{if(this.model.get("image")){this.$(".avatar").css("background-image",'url("'+this.model.get("image")+'")')}}if(!this.model.has("info")){this.$("#user-popover-ip").parent().hide()}return this}})})(window.Application,chatConfig,jQuery);
// admin.js
;jQuery(function(b){var a=window.chatConfig;b.get(a.templatesPath,function(d){var c=b(d);var e=window.Application;e.service.soundPlayer=new e.SoundPlayer();e.template.message=c.find("#message").html();e.template.operatorItem=c.find("#operator-item").html();e.template.installDialogContent=c.find("#dialog-install-content").html();e.template.confirmDialog=c.find("#dialog-confirm").html();e.template.formErrorDialog=c.find("#dialog-form-error").html();e.template.selectAvatarContent=c.find("#dialog-select-avatar-content").html();e.template.historyListItem=c.find("#history-list-item").html();e.template.historyListDisplayMore=c.find("#history-list-display-more").html();e.template.userInfoPopoverContent=c.find("#user-info-popover-content").html();e.template.tabButtonChat=c.find("#tab-button-chat").html();e.template.tabContentChat=c.find("#tab-content-chat").html();e.model.user=new e.UserModel(window.userData);e.model.uiSettings=new e.UISettingsModel();e.model.settings=new e.AdminSettingsModel();e.model.chat=new e.AdminChatModel();e.model.user.listenTo(e.model.chat,"operator:saved",function(f){if(f.id===this.get("id")){this.set(f)}});e.view.window=new e.WindowView({el:"#customer-chat",model:e.model.chat});e.view.dialogs=new e.DialogsView();if(!a.ui.installed){if(e.model.user.hasRole("ADMIN")){e.view.dialogs.confirm("Install",e.template.installDialogContent,{Install:function(){(document.location||window.location).href=a.installPath}})}else{e.view.dialogs.message("Please install first",'The application is not yet installed, please log in as "admin" and install it before using')}}})});
