/*
    Document   :  aaFreamwork
    Created on :  August, 2013
    Author     :  Andrei Dinca, AA-Team http://codecanyon.net/user/AA-Team
*/

(function ($) {
    jQuery.fn.aaFreamwork = function (options) {
        var defaults = {
            prefix			: ''
        };
        var option = jQuery.extend({}, defaults, options);
        return this.each(function () {
            var t 			= jQuery("div.wrapper-" + option.prefix ),
				ajaxBox 	= t.find('#psp-ajax-response'),
				section		= 'dashboard',
				topMenu 	= t.find('#psp-topMenu');
            var plugin = {
                init: function ()
				{
					plugin.triggers();
					plugin.fixLayoutHeight();
                },
				ajaxLoading: function(status)
				{
					var loading = jQuery('<div id="psp-ajaxLoadingBox" class="psp-panel-widget">loading</div>');
					// append loading
					ajaxBox.html(loading);
				},
				makeRequest: function( callback )
				{
					// do not exect the request if we are not into our ajax request pages
					if( ajaxBox.size() == 0 ) return false;

					plugin.ajaxLoading();
					var data = {
						'action' 	: 'pspLoadSection',
						'section' 	: section
					};
					// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
					jQuery.post(ajaxurl, data, function(response) {
						if(response.status == 'ok'){
							ajaxBox.html(response.html);
							
							plugin.makeTabs();
							plugin.makeActiveMenu();
							
							if( typeof pspDashboard != "undefined" ){
								pspDashboard.init();
							}
							
							// callback - subsection!
							if ( $.isArray(callback) && callback.length == 2 && $.isFunction( callback[0] ) )
								callback[0]( callback[1] );
						}
					}, 'json');
				},
				
				importSEOData: function($btn)
				{
					var theForm 		= $btn.parents('form').eq(0),
						value 			= $btn.val(),
						statusBoxHtml 	= theForm.find('div.psp-message');
					// replace the save button value with loading message
					$btn.val('installing default settings ...').removeClass('blue').addClass('gray');
					if(theForm.length > 0) {
						// serialiaze the form and send to saving data
						var data = {
							'action' 	: 'pspimportSEOData',
							'options' 	: theForm.serialize(),
							'from'		: theForm.find('#from').val()
						};
						// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
						jQuery.post(ajaxurl, data, function(response) {

							if(response.status == 'valid'){
								statusBoxHtml.removeClass('psp-error').addClass('psp-success').html(response.html).fadeIn().delay(3000).fadeOut();
								setTimeout(function(){
									window.location.reload();
								}, 3000);
							}else{
								statusBoxHtml.removeClass('psp-success').addClass('psp-error').html(response.html).fadeIn().delay(13000).fadeOut();
							}
							// replace the save button value with default message
							$btn.val( value ).removeClass('gray').addClass('blue');
						}, 'json');
					}
				},
				installDefaultOptions: function($btn)
				{
					var theForm 		= $btn.parents('form').eq(0),
						value 			= $btn.val(),
						statusBoxHtml 	= theForm.find('div.psp-message');
					// replace the save button value with loading message
					$btn.val('installing default settings ...').removeClass('blue').addClass('gray');
					if(theForm.length > 0) {
						// serialiaze the form and send to saving data
						var data = {
							'action' 	: 'pspInstallDefaultOptions',
							'options' 	: theForm.serialize()
						};
						// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
						jQuery.post(ajaxurl, data, function(response) {
							if(response.status == 'ok'){
								statusBoxHtml.addClass('psp-success').html(response.html).fadeIn().delay(3000).fadeOut();
								setTimeout(function(){
									window.location.reload();
								}, 1000);
							}else{
								statusBoxHtml.addClass('psp-error').html(response.html).fadeIn().delay(13000).fadeOut();
							}
							// replace the save button value with default message
							$btn.val( value ).removeClass('gray').addClass('blue');
						}, 'json');
					}
				},
				saveOptions: function($btn)
				{
					var theForm 		= $btn.parents('form').eq(0),
						value 			= $btn.val(),
						statusBoxHtml 	= theForm.find('div#psp-status-box');
					// replace the save button value with loading message
					$btn.val('saving setings ...').removeClass('green').addClass('gray');
					if(theForm.length > 0) {
						// serialiaze the form and send to saving data
						var data = {
							'action' 	: 'pspSaveOptions',
							'options' 	: theForm.serialize()
						};
						// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
						jQuery.post(ajaxurl, data, function(response) {
							if(response.status == 'ok'){
								
								statusBoxHtml.addClass('psp-success').html(response.html).fadeIn().delay(3000).fadeOut();
								if(section == 'synchronization'){
									plugin.updateCron();
								}
							}
							// replace the save button value with default message
							$btn.val( value ).removeClass('gray').addClass('green');
						}, 'json');
					}
				},
				moduleChangeStatus: function ($btn)
				{
					var value = $btn.text(),
						the_status = $btn.hasClass('activate') ? 'true' : 'false';
					// replace the save button value with loading message
					$btn.text('saving setings ...');
					var data = {
						'action' 		: 'pspModuleChangeStatus',
						'module' 		: $btn.attr('rel'),
						'the_status' 	: the_status
					};
					// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
					jQuery.post(ajaxurl, data, function(response) {
						if(response.status == 'ok'){
							window.location.reload();
						}
					}, 'json');
				},
				updateCron: function ()
				{
					var data = {
						'action' 		: 'pspSyncUpdate'
					};
					// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
					jQuery.post(ajaxurl, data, function(response) {}, 'json');
				},
				fixLayoutHeight: function ()
				{
					var win 			= jQuery(window),
						pspWrapper 	= jQuery("#psp-wrapper"),
						minusHeight 	= 70,
						winHeight		= win.height();
					// show the freamwork wrapper and fix the height
					pspWrapper.css('min-height', parseInt(winHeight - minusHeight)).show();
					jQuery("div#psp-ajax-response").css('min-height', parseInt(winHeight - minusHeight - 240)).show();

					$("#wpbody-content").css('padding-bottom', '40px');
					$("#wpfooter").css('border', 'none');
				},
				activatePlugin: function ( $that )
				{
					var requestData = {
						'ipc'	: jQuery('#productKey').val(),
						'email'	: jQuery('#yourEmail').val()
					};
					if(requestData.ipc == ""){
						alert('Please type your Item Purchase Code!');
						return false;
					}
					$that.replaceWith('Validating your IPC <em>( ' + ( requestData.ipc) + ' )</em>  and activating plugin. Please be patient! (this action can take about <strong>10 seconds</strong>)');
					var data = {
						'action' 	: 'pspTryActivate',
						'ipc'		: requestData.ipc,
						'email'		: requestData.email
					};
					// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
					jQuery.post(ajaxurl, data, function(response) {
						if(response.status == 'OK') {
							window.location.reload();
						}
						else{
							alert(response.msg);
							return false;
						}
					}, 'json');
				},

				ajax_list: function()
				{

					var make_request = function( action, params, callback ){
						var loading = $("#psp-main-loading");
						loading.show();

						// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
						jQuery.post(ajaxurl, {
							'action' 		: 'pspAjaxList',
							'ajax_id'		: $(".psp-table-ajax-list").find('.psp-ajax-list-table-id').val(),
							'sub_action'	: action,
							'params'		: params
						}, function(response) {

							if( response.status == 'valid' )
							{
								$("#psp-table-ajax-response").html( response.html );
								
								//SERP module case!
								var ajax_id = $(".psp-table-ajax-list").find('.psp-ajax-list-table-id').val();
								if ( 'pspSERPKeywords' == ajax_id )
									pspSERP.wait_time();

								loading.fadeOut('fast');
							}
						}, 'json');
					}

					$(".psp-table-ajax-list").on('change', 'select[name=psp-post-per-page]', function(e){
						e.preventDefault();

						make_request( 'post_per_page', {
							'post_per_page' : $(this).val()
						} );
					})

					.on('click', 'a.psp-jump-page', function(e){
						e.preventDefault();

						make_request( 'paged', {
							'paged' : $(this).attr('href').replace('#paged=', '')
						} );
					})
					
					.on('change', 'select[name=psp-filter-post_type]', function(e){
						e.preventDefault();

						make_request( 'post_type', {
							'post_type' : $(this).val()
						} );
					})

					.on('click', '.psp-post_status-list a', function(e){
						e.preventDefault();

						make_request( 'post_status', {
							'post_status' : $(this).attr('href').replace('#post_status=', '')
						} );
					})
					
					.on('click', 'input[name=psp-search-btn]', function(e){
						e.preventDefault();

						make_request( 'search', {
							'search_text' : $(this).parent().find('#psp-search-text').val()
						} );
					});
				},
				
				googleAuthorizeApp: function()
				{
					$('body').on('click', ".psp-google-authorize-app", function(e){
						e.preventDefault();
						
						var form = $(this).parents('form').eq(0),
							client_id = form.find("#client_id").val(),
							client_secret = form.find("#client_secret").val();
						
						// Check if user has client ID and client secret key
						if( client_id == '' || client_secret == '' ){
							alert('Please add your Client ID / Secret for authorize your app.');
							return false;
						}
						
						jQuery.post(ajaxurl, {
							'action' 		: 'pspGoogleAuthorizeApp',
							'params'		: form.serialize()
						}, function(response) {
							if( response.status == 'valid' )
							{
								newwindow = window.open( response.auth_url ,'Google Authorize App','height=400,width=550' );
							}
						}, 'json');
						
					});
				},
				
				makeTabs: function() {
					$('ul.tabsHeader').each(function() {
						// For each set of tabs, we want to keep track of
						// which tab is active and it's associated content
						var $active, $content, $links = $(this).find('a');

						// If the location.hash matches one of the links, use that as the active tab.
						// If no match is found, use the first link as the initial active tab.
						var __currentTab = $(this).find('li#tabsCurrent').attr('title');
						$active = $( $links.filter('[title="'+__currentTab+'"]')[0] || $links[0] );
						$active.addClass('active');
						$content = $( '.'+($active.attr('title')) );

						// Hide the remaining content
						$links.not($active).each(function () {
							$( '.'+($(this).attr('title')) ).hide();
						});

						// Bind the click event handler
						$(this).on('click', 'a', function(e){
							// Make the old tab inactive.
							$active.removeClass('active');
							$content.hide();

							// Update the variables with the new link and content
							__currentTab = $(this).attr('title');
							$active = $(this);
							$content = $( '.'+($(this).attr('title')) );

							// Make the tab active.
							$active.addClass('active');
							$content.show();

							// Prevent the anchor's default click action
							e.preventDefault();
						});
					});
				},
				
				makeActiveMenu: function()
				{
					topMenu.find('.active').removeClass('active');
					
					// try to find the first child menu of current section
					var current_section = topMenu.find( '.psp-section-' + section );
					
					// is submenu item, loop parent
					if( current_section.parent('ul').hasClass('psp-sub-menu') ){
						current_section = current_section.parent('ul').parent('li');
					}
					if( current_section.size() > 0 ){
						current_section.addClass('active');
					}
				},
				
				triggers: function ()
				{
					plugin.googleAuthorizeApp();
					
					jQuery('a.aa-tooltip').tipsy({
						gravity: 'e'
					});

					jQuery(window).resize(function() {
						plugin.fixLayoutHeight();
					});
					jQuery('.psp_activate_product').live('click', function(e) {
						e.preventDefault();
						plugin.activatePlugin(jQuery(this));
					});
					jQuery('.psp-saveOptions').live('click', function(e) {
						e.preventDefault();
						plugin.saveOptions(jQuery(this));
					});
					jQuery('.psp-installDefaultOptions').live('click', function(e) {
						e.preventDefault();
						plugin.installDefaultOptions(jQuery(this));
					});
					jQuery('.psp-ImportSEO').live('click', function(e) {
						e.preventDefault();
						plugin.importSEOData(jQuery(this));
					});
					jQuery('#' + option.prefix + "-module-manager a").live('click', function(e) {
						e.preventDefault();
						plugin.moduleChangeStatus(jQuery(this));
					});

					jQuery('body').on('click', 'input#psp-item-check-all', function(){
						var that = $(this),
							checkboxes = $('#psp-list-table-posts input.psp-item-checkbox');

						if( that.is(':checked') ){
							checkboxes.prop('checked', true);
						}
						else{
							checkboxes.prop('checked', false);
						}
					});

					// Bind the event.
					jQuery(window).hashchange( function(){
						var subsection = '';
						
						// Alerts every time the hash changes!
						if(location.hash != ""){
							section = location.hash.replace("#!/", '');
							
							var __tmp = section.indexOf('#');
							if ( __tmp == -1 ) ;
							else { // found subsection block!
								subsection = section.substr( __tmp );
								section = section.slice( 0, __tmp );
							}
						}
						
						if ( subsection != '' )
							plugin.makeRequest([
								function (s) { plugin.scrollToElement( s ) },
								subsection
							]);
						else 
							plugin.makeRequest();
					})
					// Trigger the event (useful on page load).
					jQuery(window).hashchange();

					plugin.ajax_list();
                },
                
                scrollToElement: function (selector, time, verticalOffset) {
                	time = typeof(time) != 'undefined' ? time : 1000;
                	verticalOffset = typeof(verticalOffset) != 'undefined' ? verticalOffset : 0;

                	element = jQuery(selector);
                	if ( element.length <= 0 ) return false;

                	offset = element.offset();
                	offsetTop = offset.top + verticalOffset;
                	jQuery('html, body').animate({
                		scrollTop: offsetTop
                	}, time);
                }
            };
            plugin.init();
        });
    };
}(jQuery));

function pspPopUpClosed() {
    window.location.reload();
}