<?php
/*
* Define class pspW3C_HTMLValidator
* Make sure you skip down to the end of this file, as there are a few
* lines of code that are very important.
*/
!defined('ABSPATH') and exit;
if (class_exists('pspW3C_HTMLValidator') != true) {
    class pspW3C_HTMLValidator
    {
        /*
        * Some required plugin information
        */
        const VERSION = '1.0';

        /*
        * Store some helpers config
        */
        public $cfg = array();
        public $module = array();
        public $networks = array();
		public $the_plugin = null;

        /*
        * Required __construct() function that initalizes the AA-Team Framework
        */
        public function __construct($cfg, $module)
        {
        	global $psp;

        	$this->the_plugin = $psp;
            $this->cfg    = $cfg;
            $this->module = $module;
        }

		public function validateLink()
		{
			if( isset($_REQUEST['action']) ){
				$link = isset($_REQUEST['link']) ? $_REQUEST['link'] : '';
				$checkUrl = 'http://validator.w3.org/check?uri=' . $link;
				$browserRequest = wp_remote_get( $checkUrl );
				$status = array(
					'status' => isset($browserRequest['headers']["x-w3c-validator-status"]) ? $browserRequest['headers']["x-w3c-validator-status"] : '',
					'errors' => isset($browserRequest['headers']["x-w3c-validator-errors"]) ? $browserRequest['headers']["x-w3c-validator-errors"] : '',
					'warnings' => isset($browserRequest['headers']["x-w3c-validator-warnings"]) ? $browserRequest['headers']["x-w3c-validator-warnings"] : '',
					'recursion' => isset($browserRequest['headers']["x-w3c-validator-recursion"]) ? $browserRequest['headers']["x-w3c-validator-recursion"] : '',

				);

				if ( $status['status'] == "" && $status['recursion'] == "" ){
					die(json_encode(array(
						'status' => 'invalid',
						'msg'	 => $browserRequest['body']
					)));
				}


				// add page status to DB
				$post_id = isset($_REQUEST['ID']) ? (int)$_REQUEST['ID'] : 0;
				if( $post_id > 0 ){
					$status['time'] = date('Y-m-d H:i:s');

					update_post_meta($post_id, 'psp-w3c-status', $status);
				}

				die(json_encode(array(
					'status' => 'valid',
					'arr'	 => $status
				)));
			}

			// just die here
			die;
		}

		private function getWebsitePages()
		{
			global $wpdb;
		    $prefix = $wpdb->prefix;

			$pages = array();

		    // select all pages and post from DB
		    $myQuery = "SELECT ID, post_name, guid FROM " . $prefix . "posts WHERE post_status='publish' ";
		    $query = mysql_query($myQuery);
		    while ($myrow = mysql_fetch_array($query)) {
				$pages[$myrow['ID']] = array(
					'id' => $myrow['ID'],
					'title' => $myrow['post_name'],
					'link' => get_permalink($myrow['ID'])
				);
		    }

			return $pages;
		}

        public function printSearchInterface()
        {
?>
<style>#psp-html-validation {display: none;}</style>
<link rel='stylesheet' href='<?php echo $this->module['folder_uri'];?>app.css?<?php echo time();?>' type='text/css' media='all' />
<script type="text/javascript" src="<?php echo $this->module['folder_uri'];?>app.class.js" ></script>

<div id="psp-html-validation">
	<!-- Main loading box -->
	<div id="main-loading">
		<div id="loading-overlay"></div>
		<div id="loading-box">
			<div class="loading-text"><?php _e('Loading', $this->the_plugin->localizationName); ?></div>
			<div class="meter animate" style="width:86%; margin: 34px 0px 0px 7%;"><span style="width:100%"></span></div>
		</div>
	</div>

	<div class="psp-checklist">
        <?php
       	$pages = $this->getWebsitePages();
		if( count($pages) > 0 ){
        ?>

    		<table width="100%" style="margin-bottom: 10px;">
    			<tr>
    				<td width="85"><?php _e('Current status:', $this->the_plugin->localizationName); ?></td>
    				<td id="status-block">
						<?php _e('Unchecked', $this->the_plugin->localizationName); ?>(<span class="totalorange"><?php echo (int) count($pages);?></span>)  &nbsp;  |  &nbsp;
						<?php _e('Valid', $this->the_plugin->localizationName); ?>(<span class="totalgreen">0</span>) &nbsp; | &nbsp;
						<?php _e('Invalid', $this->the_plugin->localizationName); ?>(<span class="totalred">0</span>)
					</td>
    				<td width="140" align="right"><a href="#all" class="psp-button blue" id="psp-check-all-pages"><?php _e('Check all pages', $this->the_plugin->localizationName); ?></a></td>
    			</tr>
    		</table>
	        <table class="psp-table">
	        	<thead>
	                <th width="12">ID</th>
	                <th align="left"><?php _e('Url', $this->the_plugin->localizationName); ?></th>
	                <th width="70"><?php _e('Status', $this->the_plugin->localizationName); ?></th>
	                <th width="80"><?php _e('# of Errors:', $this->the_plugin->localizationName); ?></th>
	                <th width="80"><?php _e('# of Warning:', $this->the_plugin->localizationName); ?></th>
	                <th width="120"><?php _e('Last check at:', $this->the_plugin->localizationName); ?></th>
	                <th width="90"><?php _e('Action', $this->the_plugin->localizationName); ?></th>
	            </thead>
	            <tbody>
	            	<?php
	            	$default_status = array(
						'uncheck' 	=> 0,
						'valid'		=> 0,
						'error'		=> 0
					);
					foreach ( $pages as $page ) {

						// get current status
						$status = get_post_meta($page['id'], 'psp-w3c-status', true);

						echo '<tr id="psp-row-' . ( $page['id'] ) . '">';
						echo 	'<td align="center">' . ( $page['id'] ) . '</td>';
						echo 	'<td>';
		  				echo 		'<a class="page-link" href="' . $page['link'] . '">' . ( ucfirst($page['title']) ) . '</a>';
						echo 	'</td>';

						if( isset($status) && count($status) > 0 ){
							$_status = '&ndash;';
							if( $status['status'] == 'Invalid' ){
								$default_status['error']++;
								$_status = '<span class="status_block error">' . __('Invalid', $this->the_plugin->localizationName) . '</span>';
							}elseif( $status['status'] == 'Valid' ){
								$default_status['valid']++;
								$_status = '<span class="status_block success">' . __('Valid', $this->the_plugin->localizationName) . '</span>';
							}else{
								$default_status['uncheck']++;
							}

							$_errors = '&ndash;';
							if( $status['errors'] > 0 ){
								$_errors = '<span class="status_block error"><a target="_blank" href="http://validator.w3.org/check?uri=' . ( $page['link'] ) . '">' . ( $status['errors'] ) . __(' - details', $this->the_plugin->localizationName) . '</a></span>';
							}

							$_warnings = '&ndash;';
							if( $status['warnings'] > 0 ){
								$_warnings = '<span class="status_block warning"><a target="_blank" href="http://validator.w3.org/check?uri=' . ( $page['link'] ) . '">' . ( $status['warnings'] ) . __(' - details', $this->the_plugin->localizationName) . '</a></span>';
							}

							$_check = '_';
							if( isset($status['time']) && $status['time'] != "" ){
								$_check = $status['time'];
							}

							echo 	'<td align="center">' . ( $_status ) . '</td>';
							echo 	'<td align="center">' . ( $_errors ) . '</td>';
							echo 	'<td align="center">' . ( $_warnings ) . '</td>';
							echo 	'<td align="center">' . ( $_check ) . '</td>';
						}
						echo 	'<td align="center"><a href="#' . ( $page['id'] ) . '" class="psp-button gray small psp-recheck-btn">' . __('Recheck', $this->the_plugin->localizationName) . '</a></td>';
						echo '</tr>';
		  			}
					?>
	            </tbody>
	        </table>
	        <script>
	        	jQuery("#status-block").each(function(){
	        		var that = jQuery(this);

	        		that.find('.totalorange').text('<?php echo $default_status['uncheck'];?>');
	        		that.find('.totalgreen').text('<?php echo $default_status['valid'];?>');
	        		that.find('.totalred').text('<?php echo $default_status['error'];?>');
	        	})
	        </script>
        <?php } ?>


    </div>

</div>
<?php
        }
    }
}
// Initalize the your pspW3C_HTMLValidator
$pspW3C_HTMLValidator = new pspW3C_HTMLValidator($this->cfg, $module);