<?php

if ( !function_exists( 'optionsframework_init' ) ) {
	define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/theme_options/' );
	require_once dirname( __FILE__ ) . '/theme_options/options-framework.php';
}

$tempdir = get_template_directory();
if (of_get_option('pagination_on') == '1') require_once($tempdir .'/inc/functions/pagination.php');
require_once($tempdir .'/inc/functions/shortcodes.php'); 
require_once($tempdir .'/inc/functions/meta_box.php');

/*------------------------------------------------------------------------------*/
/*	Загрузка скриптов (Страница записи)
/*------------------------------------------------------------------------------*/

function lt_single_scripts(){
	if ( is_single() ){	
		wp_enqueue_script('pretty_photo', get_template_directory_uri() . '/js/pretty_photo/jquery.prettyPhoto.js', array('jquery'), '1.0');
		wp_enqueue_script('jplayer', get_template_directory_uri() . '/js/jquery.jplayer.min.js', array('jquery'), '1.0');
	}
}
add_action( 'wp_enqueue_scripts', 'lt_single_scripts' );

/*------------------------------------------------------------------------------*/
/*	Загрузка скриптов (Глобальные)
/*------------------------------------------------------------------------------*/

function lt_load_scripts(){
	if ( !is_admin() ){			
		wp_enqueue_script('jquery_tools', get_template_directory_uri() . '/js/jquery.tools.min.js', array('jquery'), '1.0');
		wp_enqueue_script('accordion-menu', get_template_directory_uri() . '/js/accordion.menu.js', array('jquery'), '1.0');
		wp_enqueue_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array('jquery'), '1.0');
		wp_enqueue_script('script_global', get_template_directory_uri() . '/js/script.js', array('jquery'), '1.0');
	}
}
add_action( 'wp_enqueue_scripts', 'lt_load_scripts' );

/*------------------------------------------------------------------------------*/
/*	Загрузка скриптов (Административная панель)
/*------------------------------------------------------------------------------*/

function lt_admin_js($hook) {
	if ($hook == 'post.php' || $hook == 'post-new.php') {
		wp_register_script('lt-admin', get_template_directory_uri() . '/js/jquery.script.admin.js', 'jquery');
		wp_enqueue_script('lt-admin');
	}
}
add_action('admin_enqueue_scripts','lt_admin_js',10,1);

/*------------------------------------------------------------------------------*/
/*	Загрузка стилей (Страница записи)
/*------------------------------------------------------------------------------*/

function lt_styles() {
	    if ( is_singular() ){
		wp_register_style( 'pretty_photo_style', get_template_directory_uri() . '/js/pretty_photo/prettyPhoto.css' , '', '1.0', 'all');
		wp_enqueue_style( 'pretty_photo_style' );
    }		
}
add_action('wp_print_styles', 'lt_styles');

/*------------------------------------------------------------------------------*/
/*	Виджеты
/*------------------------------------------------------------------------------*/

add_action("widgets_init", "load_lt_widgets");
function load_lt_widgets() {
    register_widget("InfoNews_recent_pop_rand_post");
	register_widget("InfoNews_list_categories");
	register_widget("InfoNews_list_tags");
	register_widget("InfoNews_list_authors");
	register_widget("InfoNews_text_block");
	register_widget("InfoNews_slider_post");
}

$incdirwg = get_template_directory() . '/inc/widgets/';
require_once($incdirwg .'post-news.php');
require_once($incdirwg .'list-categories-news.php');
require_once($incdirwg .'list-tags-news.php');
require_once($incdirwg .'list-authors-news.php');
require_once($incdirwg .'text-block-news.php');
require_once($incdirwg .'slider-post-news.php');

/*------------------------------------------------------------------------------*/
/*	Использование шорткода в виджете
/*------------------------------------------------------------------------------*/

add_filter('widget_text', 'do_shortcode');

/*------------------------------------------------------------------------------*/
/*	Убираем версию Wordpress
/*------------------------------------------------------------------------------*/

remove_action('wp_head', 'wp_generator' );

/*------------------------------------------------------------------------------*/
/*	Убираем rel c ссылок категорий в записях
/*------------------------------------------------------------------------------*/

add_filter( 'the_category', 'add_nofollow_cat' ); 
function add_nofollow_cat( $text ) {
$text = str_replace('rel="category tag"', "", $text); return $text;
}

/*------------------------------------------------------------------------------*/
/*	Убираем атрибут title c ссылок категорий в записях
/*------------------------------------------------------------------------------*/

function the_category_remove_title($output) {
    $output = preg_replace('/title=\"(.*?)\"/','', $output);
    return $output;
}
add_filter('the_category', 'the_category_remove_title');

/*------------------------------------------------------------------------------*/
/*	Убираем атрибут title (список категорий)
/*------------------------------------------------------------------------------*/

function wp_list_categories_remove_title($output) {
    $output = preg_replace('` title="(.+)"`', '', $output);
    return $output;
}
add_filter('wp_list_categories', 'wp_list_categories_remove_title');

/*------------------------------------------------------------------------------*/
/*	Включение поддержки миниатюр
/*------------------------------------------------------------------------------*/

if ( function_exists( 'add_theme_support' ) ) { 
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'category-thumbnail', 153, 120, true );
	add_image_size( 'image-small-thumbnail', 625, 120, true );
	add_image_size( 'image-large-thumbnail', 670, '', true );
	add_image_size( 'post-widget-thumbnail', 104, 104, true );
	add_image_size( 'slider-thumbnail', 390, 300, true );
}

/*------------------------------------------------------------------------------*/
/*	Произвольное меню
/*------------------------------------------------------------------------------*/

register_nav_menus(array(
	'top' => 'Top'
));

/*------------------------------------------------------------------------------*/
/*	Форматы записей
/*------------------------------------------------------------------------------*/

add_theme_support( 'post-formats', array( 'gallery', 'image', 'video', 'link' ) );

/*------------------------------------------------------------------------------*/
/*	Сокращение слов в записи
/*------------------------------------------------------------------------------*/

function excerpt($num) {
    $limit = $num+1;
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt)."...";
    echo $excerpt;
}

/*------------------------------------------------------------------------------*/
/*	Комментарии
/*------------------------------------------------------------------------------*/

function lt_list_pings($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment; ?>
    <li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php }

function lt_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
	  <div id="comment-<?php comment_ID(); ?>" class="comment">
	  <?php echo get_avatar($comment,$size='60'); ?>
		<div class="comment-author vcard">
		  <?php printf(__('<span class="fn">%s</span>'), get_comment_author_link()) ?>
		</div>
		<div class="comment-meta">
		  <?php printf(__('%1$s в %2$s &ndash; '), get_comment_date(),  get_comment_time()) ?>
		  <?php comment_reply_link( array_merge( $args, array( 'reply_text' => 'Ответить', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
          <?php edit_comment_link(__('(Edit)'),' &ndash; ','') ?>
		</div>
		<?php if ( $comment->comment_approved == '0' ) : ?>
		  <p class="comment-awaiting-moderation">Ваш комментарий ожидает модерации.</p>
		<?php endif; ?>
		<div class="comment-content">
		  <?php comment_text(); ?>
		</div>
	  </div>

<?php }

/*------------------------------------------------------------------------------*/
/*	Блоки для виджетов
/*------------------------------------------------------------------------------*/

if ( function_exists('register_sidebar') )	

	register_sidebar(array(
        'name' => 'Top Banner',
        'before_widget' => '<div class="top-banner">',
        'after_widget' => '</div>',
        'before_title' => '<div class="top-banner-title">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Sidebar Home',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));	
	if ( function_exists('register_sidebar') )
        register_sidebar(array(
        'name' => 'Left Sidebar Home',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));
       if ( function_exists('register_sidebar') )
        register_sidebar(array(
        'name' => 'Left Sidebar Category',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));
      if ( function_exists('register_sidebar') )
        register_sidebar(array(
        'name' => 'Sidebar Category',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));

	register_sidebar(array(
        'name' => 'Top Home',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Left Content Home',
        'before_widget' => '<div class="con-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Right Content Home',
        'before_widget' => '<div class="con-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Bottom Home',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Sidebar',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));	
if ( function_exists('register_sidebar') )
        register_sidebar(array(
        'name' => 'Left Sidebar',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    )); 
	  
	register_sidebar(array(
        'name' => 'Top',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Bottom',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Top Entry',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Bottom Entry',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Sidebar Page',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));	
if ( function_exists('register_sidebar') )
        register_sidebar(array(
        'name' => 'Left Sidebar Page',
        'before_widget' => '<div class="sidebar-block">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-block-title">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Top Page',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Bottom Page',
        'before_widget' => '<div class="block">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="block-title">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Bottom Left',
        'before_widget' => '<div class="bottom-left">',
        'after_widget' => '</div>',
        'before_title' => '<div class="bottom-title"><span></span>',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Bottom Center',
        'before_widget' => '<div class="bottom-center">',
        'after_widget' => '</div>',
        'before_title' => '<div class="bottom-title"><span></span>',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Bottom Right',
        'before_widget' => '<div class="bottom-right">',
        'after_widget' => '</div>',
        'before_title' => '<div class="bottom-title"><span></span>',
        'after_title' => '</div>',
    ));
           if ( function_exists('register_sidebar') )
        register_sidebar(array(
        'name' => 'Right Bottom Right',
        'before_widget' => '<div class="right-bottom-right">',
        'after_widget' => '',
        'before_title' => '<div class="bottom-title"><span></span>',
        'after_title' => '</div>',
    )); 
	register_sidebar(array(
        'name' => 'Footer',
        'before_widget' => '<div class="footer-body">',
        'after_widget' => '</div>',
        'before_title' => '<div class="footer-title">',
        'after_title' => '</div>',
    ));
             

//Php в виджете
add_filter('widget_text','sp_widget_execute_php',100);
 function sp_widget_execute_php($text) {
     if(strpos($text,'<?') !== false) {
         ob_start();
         eval('?>'.$text);
         $text = ob_get_contents();
         ob_end_clean();
     }
     return $text;
 }
add_filter('pre_site_transient_update_core',create_function('$a', "return null;"));
wp_clear_scheduled_hook('wp_version_check');

remove_action( 'load-update-core.php', 'wp_update_plugins' );
add_filter( 'pre_site_transient_update_plugins', create_function( '$a', "return null;" ) );
wp_clear_scheduled_hook( 'wp_update_plugins' );

remove_action('load-update-core.php','wp_update_themes');
add_filter('pre_site_transient_update_themes',create_function('$a', "return null;"));
wp_clear_scheduled_hook('wp_update_themes');

?>