<?php

/* -------------------- Metabox fields -------------------- */

$prefix = 'lt_';   

$meta_box_video = array(
	'id' => 'lt-meta-box-video',
	'title' =>  __('Видео', 'ltlang'),
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
				'desc' => __('Высота видео (по умолчанию 380)','ltlang'),
				'id' => $prefix.'height_video',
				'type' => 'text'
		),
		array(
				'desc' => __('Ссылка на скриншот видео (ширина 670px, высота не менее высоты видео)','ltlang'),
				'id' => $prefix.'poster_video',
				'type' => 'text'
		),
		array(
				'desc' => __('Ссылка на файл MP4 (.mp4, .m4v)','ltlang'),
				'id' => $prefix.'link_video_m4v',
				'type' => 'text'
			),
		array(
				'desc' => __('Ссылка на файл FLV (.flv)','ltlang'),
				'id' => $prefix.'link_video_flv',
				'type' => 'text'
			),
		array(
				'desc' => __('Ссылка на файл OGV (.ogv)','ltlang'),
				'id' => $prefix.'link_video_ogv',
				'type' => 'text'
			),
		array(
				'desc' => __('Ссылка на файл WebM (.webm)','ltlang'),
				'id' => $prefix.'link_video_webm',
				'type' => 'text'
			),
		array(
				'desc' => __('Код видео Youtube, Vimeo, ВКонтакте','ltlang'),
				'id' => $prefix.'code_video',
				'type' => 'textarea'
			),
	),
); 

$meta_box_link = array(
	'id' => 'lt-meta-box-link',
	'title' =>  __('Ссылка', 'ltlang'),
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array( 
				"desc" => __('Ссылка на веб-страницу','ltlang'),
				"id" => $prefix."link_url",
				"type" => "text"
			),
	),
	
);

add_action('admin_menu', 'lt_add_meta_box');

function lt_add_meta_box() {
	global $meta_box_video, $meta_box_link;

	add_meta_box($meta_box_video['id'], $meta_box_video['title'], 'lt_show_box_video', $meta_box_video['page'], $meta_box_video['context'], $meta_box_video['priority']);
	add_meta_box($meta_box_link['id'], $meta_box_link['title'], 'lt_show_box_link', $meta_box_link['page'], $meta_box_link['context'], $meta_box_link['priority']);

}

/* -------------------- The Callback -------------------- */

function lt_show_box_video() {  
global $meta_box_video, $post;  
 
echo '<input type="hidden" name="lt_meta_box_nonce" value="'.wp_create_nonce(basename(__FILE__)).'" />';  

    echo '<table class="form-table">';  
	
    foreach ($meta_box_video['fields'] as $field) {  
        $meta = get_post_meta($post->ID, $field['id'], true);  
       
         switch($field['type']) {
		 
         case 'textarea':
		      echo '<tr><td>', '<span class="description">', $field['desc'], '</span><br />';
	          echo '<textarea  name="', $field['id'], '" id="', $field['id'], '" cols="40" rows="2" style="width:100%;padding:4px;">', $meta ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '</textarea>';
			  echo '</td></tr>';
         break; 
		 
         case 'text':
		      echo '<tr><td>', '<span class="description">', $field['desc'], '</span><br />';
	          echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '" size="30" style="width:80%;" />';
			  echo '</td></tr>';
         break;  
		 
                }  
    }  
    echo '</table>'; 
} 

function lt_show_box_link() {  
global $meta_box_link, $post;  
 
echo '<input type="hidden" name="lt_meta_box_nonce" value="'.wp_create_nonce(basename(__FILE__)).'" />';  

    echo '<table class="form-table">';  
	
    foreach ($meta_box_link['fields'] as $field) {  
        $meta = get_post_meta($post->ID, $field['id'], true);  
       
         switch($field['type']) {
		 
         case 'text':
		      echo '<tr><td>', '<span class="description">', $field['desc'], '</span><br />';
	          echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '" size="30" style="width:80%;" />';
			  echo '</td></tr>';
         break;  
                }  
    }  
    echo '</table>'; 
}

/* -------------------- Save the Data -------------------- */

function lt_save_meta($post_id) {
    global $meta_box_video, $meta_box_link;

	// verify nonce
	if (!wp_verify_nonce($_POST['lt_meta_box_nonce'], basename(__FILE__)))
		return $post_id;
	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return $post_id;
	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id))
			return $post_id;
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
	}

	// Metabox video
	foreach ($meta_box_video['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], stripslashes(htmlspecialchars($new)));
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	} 	
	
	// Metabox link
	foreach ($meta_box_link['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], stripslashes(htmlspecialchars($new)));
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	} 
}

add_action('save_post', 'lt_save_meta');

?>