<?php
/*
 * Plugin Name: List Authors Widget
 * Plugin URI: http://ferens.ru/
 * Description: Вывод списка авторов сайта
 * Version: 1.0
 * Author: ferens.ru
 * Author URI: http://ferens.ru/
 */

class LT_list_authors extends WP_Widget {

    function LT_list_authors() {
	$widget_ops = array( 'classname' => 'lt_list_authors', 'description' => __('Вывод списка авторов сайта', 'ltlang') );
    $this->WP_Widget( 'lt_list_authors', __('Авторы LT', 'ltlang'), $widget_ops );
    }

    function widget($args, $instance) {		
        global $wpdb;
		extract( $args );
                $title = apply_filters('widget_title', $instance['title'] );
			    $sortby = empty( $instance['sortby'] ) ? 'post_count' : $instance['sortby'];
				$order = empty( $instance['order'] ) ? 'DESC' : $instance['order'];
				$c = ! empty( $instance['count'] ) ? '1' : '0';
				$number = $instance['number'];

             echo $before_widget;
             ?>	

  <div class="wg-list-authors">
    <?php if (($title)!=""){ ?>
      <div class="title-list-authors-wg">
        <?php echo $title; ?>
      </div>
    <?php }?>
    <ul>
    <?php $variable = wp_list_authors ( array(
	   'echo' => '0',
	   'orderby' => $sortby, 
       'order' => $order,
	   'optioncount' => $c,
	   'number' => $number,
	   'exclude_admin' => true
	   )
       ); 
      $variable = ereg_replace('</a> \(([0-9]+)\)', '<span class="author-c">\\1</span></a>', $variable);
      echo $variable;
    ?>
    </ul>
    <?php wp_reset_query(); ?>
  <div class="clear"></div> 
  </div>
  
    <?php 
		echo $after_widget;
    }

    //Widget Update
    function update($new_instance, $old_instance) {				
        $instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		if ( in_array( $new_instance['sortby'], array( 'post_count', 'name', 'e-mail', 'url', 'registered', 'id', 'user_login'  ) ) ) {
			$instance['sortby'] = $new_instance['sortby'];
		} else {
			$instance['sortby'] = 'post_count';
		}
		
		if ( in_array( $new_instance['order'], array( 'ASC', 'DESC' ) ) ) {
			$instance['order'] = $new_instance['order'];
		} else {
			$instance['order'] = 'DESC';
		}

		$instance['count'] = !empty($new_instance['count']) ? 1 : 0;
		$instance['number'] = strip_tags( $new_instance['number'] );
		return $instance;
    }
	

    function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'sortby' => 'post_count', 'order' => 'DESC', 'title' => '', 'number' => '10' ) );
		$title = esc_attr( $instance['title'] );
		$count = isset($instance['count']) ? (bool) $instance['count'] :false;
		$hierarchical = isset( $instance['hierarchical'] ) ? (bool) $instance['hierarchical'] : false;
 ?>
		
<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:') ?></label>
<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('sortby'); ?>">Сортировка:</label>
<select name="<?php echo $this->get_field_name('sortby'); ?>" id="<?php echo $this->get_field_id('sortby'); ?>" class="widefat">
    <option value="post_count"<?php selected( $instance['sortby'], 'post_count' ); ?>>Количество записей</option>
	<option value="name"<?php selected( $instance['sortby'], 'name' ); ?>>Имя</option>
	<option value="e-mail"<?php selected( $instance['sortby'], 'e-mail' ); ?>>E-mail</option>
	<option value="url"<?php selected( $instance['sortby'], 'url' ); ?>>URL</option>
	<option value="registered"<?php selected( $instance['sortby'], 'registered' ); ?>>Дата регистрации</option>
	<option value="id"<?php selected( $instance['sortby'], 'id' ); ?>>ID</option>
	<option value="user_login"<?php selected( $instance['sortby'], 'user_login' ); ?>>Логин</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('order'); ?>">Порядок сортировки:</label>
<select name="<?php echo $this->get_field_name('order'); ?>" id="<?php echo $this->get_field_id('order'); ?>" class="widefat">
	<option value="ASC"<?php selected( $instance['order'], 'ASC' ); ?>>Возрастание</option>
	<option value="DESC"<?php selected( $instance['order'], 'DESC' ); ?>>Убывание</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('number'); ?>">Количество авторов</label><br />
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" value="<?php echo $instance['number']; ?>" />
</p>

<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>"<?php checked( $count ); ?> />
<label for="<?php echo $this->get_field_id('count'); ?>">Отображать число записей</label><br />


  <?php 
    }

}
?>