<?php
/*
 * Plugin Name: List Categories Widget
 * Plugin URI: http://ferens.ru/
 * Description: Список категорий LT
 * Version: 1.0
 * Author: ferens.ru
 * Author URI: http://ferens.ru/
 */

class LT_list_categories extends WP_Widget {

    function LT_list_categories() {
	$widget_ops = array( 'classname' => 'lt_list_categories', 'description' => __('Список категорий', 'ltlang') );
    $this->WP_Widget( 'lt_list_categories', __('Категории LT', 'ltlang'), $widget_ops );
    }

    function widget($args, $instance) {		
        global $wpdb;
		extract( $args );
                $title = apply_filters('widget_title', $instance['title'] );
				$sortby = empty( $instance['sortby'] ) ? 'ID' : $instance['sortby'];
				$order = empty( $instance['order'] ) ? 'ASC' : $instance['order'];
		        $exclude = empty( $instance['exclude'] ) ? '' : $instance['exclude'];			
				$c = ! empty( $instance['count'] ) ? '1' : '0';
		        $h = ! empty( $instance['hierarchical'] ) ? '1' : '0';
				
             echo $before_widget;
             ?>	
				
				<div class="wg-categories">
				  <?php if (($title)!=""){ ?>
				    <div class="title-category-wg">
					  <?php echo $title; ?>
					</div>
				  <?php }?>
				  <ul>
					<?php
					$variable = wp_list_categories( 'echo=0&order=' . $order . '&orderby=' . $sortby . '&title_li=&show_count=' . $c . '&hierarchical=' . $h . '&exclude=' . $exclude ); 
					$variable = ereg_replace('</a> \(([0-9]+)\)', '<span class="cat-c">\\1</span></a>', $variable);
                    echo $variable;
					?> 
				  </ul>
                  <?php wp_reset_query(); ?>
				<div class="clear"></div>
				</div>
					
		<?php 
		echo $after_widget;
    }

    //Widget Update
    function update($new_instance, $old_instance) {				
        $instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		if ( in_array( $new_instance['sortby'], array( 'ID', 'name', 'count' ) ) ) {
			$instance['sortby'] = $new_instance['sortby'];
		} else {
			$instance['sortby'] = 'ID';
		}
		
		if ( in_array( $new_instance['order'], array( 'ASC', 'DESC' ) ) ) {
			$instance['order'] = $new_instance['order'];
		} else {
			$instance['order'] = 'ASC';
		}

		$instance['exclude'] = strip_tags( $new_instance['exclude'] );
		$instance['count'] = !empty($new_instance['count']) ? 1 : 0;
		$instance['hierarchical'] = !empty($new_instance['hierarchical']) ? 1 : 0;
		return $instance;
    }

  function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'sortby' => 'ID', 'order' => 'ASC', 'title' => '', 'exclude' => '' ) );
		$title = esc_attr( $instance['title'] );
		$count = isset($instance['count']) ? (bool) $instance['count'] :false;
		$hierarchical = isset( $instance['hierarchical'] ) ? (bool) $instance['hierarchical'] : false;
 ?>
		
<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:') ?></label>
<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('sortby'); ?>">Сортировка:</label>
<select name="<?php echo $this->get_field_name('sortby'); ?>" id="<?php echo $this->get_field_id('sortby'); ?>" class="widefat">
	<option value="ID"<?php selected( $instance['sortby'], 'ID' ); ?>>ID</option>
	<option value="name"<?php selected( $instance['sortby'], 'name' ); ?>>Имя</option>
	<option value="count"<?php selected( $instance['sortby'], 'count' ); ?>>Количество записей</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('order'); ?>">Порядок сортировки:</label>
<select name="<?php echo $this->get_field_name('order'); ?>" id="<?php echo $this->get_field_id('order'); ?>" class="widefat">
	<option value="ASC"<?php selected( $instance['order'], 'ASC' ); ?>>Возрастание</option>
	<option value="DESC"<?php selected( $instance['order'], 'DESC' ); ?>>Убывание</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('exclude'); ?>">Исключить:</label> 
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('exclude'); ?>" name="<?php echo $this->get_field_name('exclude'); ?>" value="<?php echo $instance['exclude']; ?>" />
<br />
<small>ID категорий, разделённые запятыми</small>
</p>

<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>"<?php checked( $count ); ?> />
<label for="<?php echo $this->get_field_id('count'); ?>">Отображать число записей</label><br />

<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('hierarchical'); ?>" name="<?php echo $this->get_field_name('hierarchical'); ?>"<?php checked( $hierarchical ); ?> />
<label for="<?php echo $this->get_field_id('hierarchical'); ?>">Отображать иерархию</label></p>

	<?php 
    }

}
?>