<?php
/*
 * Plugin Name: Tags Widget
 * Plugin URI: http://ferens.ru/
 * Description: Облако тегов
 * Version: 1.0
 * Author: ferens.ru
 * Author URI: http://ferens.ru/
 */

class InfoNews_list_tags extends WP_Widget {

    function InfoNews_list_tags() {
	$widget_ops = array( 'classname' => 'lt_list_tags', 'description' => __('Облако тегов', 'ltlang') );
    $this->WP_Widget( 'lt_list_tags', __('Теги InfoNews', 'ltlang'), $widget_ops );
    }

    function widget($args, $instance) {		
        global $wpdb;
		extract( $args );
                $title = apply_filters('widget_title', $instance['title'] );
				$sortby = empty( $instance['sortby'] ) ? 'count' : $instance['sortby'];
				$order = empty( $instance['order'] ) ? 'DESC' : $instance['order'];
				$exclude = empty( $instance['exclude'] ) ? '' : $instance['exclude'];
				
             echo $before_widget;
             ?>	
				
				<div class="wg-tags">
				  <?php if (($title)!=""){ ?>
				    <div class="title-tag-wg">
					  <?php echo $title; ?>
					</div>
				  <?php }?>
				  <div class="wg-tags-con">
				    <?php wp_tag_cloud('largest=13&smallest=13&unit=px&exclude=' . $exclude . '&order=' . $order . '&orderby=' . $sortby ); ?>
                    <?php wp_reset_query(); ?>
				  <div class="clear"></div>
				  </div> 
				</div>   

		<?php 
		echo $after_widget;
    }

    /* WP_Widget Update */
      function update($new_instance, $old_instance) {				
        $instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		if ( in_array( $new_instance['sortby'], array( 'count', 'name' ) ) ) {
			$instance['sortby'] = $new_instance['sortby'];
		} else {
			$instance['sortby'] = 'count';
		}
		
		if ( in_array( $new_instance['order'], array( 'DESC', 'ASC', 'RAND' ) ) ) {
			$instance['order'] = $new_instance['order'];
		} else {
			$instance['order'] = 'DESC';
		}
		
		$instance['exclude'] = strip_tags( $new_instance['exclude'] );
		return $instance;
    }

 function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'sortby' => 'count', 'order' => 'DESC', 'title' => '', 'exclude' => '' ) );
		$title = esc_attr( $instance['title'] );
 ?>
		
<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:') ?></label>
<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('sortby'); ?>">Сортировка:</label>
<select name="<?php echo $this->get_field_name('sortby'); ?>" id="<?php echo $this->get_field_id('sortby'); ?>" class="widefat">
    <option value="count"<?php selected( $instance['sortby'], 'count' ); ?>>Количество записей</option>
	<option value="name"<?php selected( $instance['sortby'], 'name' ); ?>>Имя</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('order'); ?>">Порядок сортировки:</label>
<select name="<?php echo $this->get_field_name('order'); ?>" id="<?php echo $this->get_field_id('order'); ?>" class="widefat">
    <option value="DESC"<?php selected( $instance['order'], 'DESC' ); ?>>Убывание</option>
	<option value="ASC"<?php selected( $instance['order'], 'ASC' ); ?>>Возрастание</option>
	<option value="RAND"<?php selected( $instance['order'], 'RAND' ); ?>>В случайном порядке</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('exclude'); ?>">Исключить:</label> 
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('exclude'); ?>" name="<?php echo $this->get_field_name('exclude'); ?>" value="<?php echo $instance['exclude']; ?>" />
<br />
<small>ID меток, разделённые запятыми</small>
</p>

	<?php 
    }

}
?>