<?php
/*
* Define class aaInterfaceTemplates
* Make sure you skip down to the end of this file, as there are a few
* lines of code that are very important.
*/
! defined( 'ABSPATH' ) and exit;

if(class_exists('aaInterfaceTemplates') != true) {

	class aaInterfaceTemplates {

		/*
		* Some required plugin information
		*/
		const VERSION = '1.0';

		/*
		* Store some helpers config
		*
		*/
		public $cfg	= array();

		/*
		* Required __construct() function that initalizes the AA-Team Framework
		*/
		public function __construct($cfg)
		{
			global $psp;
			$this->cfg = $cfg;
		}


		/*
		* bildThePage, method
		* -------------------
		*
		* @params $options = array (requiered)
		* @params $alias = string (requiered)
		* this will create you interface via options array elements
		*/
		public function bildThePage ( $options = array(), $alias='', $module=array(), $showForm=true )
		{
			global $psp;

			// reset as array, this will stock all the html content, and at the end return it
			$html = array();

			if(count($options) == 0) {
				return __('Please fill whit some options content first!', $psp->localizationName);
			}

			$noRowElements = array('message', 'html', 'app');

			foreach ( $options as $theBoxs ) {

				// loop the all the boxs
				foreach ( $theBoxs as $box_id => $box ){

					$box_id = $alias . "_" . $box_id;
					$settings = array();

					// get the values from DB
					$dbValues = get_option($box_id);

					// check if isset and string have content
					if(isset($dbValues) && @trim($dbValues) != ""){
						$settings = maybe_unserialize($dbValues);
					}

					// create defalt setup for each header, prevent php notices
					if(!isset($box['header'])) $box['header']= false;
					if(!isset($box['toggler'])) $box['toggler']= false;
					if(!isset($box['buttons'])) $box['buttons']= false;
					if(!isset($box['style'])) $box['style']= 'panel';

					// container setup
					$html[] = '<div class="psp-' . ( $box['size'] ) . '">
                        	<div class="psp-' . ( $box['style'] ) . '">';

					// hide panel header only if it's requested
					if( $box['header'] == true ) {
						$html[] = '<div class="psp-panel-header">
							<span class="psp-panel-title">
								' . ( isset($box['icon']) ? '<img src="' . ( $box['icon'] ) . '" />' : '' ) . '
								' . ( $box['title'] ) . '
							</span>
							 ' . ( $box['toggler'] == true ? '<span class="psp-panel-toggler"></span>' : '' ) . '
						</div>';
					}

					$html[] = '<div class="psp-panel-content">';
					if($showForm){
						$html[] = '<form class="psp-form" id="' . ( $box_id ) . '" action="#save_with_ajax">';
					}

					// create a hidden input for sending the prefix
					$html[] = '<input type="hidden" id="box_id" name="box_id" value="' . ( $box_id ) . '" />';

					$html[] = '<input type="hidden" id="box_nonce" name="box_nonce" value="' . ( wp_create_nonce( $box_id . '-nonce') ) . '" />';
					
					$html[] = $this->tabsHeader($box); // tabs html header
					
					// loop the box elements
					if(count($box['elements']) > 0){

						// loop the box elements now
						foreach ( $box['elements'] as $elm_id => $value ){

							// some helpers. Reset an each loop, prevent collision
							$val = '';
							$select_value = '';
							$checked = '';
							$option_name = isset($option_name) ? $option_name : '';

							// Set default value to $val 
							if ( isset( $value['std']) ) {
								$val = $value['std'];
							}

							// If the option is already saved, ovveride $val
							if ( ( $value['type'] != 'info' ) ) {
								
								if ( isset($settings[($elm_id)] ) && trim($settings[($elm_id)]) != "" ) {
										$val = $settings[( $elm_id )];

										// Striping slashes of non-array options
										if ( !is_array($val) ) {
											$val = stripslashes( $val );
											//if($val == '') $val = true;
										}
								}
							}

							// If there is a description save it for labels
							$explain_value = '';
							if ( isset( $value['desc'] ) ) {
								$explain_value = $value['desc'];
							}

							if(!in_array( $value['type'], $noRowElements)){
								// the row and the label
								$html[] = '<div class="psp-form-row' . ($this->tabsElements($box, $elm_id)) . '">
									   <label for="' . ( $elm_id ) . '">' . ( $value['title'] ) . '</label>
									   <div class="psp-form-item'. ( isset($value['size']) ? " " . $value['size'] : '' ) .'">';
							}

							// the element description
							if(isset($value['desc'])) $html[]	= '<span class="formNote">' . ( $value['desc'] ) . '</span>';

							switch ( $value['type'] ) {

								// Basic text input
								case 'text':
									$html[] = '<input ' . ( isset($value['readonly']) && $value['readonly'] == true ? 'readonly' : '' ) . ' ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' id="' . esc_attr( $elm_id ) . '" name="' . esc_attr( $option_name . $elm_id ) . '" type="text" value="' . esc_attr( $val ) . '" />';
								break;

								// Basic checkbox input
								case 'checkbox':
									if($val == '') $val = true;
									$html[] = '<input ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' ' . ( $val == true ? 'checked' : '' ). ' id="' . esc_attr( $elm_id ) . '" name="' . esc_attr( $option_name . $elm_id ) . '" type="checkbox" value="" />';
								break;

								// Basic upload_image
								case 'upload_image':
									$html[] = '<table border="0">';
									$html[] = '<tr>';
									$html[] = 	'<td>';
									$html[] = 		'<input class="upload-input-text" name="' . ( $elm_id ) . '" id="' . ( $elm_id ) . '_upload" type="text" value="' . ( $val ) . '" />';

									$html[] = 		'<script type="text/javascript">
										jQuery("#' . ( $elm_id ) . '_upload").data({
											"w": ' . ( $value['thumbSize']['w'] ) . ',
											"h": ' . ( $value['thumbSize']['h'] ) . ',
											"zc": ' . ( $value['thumbSize']['zc'] ) . '
										});
									</script>';

									$html[] = 	'</td>';
									$html[] = '<td>';
									$html[] = 		'<a href="#" class="button upload_button" id="' . ( $elm_id ) . '">' . ( $value['value'] ) . '</a> ';
									//$html[] = 		'<a href="#" class="button reset_button ' . $hide . '" id="reset_' . ( $elm_id ) . '" title="' . ( $elm_id ) . '">Remove</a> ';
									$html[] = '</td>';
									$html[] = '</tr>';
									$html[] = '</table>';

									$html[] = '<a class="thickbox" id="uploaded_image_' . ( $elm_id ) . '" href="' . ( $val ) . '" target="_blank">';

									if(!empty($val)){
										$imgSrc = $psp->image_resize( $val, $value['thumbSize']['w'], $value['thumbSize']['h'], $value['thumbSize']['zc'] );
										$html[] = '<img style="border: 1px solid #dadada;" id="image_' . ( $elm_id ) . '" src="' . ( $imgSrc ) . '" />';
									}
									$html[] = '</a>';
									
									$html[] = 		'<script type="text/javascript">
										loadAjaxUpload( jQuery("#' . ( $elm_id ) . '") );
									</script>';

								break;

								// Basic textarea
								case 'textarea':
									$cols = "120";
									if(isset($value['cols'])) {
										$cols = $value['cols'];
									}
									$height = "style='height:120px;'";
									if(isset($value['height'])) {
										$height = "style='height:{$value['height']};'";
									}

									$html[] = '<textarea id="' . esc_attr( $elm_id ) . '" ' . $height . ' cols="' . ( $cols ) . '" name="' . esc_attr( $option_name . $elm_id ) . '">' . esc_attr( $val ) . '</textarea>';
								break;

								// Basic html/text message
								case 'message':
									$html[] = '<div class="psp-message psp-' . ( $value['status'] ) . ' ' . ($this->tabsElements($box, $elm_id)) . '">' . ( $value['html'] ) . '</div>';
								break;

								// buttons
								case 'buttons':

									// buttons for each box

									if(count($value['options']) > 0){
										foreach ($value['options'] as $key => $value){
											$html[] = '<input
												type="' . ( $value['type'] ) . '"
												style="width:' . ( $value['width'] ) . '"
												value="' . ( $value['value'] ) . '"
												class="psp-button ' . ( $value['color'] ) . ' ' . ( $value['pos'] ) . ' ' . ( $value['action'] ) . '"
											/>';
										}
									}

								break;


								// Basic html/text message
								case 'html':
									$html[] = $value['html'];
								break;

								// Basic app, load the path of this file
								case 'app':

									$tryLoadInterface = str_replace("{plugin_folder_path}", $module["folder_path"], $value['path']);

									if(is_file($tryLoadInterface)) {
										// Turn on output buffering
										ob_start();

										require_once( $tryLoadInterface  );

										//copy current buffer contents into $message variable and delete current output buffer
										$html[] = ob_get_clean();
									}
								break;

								// Select Box
								case 'select':
									$html[] = '<select ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' name="' . esc_attr( $elm_id ) . '" id="' . esc_attr( $elm_id ) . '">';

									foreach ($value['options'] as $key => $option ) {
										$selected = '';
										if( $val != '' ) {
											if ( $val == $key || $val == $option ) { $selected = ' selected="selected"';}
										}
										$html[] = '<option'. $selected .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
									 }
									$html[] = '</select>';
								break;

								// multiselect Box
								case 'multiselect':
									$html[] = '<select ' . ( isset($value['force_width']) ? "style='width:" . ( $value['force_width'] ) . "px;'" : '' ) . ' multiple="multiple" size="6" name="' . esc_attr( $elm_id ) . '[]" id="' . esc_attr( $elm_id ) . '">';

									if(count($value['options']) > 1){
										foreach ($value['options'] as $key => $option ) {
											$selected = '';
											if( $val != '' ) {
												if ( in_array($key, $val) ) { $selected = ' selected="selected"';}
											}
											$html[] = '<option'. $selected .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
										}
									}
									$html[] = '</select>';
								break;
								
								// Basic authorization facebook button
								case 'authorization_button':
									
									// load the facebook SDK
									require_once( $this->cfg['paths']['scripts_dir_path'] . '/facebook/facebook.php' );
								
									$fb_details = $psp->getAllSettings('array', 'facebook_planner');
												
									if( (isset($fb_details['app_id']) && trim($fb_details['app_id']) != '') && ( isset($fb_details['app_secret']) && trim($fb_details['app_secret']) != '') ) {
										$facebook = new psp_Facebook(array(
											'appId'  => $fb_details['app_id'],
											'secret' => $fb_details['app_secret']
										));
									} 
									
									if( isset($facebook) ) {
										$validAuth = false;
										$state = isset($_REQUEST['state']) ? trim($_REQUEST['state']) : '';
										$dbToken = get_option('psp_fb_planner_token');
										
										if(trim($dbToken) != "" && $state == "") {
											$facebook->setAccessToken($dbToken);
											
											try {
												// get user profile
												$user_profile = $facebook->api('/me');
												
												if(count($user_profile) > 0){
													$validAuth = true;
													
													$html[] = '<p>This plugin is <b>authorized</b> for: <a target="_blank" href="' . ( $user_profile['link'] ) . '">' . $user_profile['name'] . '</a></p>';
													
													// login url
													$loginUrl = $facebook->getLoginUrl(
														array(
														'scope' => 'email,publish_stream,manage_pages,user_groups,offline_access',
														'redirect_uri' => admin_url('admin-ajax.php?action=psp_facebookAuth')
														)
													);
						
													$html[] = '<a href="' . ($loginUrl) . '" style="width: 133px;" class="psp-button blue">'. (__( 'Authorize this app again', WP_PLANNER_TEXTDOMAIN )) .'</a>';
												}
												
											} catch (wwPP_FacebookApiException $e) {
												
												// clean token
												update_option('psp_fb_planner_token', $token);
											}
										}
								
										if( $validAuth == false ) {
											// login url
											$loginUrl = $facebook->getLoginUrl(
												array(
													'scope' => 'email,publish_stream,user_groups,manage_pages,offline_access',
													'redirect_uri' => admin_url('admin-ajax.php?action=psp_facebookAuth')
												)
											);

											$html[] = '<a href="' . ($loginUrl) . '" style="width: 84px;" type="button" class="psp-button blue">'. (__( 'Authorizate app', WP_PLANNER_TEXTDOMAIN )) .'</a>';
										}
									}
								break;

							}

							if(!in_array( $value['type'], $noRowElements)){
								// close: .psp-form-row
								$html[] = '</div>';

								// close: .psp-form-item
								$html[] = '</div>';
							}

						}
					}

					// psp-message use for status message, default it's hidden
					$html[] = '<div class="psp-message" id="psp-status-box" style="display:none;"></div>';

					if( $box['buttons'] == true && !is_array($box['buttons']) ) {
						// buttons for each box
						$html[] = '<div class="psp-button-row">
							<input type="reset" value="' . __('Reset to default value', $psp->localizationName) . '" class="psp-button gray left" />
							<input type="submit" value="' . __('Save the settings', $psp->localizationName) . '" class="psp-button green psp-saveOptions" />
						</div>';
					}
					elseif( is_array($box['buttons']) ){
						// buttons for each box
						$html[] = '<div class="psp-button-row">';

						foreach ( $box['buttons'] as $key => $value ){
							$html[] = '<input type="submit" value="' . ( $value['value'] ) . '" class="psp-button ' . ( $value['color'] ) . ' ' . ( $value['action'] ) . '" />';
						}

						$html[] = '</div>';
					}

					if($showForm){
						// close: form
						$html[] = '</form>';
					}

					// close: box size div
					$html[] = '</div>';

					// close: .psp-panel
					$html[] = '</div>';

					// close: .psp-panel-content
					$html[] = '</div>';
				}
			}

			// return the $html
			return implode("\n", $html);
		}

		/*
		* printBaseInterface, method
		* --------------------------
		*
		* this will add the base DOM code for you options interface
		*/
		public function printBaseInterface()
		{
?>
		<div id="psp-wrapper" class="fluid wrapper-psp">

			<!-- Header -->
			<div id="psp-header">

				<!--div id="psp-header-top">


					<div class="psp-container clearfix">

						<div id="psp-logo-wrap">
							<div id="psp-logo">
								<div id="psp-logo-img">
									<a href="#">
										<img src="<?php echo $this->cfg['paths']['plugin_dir_url'] . '/icon_80.png';?>" alt="logo" />
									</a>
								</div>
							</div>
						</div>
					</div>
				</div-->

				<!--div id="psp-header-bottom">
					
					<div class="psp-container clearfix">
						<div id="psp-topMenu">
							<ul>
								<?php
								if(count($this->cfg['activate_modules']) > 0) {
									foreach ($this->cfg['menu_order'] as $order => $module_alias){
										// skip if module it's not activated
										if(!in_array($module_alias, array_keys($this->cfg['activate_modules']))) continue;

										// update the module with rest of information about modue
										$module = $this->cfg['modules'][$module_alias];
										
										if( isset($module[$module_alias]['menu']["show_in_menu"]) && $module[$module_alias]['menu']["show_in_menu"] === false ) continue; 
										$iconImg = '';
										if( is_file($module['folder_path'] . $module[$module_alias]['menu']['icon']) ) {
											$iconImg = '<img src="' . ( $module['folder_uri'] . $module[$module_alias]['menu']['icon'] ) . '" />';
										}

										if( is_file( $module["folder_path"] . 'options.php' ) ) {
											echo '<li id="psp-nav-' . ( $module_alias ) . '">'. ( $iconImg ) .'<a href="#!/' . ( $module_alias ) . '">' . ( $module[$module_alias]['menu']['title'] ) . '</a></li>';
										}
									}
								}
								?>
							</ul>
						</div>

					</div>
				</div-->
				<?php
				// show the top menu
				pspAdminMenu::getInstance()->show_menu();
				?>
			</div>

			<!-- Content -->
			<div id="psp-content">

				<!-- Container -->
				<div class="psp-container clearfix">

					<!-- Main Content Wrapper -->
					<div id="psp-content-wrap" class="clearfix">

						<!-- Content Area -->
						<div id="psp-content-area">
							<!-- Content Area -->
							<div id="psp-ajax-response"></div>

							<div class="clear"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

<?php
		}
		
		//make Tabs!
		private function tabsHeader($box) {
			$html = array();

			// get tabs
			$__tabs = $box['tabs'];

			$__ret = '';
			if (is_array($__tabs) && count($__tabs)>0) {
				$html[] = '<ul class="tabsHeader">';
				$html[] = '<li style="display:none;" id="tabsCurrent" title=""><li>'; //fake li with the current tab value!
				foreach ($__tabs as $tabClass=>$tabElements) {
					$html[] = '<li><a href="javascript:void(0);" title="'.$tabClass.'">'.$tabElements[0].'</a></li>';
				}
				$html[] = '</ul>';
				$__ret = implode('', $html);
				
			}
			return $__ret;
		}
		
		private function tabsElements($box, $elemKey) {
			// get tabs
			$__tabs = $box['tabs'];

			$__ret = '';
			if (is_array($__tabs) && count($__tabs)>0) {
				foreach ($__tabs as $tabClass=>$tabElements) {

					$tabElements = $tabElements[1];
					$tabElements = trim($tabElements);
					$tabElements = array_map('trim', explode(',', $tabElements));
					if (in_array($elemKey, $tabElements)) 
						$__ret .= ($tabClass.' '); //support element on multiple tabs!
				}
			}
			return ' '.trim($__ret).' ';
		}
	}
}