<?php
/**
 * Sitemap Generator Class
 * http://www.aa-team.com
 * ======================
 *
 * @package			pspSeo
 * @author			AA-Team
 */
class pspSeoSitemap
{
	/*
    * Some required plugin information
    */
    const VERSION = '1.0';

    /*
    * Store some helpers config
    */
	public $the_plugin = null;

	private $module_folder = '';

	static protected $_instance;
	
	/**
	*
	* @var XMLWriter
	*/
	private $writer;
	private $domain;
	private $path;
	private $filename = 'sitemap';
	private $current_item = 0;
	private $current_sitemap = 0;
	
	const EXT = '.xml';
	const SCHEMA = 'http://www.sitemaps.org/schemas/sitemap/0.9';
	const SCHEMA_IMG = 'http://www.google.com/schemas/sitemap-image/1.1';
	const SCHEMA_VIDEO = 'http://www.google.com/schemas/sitemap-video/1.1';
	const DEFAULT_PRIORITY = 0.5;
	const DEFAULT_FREQUENCY = 'monthly';
	const ITEM_PER_SITEMAP = 100000;
	const SEPERATOR = '-';
	const INDEX_SUFFIX = 'index';

    /*
    * Required __construct() function
    */
    public function __construct()
    {
    	global $psp;

    	$this->the_plugin = $psp;
		$this->detect_if_sitemap_page();
    }
    
	/**
    * Singleton pattern
    *
    * @return pspSeoSitemap Singleton instance
    */
    static public function getInstance()
    {
        if (!self::$_instance) {
            self::$_instance = new self;
        }

        return self::$_instance;
    }
	
	private function detect_if_sitemap_page()
	{
		$permalink = get_option('permalink_structure');
		$siteurl = get_option('siteurl');
		$parts = parse_url($siteurl);
		$path = $parts['path'];

		$uri = $_SERVER['REQUEST_URI'];
		$path_len = strlen($parts['path']);
		if(strlen($uri) > $path_len && substr($uri,0,$path_len) == $path)
		{
			$request = substr($uri,$path_len);
			$parts = parse_url($request);
			
			switch($parts['path'])
			{
				case '/sitemap.xml':
					$this->print_sitemap();
					break;
				default: 
					break;
			}
		}
	}
	
	private function get_items( $post_type='all' )
	{
		/* default arguments!
		$args = array(
			'posts_per_page'   => 5,
			'offset'           => 0,
			'category'         => '',
			'orderby'          => 'post_date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'post',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'post_status'      => 'publish',
			'suppress_filters' => true );
		*/
		$args = array( 
			'posts_per_page' => -1, 
			'offset'=> 1
		);
		
		if( $post_type != "all" ){
			$args['post_type'] = $post_type;
		}

		return get_posts( $args );
	}

	//get all published posts, pages, custom post types!
	private function get_items2( $post_type='post,page' ) {
		global $wpdb;
		
		$sql = "
			SELECT a.ID, a.post_type, a.post_mime_type, a.post_parent, a.post_content, a.guid, a.post_modified
			 FROM " . $wpdb->prefix . "posts AS a
			 WHERE 1=1
			 %s %s
			 ORDER BY a.post_date DESC
			;
		";
		
		$alwaysClause = $this->itemIsIncluded(); //sitemap always included items
		$clause = $this->clause_post_type($post_type, 'a');
		$sql = sprintf($sql, $clause, $alwaysClause);

		$res = $wpdb->get_results( $sql );
		return $res;
	}
	
	private function clause_post_type( $post_type='post,page', $dbAlias='a' ) {
		if ( empty($post_type) ) return false;
		
		$clause = " AND ( {$dbAlias}.post_status = 'publish' ";

		$post_type = explode(',', $post_type);
		$post_type = array_map( array($this, 'prepareForInList'), $post_type);
		$post_type2 = implode(',', $post_type);

		if (count($post_type)>1) {
			$clause .= " AND {$dbAlias}.post_type IN (" . $post_type2 . ") ";
		} else {
			$clause .= " AND {$dbAlias}.post_type = " . $post_type2 . " ";
		}
		$clause .= " ) ";
		return $clause;
	}
		

	//get all attachments - used to find media images!
	private function get_images( $post_type='post,page' ) {
		global $wpdb;
		
		$sql = "
			SELECT a.ID, a.post_type, a.post_mime_type, a.post_parent, a.guid
			 FROM " . $wpdb->prefix . "posts AS a
			 LEFT JOIN " . $wpdb->prefix . "posts AS b ON a.post_parent=b.ID
			 WHERE 1=1
			 AND ( a.post_parent>0 AND a.post_type = 'attachment' AND a.post_status = 'inherit' AND a.post_mime_type REGEXP 'image/[[:alpha:]]+' AND a.guid!='' )
			 %s
			 ORDER BY a.post_date DESC
			;
		";
		
		$clause = $this->clause_post_type($post_type, 'b');
		$sql = sprintf($sql, $clause, $alwaysClause);

		$res = $wpdb->get_results( $sql );
		return $res;
	}
	
	//retrieve images
	private function filter_images( $images=array() ) {
		if ( empty($images) ) return array();
		
		$__images = array();

		if ( is_array($images) && count($images)>0 ) {
			foreach ($images as $k=>$post) {
				$__images[ $post->post_parent ][] = $post->guid;
			}
		}
		return $__images;
	}
	private function filter_item_img( $post ) {
		if ( empty($post) ) return array();

		$__images = array();

		$pattern = "/[\'\"](http|https:\/\/.[^\'\"]+\.(?:jpe?g|png|gif))[\'\"]/ui"; //utf-8, case insensitive
		if( preg_match_all($pattern, $post->post_content, $matches, PREG_SET_ORDER)) {
			foreach($matches as $match) {
				//$__images[ $post->ID ][] = $match[1]; //retrieve only the link!
				$__images[] = $match[1];
			}
		}
		return $__images;
	}
	
	//retrieve videos
	private function filter_item_video($content) {
		
	}
	
	private function itemIsIncluded( $dbAlias='a' ) {
		global $wpdb;
		
		$sql = "
			SELECT a.post_id
			 FROM " . $wpdb->prefix . "postmeta AS a
			 WHERE 1=1
			 AND a.meta_key = 'psp_sitemap_isincluded' AND a.meta_value = 'always_include'
			 ORDER BY a.post_id ASC
			;
		";
		$res = $wpdb->get_results( $sql );

		$clause = '';
		$ret = array();
		if (is_array($res) && count($res)>0) {
			foreach ($res as $k=>$v) {
				$ret[] = $v->post_id;
			}
			$ret = array_map( array($this, 'prepareForInList'), $ret);
			$ret = implode(',', $ret);
			$clause = " OR {$dbAlias}.ID IN ($ret) ";
		}
		return $clause;
	}
	
	//print xml sitemap!
	private function print_sitemap( $post_type='post,page' )
	{
		$siteurl = get_option('siteurl');
		$site_parts = parse_url($siteurl);-  
		//$this->setDomain( $site_parts['scheme'] . '://' . $site_parts['host'] );
		$this->setDomain( $siteurl );
		$this->setPath( '/' );
		$this->setFilename( 'sitemap_index' );
		
		$general_sitemap_settings = $this->the_plugin->get_theoption('psp_sitemap');
		$post_type = implode(',', $general_sitemap_settings['post_types']);

		$items = $this->get_items2( $post_type );
		if ( $general_sitemap_settings['include_img']=='yes' ) {
			$images = $this->get_images( $post_type );
			$images = $this->filter_images( $images );
		}

		if( count($items) > 0 ) {

			$this->text_xml_header();
			$this->addItem( home_url(), '1.0', 'daily', 'Today' );

			foreach ($items as $key => $value) {

				$post_type = $value->post_type;
				$permalink = get_permalink( $value->ID );
				$sitemap_settings = get_post_meta( $value->ID, 'psp_sitemap', true );
				$sitemap_isincluded = get_post_meta( $value->ID, 'psp_sitemap_isincluded', true );

				//verify per item is included!
				if ( isset($sitemap_isincluded) && trim($sitemap_isincluded) == "never_include" ) continue 1;

				$__itemImg = array();
				if ( $general_sitemap_settings['include_img']=='yes' ) {
					if ( isset($images[ $value->ID ]) && is_array($images[ $value->ID ]) && count($images[ $value->ID ])>0 )
						$__itemImg = $images[ $value->ID ];
	
					$__itemImg2 = $this->filter_item_img( $value ); //retrieve post images from post content
					$__itemImg = array_merge( $__itemImg, $__itemImg2 );
				}

				$priority = self::DEFAULT_PRIORITY;
				if ( isset($sitemap_settings['priority']) &&  trim($sitemap_settings['priority']) != "" ){
					$priority = $sitemap_settings['priority'];
				} elseif ( isset($general_sitemap_settings['priority'][$post_type]) && trim($general_sitemap_settings['priority'][$post_type]) != "") {
					$priority = $general_sitemap_settings['priority'][$post_type];
				}
				
				$changefreq = self::DEFAULT_FREQUENCY;
				if( isset($sitemap_settings['changefreq']) &&  trim($sitemap_settings['changefreq']) != "" ){
					$changefreq = $sitemap_settings['changefreq'];
				} elseif ( isset($general_sitemap_settings['changefreq'][$post_type]) && trim($general_sitemap_settings['changefreq'][$post_type]) != "" && trim($general_sitemap_settings['changefreq'][$post_type]) != "-") {
					$changefreq = $general_sitemap_settings['changefreq'][$post_type];
				}
				
				$this->addItem( $permalink, $priority, $changefreq, $value->post_modified, $__itemImg );
			}
		}
		
		$this->endSitemap();
		die;
	}
	
	/**
	* Change the header to text/xml
	*
	*/
	private function text_xml_header() 
	{
		header('Cache-Control: no-cache, must-revalidate, max-age=0');
		header('Pragma: no-cache');
		header('X-Robots-Tag: noindex, follow');
		header('Content-Type: text/xml');
	}

	/**
	* Returns root path of the website
	*
	* @return string
	*/
	private function getDomain() {
		return $this->domain;
	}
	
	/**
	* Sets root path of the website, starting with http:// or https://
	*
	* @param string $domain
	*/
	public function setDomain($domain) {
		$this->domain = $domain;
		return $this;
	}
	
	/**
	 * Returns XMLWriter object instance
	 *
	 * @return XMLWriter
	 */
	private function getWriter() {
		return $this->writer;
	}

	/**
	 * Assigns XMLWriter object instance
	 *
	 * @param XMLWriter $writer 
	 */
	private function setWriter(XMLWriter $writer) {
		$this->writer = $writer;
	}

	/**
	 * Returns path of sitemaps
	 * 
	 * @return string
	 */
	private function getPath() {
		return $this->path;
	}

	/**
	 * Sets paths of sitemaps
	 * 
	 * @param string $path
	 * @return Sitemap
	 */
	public function setPath($path) {
		$this->path = $path;
		return $this;
	}

	/**
	 * Returns filename of sitemap file
	 * 
	 * @return string
	 */
	private function getFilename() {
		return $this->filename;
	}

	/**
	 * Sets filename of sitemap file
	 * 
	 * @param string $filename
	 * @return Sitemap
	 */
	public function setFilename($filename) {
		$this->filename = $filename;
		return $this;
	}

	/**
	 * Returns current item count
	 *
	 * @return int
	 */
	private function getCurrentItem() {
		return $this->current_item;
	}

	/**
	 * Increases item counter
	 * 
	 */
	private function incCurrentItem() {
		$this->current_item = $this->current_item + 1;
	}

	/**
	 * Returns current sitemap file count
	 *
	 * @return int
	 */
	private function getCurrentSitemap() {
		return $this->current_sitemap;
	}

	/**
	 * Increases sitemap file count
	 * 
	 */
	private function incCurrentSitemap() {
		$this->current_sitemap = $this->current_sitemap + 1;
	}

	/**
	 * Prepares sitemap XML document
	 * 
	 */
	private function startSitemap() 
	{
		$this->setWriter(new XMLWriter());
		$this->getWriter()->openURI('php://output');
		$this->getWriter()->startDocument('1.0', 'UTF-8');
		$this->getWriter()->setIndent(true);
		$this->getWriter()->writeComment( 'Sitemap generated using: ' . ( $this->the_plugin->details['plugin_name'] ) );
		$this->getWriter()->writeComment( 'Generated-on=' . ( date("F j, Y, g:i a") ) );
		
		$this->getWriter()->startElement('urlset');
		$this->getWriter()->writeAttribute('xmlns', self::SCHEMA);
		$this->getWriter()->writeAttribute('xmlns:image', self::SCHEMA_IMG);
		//$this->getWriter()->writeAttribute('xmlns:video', self::SCHEMA_VIDEO);
	}

	/**
	 * Adds an item to sitemap
	 *
	 * @param string $loc URL of the page. This value must be less than 2,048 characters. 
	 * @param string $priority The priority of this URL relative to other URLs on your site. Valid values range from 0.0 to 1.0.
	 * @param string $changefreq How frequently the page is likely to change. Valid values are always, hourly, daily, weekly, monthly, yearly and never.
	 * @param string|int $lastmod The date of last modification of url. Unix timestamp or any English textual datetime description.
	 * @return Sitemap
	 */
	public function addItem($loc, $priority = self::DEFAULT_PRIORITY, $changefreq = NULL, $lastmod = NULL, $images=array()) {
		if (($this->getCurrentItem() % self::ITEM_PER_SITEMAP) == 0) {
			if ($this->getWriter() instanceof XMLWriter) {
				$this->endSitemap();
			}
			$this->startSitemap();
			$this->incCurrentSitemap();
		}
		$this->incCurrentItem();
		$this->getWriter()->startElement('url');
		//$this->getWriter()->writeElement('loc', $this->getDomain() . $loc);
		$this->getWriter()->writeElement('loc', $loc);
		if (isset($images) && is_array($images) && count($images)>0)
			$this->addItemImages($images);
		$this->getWriter()->writeElement('priority', $priority);
		if ($changefreq)
			$this->getWriter()->writeElement('changefreq', $changefreq);
		if ($lastmod)
			$this->getWriter()->writeElement('lastmod', $this->getLastModifiedDate($lastmod));
		$this->getWriter()->endElement();
		return $this;
	}

	/**
	 * Prepares given date for sitemap
	 *
	 * @param string $date Unix timestamp or any English textual datetime description
	 * @return string Year-Month-Day formatted date.
	 */
	private function getLastModifiedDate($date) {
		if (ctype_digit($date)) {
			return date('Y-m-d', $date);
		} else {
			$date = strtotime($date);
			return date('Y-m-d', $date);
		}
	}
	
	/**
	 * Adds an item images to sitemap
	 *
	 * @param string $images array of item images!
	 * @return Sitemap images
	 */
	private function addItemImages($images) {
		foreach ($images as $v) {
			$this->getWriter()->startElement('image:image');
			$this->getWriter()->writeElement('image:loc', $v);
			$this->getWriter()->endElement();
		}
		return $this;
	}
	
	/**
	 * Finalizes tags of sitemap XML document.
	 *
	 */
	private function endSitemap() {
		$this->getWriter()->endElement();
		$this->getWriter()->endDocument();
	}
	
	private function prepareForInList($v) {
		return "'".$v."'";
	}
}
pspSeoSitemap::getInstance();