<!DOCTYPE html>
<!--[if IE 7 ]><html class="ie7" <?php language_attributes();?>><![endif]-->
<!--[if IE 8 ]><html class="ie8" <?php language_attributes();?>><![endif]-->
<!--[if IE 9 ]><html class="ie9" <?php language_attributes();?>><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--><html <?php language_attributes();?>><!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />	
<title><?php
	global $page, $paged;
	wp_title( '|', true, 'right' );
	bloginfo( 'name' );
	if ( $paged >= 2 || $page >= 2 )
	echo ' | ' . sprintf( __( 'Страница %s'), max( $paged, $page ) );
?></title>
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php if (of_get_option('favicon') != '') { ?>
<link rel="shortcut icon" href="<?php echo of_get_option('favicon'); ?>" type="image/x-icon" />
<?php } else { ?>
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" type="image/x-icon" />   
<?php } ?> 
<?php wp_head(); ?>
<style type="text/css">
  body { url("images/noisy_grid.png") repeat scroll 0 0 rgba(0, 0, 0, 0); }
  a { color: <?php echo of_get_option('link_color'); ?>; }
  a:hover { color: <?php echo of_get_option('link_color_hover'); ?>; }
  h1.entry-title { color: <?php echo of_get_option('color_e_t'); ?>; }
  h2.entry-title a { color: <?php echo of_get_option('link_color_e_t'); ?>; }
  h2.entry-title a:hover { color: <?php echo of_get_option('link_color_hover_e_t'); ?>; } 
  #sidebar { color: <?php echo of_get_option('text_color_s'); ?>; }
  #sidebar a { color: <?php echo of_get_option('link_color_s'); ?>; }
  #sidebar a:hover { color: <?php echo of_get_option('link_color_hover_s'); ?>; }
  #sidebar .title-post-wg, #sidebar .title-category-wg, #sidebar .title-tag-wg { color: <?php echo of_get_option('text_color_s_t'); ?>; }
  .sidebar-block-title { color: <?php echo of_get_option('text_color_s_t'); ?>; }  
  #bottom { color: <?php echo of_get_option('text_color_bottom'); ?>; }
  .bottom-title, #bottom .title-post-wg { color: <?php echo of_get_option('color_heading_bottom'); ?> !important; }
  #bottom a, #bottom ul#recentcomments li a.url { color: <?php echo of_get_option('link_color_bottom'); ?>; }
  #bottom a:hover, #bottom ul#recentcomments li a.url:hover { color: <?php echo of_get_option('link_color_hover_bottom'); ?>; }
  #footer { color: <?php echo of_get_option('text_color_f'); ?>;}
  #footer a { color: <?php echo of_get_option('link_color_f'); ?>; }
  #footer a:hover { color: <?php echo of_get_option('link_color_hover_f'); ?>; }  
</style> 
</head>
<body <?php if (of_get_option('sidebar') == 'l_s') { ?><?php body_class('l_s'); ?><?php } else { ?><?php body_class(); ?><?php } ?>>
<div id="page-wrap">
<div id="header-block"> 
 <?php if (of_get_option('logo') != '') { ?>
   <div id="logo"><a href="<?php echo home_url(); ?>"><img src="<?php echo of_get_option('logo'); ?>" alt=""/></a></div>
 <?php } elseif (of_get_option('logo_text')) { ?>
   <div id="logo-text"><a href="<?php bloginfo('url'); ?>"><?php echo of_get_option('logo_text'); ?></a></div>
 <?php } else { ?>
   <div id="logo"><a href="<?php echo home_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt=""/></a></div>
 <?php } ?> 
	
 <?php dynamic_sidebar( 'Top Banner' ); ?>
</div> 

  <?php wp_nav_menu( array(
	'container' => 'div', 
	'container_id' => 'top-nav',
	'menu_class' => 'top-menu', 
	'link_after' => '<span class="m-a"></span>',
	'depth' => 0,
	'theme_location' => 'top',
	'fallback_cb'     => false
	)); 
  ?>
  
<div class="line-container-white"></div>
<div id="container">




 