
<div class="line-list-post"></div>
<?php while ( have_posts() ) : the_post(); ?>
  <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <span class="fi"></span>
    <?php if ( ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) ) ) : ?>
    <!-- Gallery -->
      <div class="p-r">
	    <div class="com-block">
	      <?php comments_number('<span class="com-i"></span>0','<span class="com-i"></span>1','<span class="com-i"></span>%'); ?>
	    </div>
	    <h2 class="entry-title">
          <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>	
	    <a class="gal-img" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
		  <?php 
           $args = array(
	         'orderby' => 'date',
		     'post_type' => 'attachment',
		     'post_parent' => get_the_ID(),
		     'post_mime_type' => 'image',
		     'post_status' => null,
		     'numberposts' => 4,
	        );
	        $attachments = get_posts($args);
          ?>
          <?php if ($attachments) : ?>
            <?php foreach ($attachments as $attachment) : ?>
            <?php
		      $src = wp_get_attachment_image_src( $attachment->ID, 'category-thumbnail'); 
	        ?>    
              <img height="<?php echo $src[2]; ?>" width="<?php echo $src[1]; ?>" alt="<?php echo apply_filters('the_title', $attachment->post_title); ?>" src="<?php echo $src[0]; ?>">
            <?php endforeach; ?>
          <?php endif; ?>
        </a>		  
        <div class="entry-details"> 
          <span class="d-i"></span><?php echo get_the_date(); ?> <span class="cat-i"></span><?php the_category(', '); ?> <?php the_tags('<span class="tag-i"></span>', ', ', ''); ?>  
        </div>
	  </div>
	
	<?php elseif ( ( function_exists( 'get_post_format' ) && 'image' == get_post_format( $post->ID ) ) ) : ?>
    <!-- Image -->
      <div class="p-r">
 	    <div class="com-block">
	      <?php comments_number('<span class="com-i"></span>0','<span class="com-i"></span>1','<span class="com-i"></span>%'); ?>
	    </div>
        <h2 class="entry-title">
          <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('image-small-thumbnail'); ?></a> 
        <div class="entry-details"> 
          <span class="d-i"></span><?php echo get_the_date(); ?> <span class="cat-i"></span><?php the_category(', '); ?> <?php the_tags('<span class="tag-i"></span>', ', ', ''); ?>  
        </div>
	  </div>
  
    <?php elseif ( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $post->ID ) ) ) : ?>
    <!-- Video -->
      <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>			          
        <div class="p-l">
		  <div class="thumb-entry">
            <a href="<?php the_permalink(); ?>"><span class="play-i"></span><?php the_post_thumbnail('category-thumbnail'); ?></a>   
          </div>
	    </div>	
      <?php endif; ?> 		
      <div class="p-r">
	    <div class="com-block">
	      <?php comments_number('<span class="com-i"></span>0','<span class="com-i"></span>1','<span class="com-i"></span>%'); ?>
	    </div>
        <h2 class="entry-title">
          <a title="<?php the_title()?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
        <p>
          <?php excerpt('50'); ?> 
        </p>
        <div class="entry-details"> 
          <span class="d-i"></span><?php echo get_the_date(); ?> <span class="cat-i"></span><?php the_category(', '); ?> <?php the_tags('<span class="tag-i"></span>', ', ', ''); ?>  
        </div>
	  </div>
 
    <?php elseif ( ( function_exists( 'get_post_format' ) && 'link' == get_post_format( $post->ID ) ) ) : ?>
    <!-- Link -->
      <?php $link_url = get_post_meta(get_the_ID(), 'lt_link_url', true); ?>
      <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>
	    <div class="p-l">			          
          <div class="thumb-entry">
            <a rel="nofollow" target="_blank" href="<?php echo $link_url; ?>"><?php the_post_thumbnail('category-thumbnail'); ?></a>   
          </div>
		</div>	
      <?php endif; ?> 		
      <div class="p-r">
        <div class="entry-title-link">
          <a rel="nofollow" target="_blank" title="<?php the_title(); ?>" href="<?php echo $link_url; ?>"><?php the_title(); ?></a>
        </div>
	    <div class="url-link"> 
          <?php echo $link_url; ?>
        </div>
        <?php the_content(); ?> 
        <div class="entry-details"> 
          <span class="cat-i"></span><?php the_category(', '); ?> <?php the_tags('<span class="tag-i"></span>', ', ', ''); ?>  
        </div>
	  </div>
 
    <?php else : ?>
    <!-- Standart -->
      <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>
	    <div class="p-l">
          <div class="thumb-entry">
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('category-thumbnail'); ?></a>   
          </div>	
		</div>
      <?php endif; ?> 	
      <div class="p-r">
	    <div class="com-block">
	      <?php comments_number('<span class="com-i"></span>0','<span class="com-i"></span>1','<span class="com-i"></span>%'); ?>
	    </div>
        <h2 class="entry-title">
          <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
        <p>
          <?php excerpt('50'); ?> 
        </p>
        <div class="entry-details"> 
          <span class="d-i"></span><?php echo get_the_date(); ?> <span class="cat-i"></span><?php the_category(', '); ?> <?php the_tags('<span class="tag-i"></span>', ', ', ''); ?>  
        </div>
	  </div>
    <?php endif; ?>	  
  </div>  
<?php endwhile; ?>
