<?php
/*
 * Plugin Name: Recent/Popular/Random Post Widget
 * Plugin URI: http://ferens.ru/
 * Description: Вывод последних, популярных, случайных записей
 * Version: 1.0
 * Author: ferens.ru
 * Author URI: http://ferens.ru/
 */

class LT_recent_pop_rand_post extends WP_Widget {

    function LT_recent_pop_rand_post() {
	$widget_ops = array( 'classname' => 'lt_recent_pop_rand_post', 'description' => __('Вывод последних, популярных, случайных записей', 'ltlang') );
    $this->WP_Widget( 'lt_recent_pop_rand_post', __('Записи LT', 'ltlang'), $widget_ops );
    }

    function widget($args, $instance) {		
        global $wpdb;
		extract( $args );
                $title = apply_filters('widget_title', $instance['title'] );
				$number = $instance['number'];
				$text = $instance['text'];
				$category_id = empty( $instance['category_id'] ) ? '' : $instance['category_id'];	
				$sortby = empty( $instance['sortby'] ) ? 'date' : $instance['sortby'];
				$vs = ! empty( $instance['video'] ) ? '1' : '0';
				$ps = ! empty( $instance['photo'] ) ? '1' : '0';
				
             echo $before_widget;
			 ?>		
			 
<?php if (($vs) == '1'){ ?> 
  <div class="post-video-wg <?php if (($sortby) == 'comment_count'){ ?>p-p-wg<?php } elseif (($sortby) == 'rand') { ?>r-p-wg<?php } else { ?>new-p-wg<?php }?>">
	<?php if (($title)!=""){ ?>
	  <div class="title-post-wg"><?php echo $title; ?></div>											
	<?php }?>
	<?php
	$ltPosts = new WP_Query();
	$ltPosts->query('posts_per_page=' . $number . '&ignore_sticky_posts=1&cat=' . $category_id . '&orderby=' . $sortby);
	while ($ltPosts->have_posts()) : $ltPosts->the_post(); ?>
      <div class="post-video-entry-wg">
	    <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>		          
          <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" ><?php the_post_thumbnail('post-widget-thumbnail'); ?></a>             
        <?php endif; ?>        	
		<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>	
		<?php if (($sortby) == 'comment_count') : ?>
		    <div class="post-details-wg">
		      <?php comments_number('<span></span> 0','<span></span> 1','<span></span> %'); ?>
			</div>
		<?php endif; ?>
      </div>	
	<?php endwhile; ?>
	<?php wp_reset_query();?>				
  <div class="clear"></div>   
  </div>
<?php } elseif (($ps) == '1'){ ?> 
  <div class="post-photo-wg <?php if (($sortby) == 'comment_count'){ ?>p-p-wg<?php } elseif (($sortby) == 'rand') { ?>r-p-wg<?php } else { ?>new-p-wg<?php }?>">
	<?php if (($title)!=""){ ?>
	  <div class="title-post-wg"><?php echo $title; ?></div>											
	<?php }?>
	<?php
	$ltPosts = new WP_Query();
	$ltPosts->query('posts_per_page=' . $number . '&ignore_sticky_posts=1&cat=' . $category_id . '&orderby=' . $sortby);
	while ($ltPosts->have_posts()) : $ltPosts->the_post(); ?>
      <div class="post-photo-entry-wg">
	    <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>		          
          <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" ><?php the_post_thumbnail('post-widget-thumbnail'); ?></a>             
        <?php endif; ?>
        <?php if (($sortby) == 'comment_count') : ?>
		  <div class="post-details-wg">
		    <?php comments_number('<span></span> 0','<span></span> 1','<span></span> %'); ?>
		  </div>
		<?php endif; ?>		
      </div>	
	<?php endwhile; ?>
	<?php wp_reset_query();?>				
  <div class="clear"></div>   
  </div>
<?php } else { ?>
  <div class="post-wg <?php if (($sortby) == 'comment_count'){ ?>p-p-wg<?php } elseif (($sortby) == 'rand') { ?>r-p-wg<?php } else { ?>new-p-wg<?php }?>">
	<?php if (($title)!=''){ ?>  
	  <div class="title-post-wg">
	    <?php echo $title; ?>
	  </div>											
	<?php }?>
	<?php
	$ltPosts = new WP_Query();
	$ltPosts->query('posts_per_page=' . $number . '&ignore_sticky_posts=1&cat=' . $category_id . '&orderby=' . $sortby);
	while ($ltPosts->have_posts()) : $ltPosts->the_post(); ?>
      <div class="post-entry-wg">
	  	<div class="post-l-wg">
	      <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>		          
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" ><?php the_post_thumbnail('post-widget-thumbnail'); ?></a>
          <?php endif; ?> 
		  <?php if (($sortby) == 'comment_count'){ ?>
		    <div class="post-details-wg">
		      <?php comments_number('<span></span> 0','<span></span> 1','<span></span> %'); ?>
			</div>
		  <?php } else { ?> 
		    <div class="post-details-wg">
		      <?php echo get_the_date('d.m.Y'); ?>
		    </div>
		  <?php }?>
        </div>		
		<div class="post-con-wg">
      	  <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
		  <p><?php excerpt($text); ?></p>
		</div>
      </div>	
	<?php endwhile; ?>
	<?php wp_reset_query();?>				
  <div class="clear"></div>   
  </div>
<?php }?>

	<?php 
	 echo $after_widget;
    }

  //Widget Update
    function update($new_instance, $old_instance) {				
        $instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = strip_tags( $new_instance['number'] );
		if ( in_array( $new_instance['sortby'], array( 'date', 'comment_count', 'rand' ) ) ) {
			$instance['sortby'] = $new_instance['sortby'];
		} else {
			$instance['sortby'] = 'date';
		}
		$instance['text'] = strip_tags( $new_instance['text'] );
		$instance['category_id'] = strip_tags( $new_instance['category_id'] );
		$instance['video'] = !empty($new_instance['video']) ? 1 : 0;
		$instance['photo'] = !empty($new_instance['photo']) ? 1 : 0;

		return $instance;
    }

 function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'number' => '5', 'text' => '14', 'sortby' => 'date', 'category_id' => '' ) );
		$title = esc_attr( $instance['title'] );
		$video = isset($instance['video']) ? (bool) $instance['video'] :false;
		$photo = isset($instance['photo']) ? (bool) $instance['photo'] :false;
 ?>

<p>
<label for="<?php echo $this->get_field_id( 'title' ); ?>">Заголовок:</label>
<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('category_id'); ?>">Категории:</label>
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('category_id'); ?>" name="<?php echo $this->get_field_name('category_id'); ?>" value="<?php echo $instance['category_id']; ?>" />
<br />
<small>ID категорий, разделённые запятыми</small>
</p>

<p>
<label for="<?php echo $this->get_field_id('number'); ?>">Количество записей:</label>
<input class="widefat" style="width:60%;" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" value="<?php echo $instance['number']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('text'); ?>">Количество слов в тексте:</label><br/>
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" value="<?php echo $instance['text']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('sortby'); ?>">Фильтр:</label>
<select name="<?php echo $this->get_field_name('sortby'); ?>" id="<?php echo $this->get_field_id('sortby'); ?>" class="widefat">
	<option value="date"<?php selected( $instance['sortby'], 'date' ); ?>>Дата добавления</option>
	<option value="comment_count"<?php selected( $instance['sortby'], 'comment_count' ); ?>>Количество комментариев</option>
	<option value="rand"<?php selected( $instance['sortby'], 'rand' ); ?>>Случайно</option>
</select>
</p>

<p>
<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('video'); ?>" name="<?php echo $this->get_field_name('video'); ?>"<?php checked( $video ); ?> />
<label for="<?php echo $this->get_field_id('video'); ?>">Стиль видео</label><br />

<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('photo'); ?>" name="<?php echo $this->get_field_name('photo'); ?>"<?php checked( $photo ); ?> />
<label for="<?php echo $this->get_field_id('photo'); ?>">Стиль фото</label>
</p>
		
    <?php 
    }
}
?>