<?php
/*
 * Plugin Name: Slider Widget
 * Plugin URI: http://ferens.ru/
 * Description: Вывод записей по дате добавления, количеству комментариев, случайно в виде слайд-шоу
 * Version: 1.1
 * Author: ferens.ru
 * Author URI: http://ferens.ru/
 */

class InfoNews_slider_post extends WP_Widget {

    function InfoNews_slider_post() {
	$widget_ops = array( 'classname' => 'lt_slider_post', 'description' => __('Вывод записей по дате добавления, количеству комментариев, случайно в виде слайд-шоу', 'ltlang') );
    $this->WP_Widget( 'lt_slider_post', __('Слайдер InfoNews', 'ltlang'), $widget_ops );
    }

    function widget($args, $instance) {		
        global $wpdb;
		extract( $args );
				$number = $instance['number'];
				$category_id = empty( $instance['category_id'] ) ? '' : $instance['category_id'];	
				$play = $instance['play'];
				$sortby = empty( $instance['sortby'] ) ? 'date' : $instance['sortby'];
				$style = empty( $instance['style'] ) ? 'red' : $instance['style'];
				$text = $instance['text'];
				
             echo $before_widget;
             if ( $title )
                echo $before_widget; ?>					

      <script type="text/javascript">
        jQuery(window).load(function() {
          jQuery('.flexslider').flexslider({
            animation: "fade",
	        directionNav: true,
			prevText: "",
            nextText: "", 
	        controlNav: true,
	        namespace: "lt-",
	        pauseOnHover: true, 
	        slideshowSpeed: <?php echo $play; ?>,
            animationSpeed: 900
          });
        });
      </script>
				
<div id="slider">
<div class="flexslider">
<ul class="slides">
<?php
	$sliderPosts = new WP_Query();
	$sliderPosts->query (array (
	                'orderby' => $sortby,
					'posts_per_page' => $number,
					'ignore_sticky_posts' => 1,
					'cat' => $category_id
					));
	while ($sliderPosts->have_posts()) : $sliderPosts->the_post(); ?>
	<li>
	  <div class="slide-con-left">
	    <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>	
	      <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" ><?php the_post_thumbnail('slider-thumbnail'); ?></a>   
	    <?php endif; ?> 
	  </div>
	  <div class="slide-con-right <?php if (($style) == 'red'){ ?>red-sl<?php } elseif (($style) == 'blue'){ ?>blue-sl<?php } elseif (($style) == 'green'){ ?>green-sl<?php } elseif (($style) == 'orange'){ ?>orange-sl<?php } else { ?>black-sl<?php }?>">
		<h5>
          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h5>    
		<p class="slider-details">
		  <?php echo get_the_date(); ?> / <?php the_category(', '); ?> 
		</p>
        <p>
		  <?php excerpt($text); ?>
		</p>
	  </div>
    </li>
<?php endwhile; ?>	
<?php wp_reset_query();?>
</ul>
</div>
<div class="clear"></div>
</div>
		<?php 
		echo $after_widget;
    }

 //Widget Update
    function update($new_instance, $old_instance) {				
        $instance = $old_instance;
		$instance['number'] = strip_tags( $new_instance['number'] );
		if ( in_array( $new_instance['sortby'], array( 'date', 'comment_count', 'rand' ) ) ) {
			$instance['sortby'] = $new_instance['sortby'];
		} else {
			$instance['sortby'] = 'date';
		}
		
		if ( in_array( $new_instance['style'], array( 'red', 'blue', 'green', 'orange', 'black' ) ) ) {
			$instance['style'] = $new_instance['style'];
		} else {
			$instance['style'] = 'red';
		}
        
		$instance['category_id'] = strip_tags( $new_instance['category_id'] );
		$instance['play'] = strip_tags( $new_instance['play'] );
		$instance['text'] = strip_tags( $new_instance['text'] );

		return $instance;
    }

	function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'number' => '5', 'sortby' => 'date', 'style' => 'red', 'category_id' => '', 'play' => '5000', 'text' => '25' ) );
		$title = esc_attr( $instance['title'] );
 ?>

<p>
<label for="<?php echo $this->get_field_id('category_id'); ?>">Категории:</label>
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('category_id'); ?>" name="<?php echo $this->get_field_name('category_id'); ?>" value="<?php echo $instance['category_id']; ?>" />
<br />
<small>ID категорий, разделённые запятыми</small>
</p>

<p>
<label for="<?php echo $this->get_field_id('sortby'); ?>">Фильтр:</label>
<select name="<?php echo $this->get_field_name('sortby'); ?>" id="<?php echo $this->get_field_id('sortby'); ?>" class="widefat">
	<option value="date"<?php selected( $instance['sortby'], 'date' ); ?>>Дата добавления</option>
	<option value="comment_count"<?php selected( $instance['sortby'], 'comment_count' ); ?>>Количество комментариев</option>
	<option value="rand"<?php selected( $instance['sortby'], 'rand' ); ?>>Случайно</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('style'); ?>">Стиль:</label>
<select name="<?php echo $this->get_field_name('style'); ?>" id="<?php echo $this->get_field_id('style'); ?>" class="widefat">
	<option value="red"<?php selected( $instance['style'], 'red' ); ?>>Красный</option>
	<option value="blue"<?php selected( $instance['style'], 'blue' ); ?>>Синий</option>
	<option value="green"<?php selected( $instance['style'], 'green' ); ?>>Зеленый</option>
	<option value="orange"<?php selected( $instance['style'], 'orange' ); ?>>Оранжевый</option>
	<option value="black"<?php selected( $instance['style'], 'black' ); ?>>Черный</option>
</select>
</p>

<p>
<label for="<?php echo $this->get_field_id('number'); ?>">Количество записей:</label><br/>
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" value="<?php echo $instance['number']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('text'); ?>">Количество слов в тексте:</label><br/>
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" value="<?php echo $instance['text']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('play'); ?>">Скорость анимации (1000-15000):</label><br/>
<input class="widefat" style="width:96.5%;" id="<?php echo $this->get_field_id('play'); ?>" name="<?php echo $this->get_field_name('play'); ?>" value="<?php echo $instance['play']; ?>" />
</p>
		
		<?php 
    }

}
?>