<?php
/*
 * Plugin Name: List Categories Widget
 * Plugin URI: http://ferens.ru/
 * Description: Текст LT
 * Version: 1.0
 * Author: ferens.ru
 * Author URI: http://ferens.ru/
 */

class InfoNews_text_block extends WP_Widget {

    function InfoNews_text_block() {
	$widget_ops = array( 'classname' => 'lt_text_block', 'description' => __('Произвольный текст или HTML-код с возможностью задавать цвет фона блока и цвет текста.', 'ltlang') );
    $control_ops = array('width' => 400, 'height' => 300);
    $this->WP_Widget( 'lt_text_block', __('Текст InfoNews', 'ltlang'), $widget_ops, $control_ops );
    }

    function widget($args, $instance) {		
        global $wpdb;
		extract( $args );
                $title = apply_filters('widget_title', $instance['title'] );
				$con_bl = apply_filters( 'widget_text', empty( $instance['con_bl'] ) ? '' : $instance['con_bl'], $instance );
				$color_title_bl = $instance['color_title_bl'];
				$bg_title_bl = $instance['bg_title_bl'];
				$pad_top_bot_title = $instance['pad_top_bot_title'];
				$pad_left_right_title = $instance['pad_left_right_title'];
				$color_text_bl = $instance['color_text_bl'];
				$bg_bl = $instance['bg_bl'];
				$pad_bl = $instance['pad_bl'];
				
             echo $before_widget;
             ?>	
				
              <div class="wg-text-block" style="background: #<?php echo $bg_bl; ?>; color: #<?php echo $color_text_bl; ?>; padding: <?php echo $pad_bl; ?>px;">
			    <?php if (($title)!=""){ ?>
				  <div class="title-wg-text-block" style="background: #<?php echo $bg_title_bl; ?>; color: #<?php echo $color_title_bl; ?>; padding: <?php echo $pad_top_bot_title; ?>px <?php echo $pad_left_right_title; ?>px;">
				    <?php echo $title; ?>
				  </div>
				<?php }?>
				<?php echo !empty( $instance['filter'] ) ? wpautop( $con_bl ) : $con_bl; ?>
			  <div class="clear"></div>
			  </div>
					
		<?php 
		echo $after_widget;
    }

    /* WP_Widget Update */
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['color_title_bl'] = strip_tags($new_instance['color_title_bl']);
		$instance['bg_title_bl'] = strip_tags($new_instance['bg_title_bl']);
		$instance['pad_top_bot_title'] = strip_tags($new_instance['pad_top_bot_title']);
		$instance['pad_left_right_title'] = strip_tags($new_instance['pad_left_right_title']);
		$instance['color_text_bl'] = strip_tags($new_instance['color_text_bl']);
		$instance['bg_bl'] = strip_tags($new_instance['bg_bl']);
		$instance['pad_bl'] = strip_tags($new_instance['pad_bl']);
		if ( current_user_can('unfiltered_html') )
			$instance['con_bl'] =  $new_instance['con_bl'];
		else
			$instance['con_bl'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['con_bl']) ) );
		$instance['filter'] = isset($new_instance['filter']);
		return $instance;
	}

    /* WP_Widget Form */
    function form($instance) {				
            $defaults = array(
		    'title' => '',
			'color_title_bl' => 'fefefe',
			'bg_title_bl' => 'd45353',
			'pad_top_bot_title' => '4',
			'pad_left_right_title' => '8',
			'color_text_bl' => 'fefefe',
			'bg_bl' => 'f76565',
			'pad_bl' => '15',

		 );
		$instance = wp_parse_args( (array) $instance, $defaults );		
        ?>

<div style="background: #fff; margin-bottom: 10px; padding: 10px; border: 1px solid #e1e1e1; -webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px;">		
<p>
<label style="font-weight: bold;" for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title') ?></label>
<input class="widefat" style="margin-top: 2px; background: #<?php echo $instance['bg_title_bl']; ?>; color: #<?php echo $instance['color_title_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('color_title_bl'); ?>"><?php _e('Цвет текста заголовка'); ?></label>
<input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_title_bl']; ?>; color: #<?php echo $instance['color_title_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id('color_title_bl'); ?>" name="<?php echo $this->get_field_name('color_title_bl'); ?>" value="<?php echo $instance['color_title_bl']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('bg_title_bl'); ?>"><?php _e('Цвет фона заголовка'); ?></label>
<input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_title_bl']; ?>; color: #<?php echo $instance['color_title_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id('bg_title_bl'); ?>" name="<?php echo $this->get_field_name('bg_title_bl'); ?>" value="<?php echo $instance['bg_title_bl']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('pad_top_bot_title'); ?>"><?php _e('Верхний и нижний отступ текста (px)'); ?></label>
<input class="widefat" style="float: right; width:30%;" id="<?php echo $this->get_field_id('pad_top_bot_title'); ?>" name="<?php echo $this->get_field_name('pad_top_bot_title'); ?>" value="<?php echo $instance['pad_top_bot_title']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('pad_left_right_title'); ?>"><?php _e('Левый и правый отступ текста (px)'); ?></label>
<input class="widefat" style="float: right; width:30%;" id="<?php echo $this->get_field_id('pad_left_right_title'); ?>" name="<?php echo $this->get_field_name('pad_left_right_title'); ?>" value="<?php echo $instance['pad_left_right_title']; ?>" />
</p>
</div>


<div style="background: #fff; margin-bottom: 10px; padding: 10px; border: 1px solid #e1e1e1; -webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px;">	
<p>
<label style="font-weight: bold;" for="<?php echo $this->get_field_id('con_bl'); ?>"><?php _e('Текст/HTML-код'); ?></label><br/>
<textarea class="widefat" rows="16" cols="20" style="margin-top: 2px; background: #<?php echo $instance['bg_bl']; ?>; color: #<?php echo $instance['color_text_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id('con_bl'); ?>" name="<?php echo $this->get_field_name('con_bl'); ?>"><?php echo $instance['con_bl']; ?></textarea>
</p>

<p>
<label for="<?php echo $this->get_field_id('color_text_bl'); ?>"><?php _e('Цвет текста:'); ?></label>
<input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_bl']; ?>; color: #<?php echo $instance['color_text_bl']; ?>; border: 0;" name="<?php echo $this->get_field_name('color_text_bl'); ?>" value="<?php echo $instance['color_text_bl']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('bg_bl'); ?>"><?php _e('Цвет фона блока:'); ?></label>
<input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_bl']; ?>; color: #<?php echo $instance['color_text_bl']; ?>; border: 0;" name="<?php echo $this->get_field_name('bg_bl'); ?>" value="<?php echo $instance['bg_bl']; ?>" />
</p>

<p>
<label for="<?php echo $this->get_field_id('pad_bl'); ?>"><?php _e('Отступ блока (px)'); ?></label>
<input class="widefat" style="float: right; width:30%;" id="<?php echo $this->get_field_id('pad_bl'); ?>" name="<?php echo $this->get_field_name('pad_bl'); ?>" value="<?php echo $instance['pad_bl']; ?>" />
</p>

<p>
<input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox" <?php checked(isset($instance['filter']) ? $instance['filter'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>"><?php _e('Automatically add paragraphs'); ?></label>
</p>
</div>

	<?php 
    }

}
?>